/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;

public interface DownloadService {
    public static final String EVENT_NAME = "download";
    public static final String NXFILE = "nxfile";
    public static final String NXDOWNLOADINFO = "nxdownloadinfo";
    public static final String NXBLOBSTATUS = "nxblobstatus";
    public static final String NXBIGBLOB = "nxbigblob";
    @Deprecated
    public static final String NXBIGZIPFILE = "nxbigzipfile";
    @Deprecated
    public static final String NXBIGFILE = "nxbigfile";
    public static final String BLOBHOLDER_PREFIX = "blobholder:";
    public static final String BLOBHOLDER_0 = "blobholder:0";
    public static final String TRANSIENT_STORE_PARAM_ERROR = "error";
    public static final String TRANSIENT_STORE_PARAM_PROGRESS = "progress";
    public static final String TRANSIENT_STORE_STORE_NAME = "download";
    public static final String EXTENDED_INFO_RENDITION = "rendition";
    public static final String REQUEST_ATTR_DOWNLOAD_REASON = "nuxeo.download.reason";
    public static final String REQUEST_ATTR_DOWNLOAD_RENDITION = "nuxeo.download.rendition";

    public String storeBlobs(List<Blob> var1);

    public String getDownloadUrl(DocumentModel var1, String var2, String var3);

    public String getDownloadUrl(String var1, String var2, String var3, String var4, String var5);

    public String getDownloadUrl(String var1, String var2, String var3, String var4);

    public String getDownloadUrl(String var1);

    public Blob resolveBlobFromDownloadUrl(String var1);

    public void handleDownload(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4) throws IOException;

    @Deprecated
    public void downloadBlobStatus(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4) throws IOException;

    public void downloadBlob(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4) throws IOException;

    @Deprecated
    public void downloadBlob(HttpServletRequest var1, HttpServletResponse var2, DocumentModel var3, String var4, Blob var5, String var6, String var7) throws IOException;

    @Deprecated
    public void downloadBlob(HttpServletRequest var1, HttpServletResponse var2, DocumentModel var3, String var4, Blob var5, String var6, String var7, Map<String, Serializable> var8) throws IOException;

    @Deprecated
    public void downloadBlob(HttpServletRequest var1, HttpServletResponse var2, DocumentModel var3, String var4, Blob var5, String var6, String var7, Map<String, Serializable> var8, Boolean var9) throws IOException;

    @Deprecated
    public void downloadBlob(HttpServletRequest var1, HttpServletResponse var2, DocumentModel var3, String var4, Blob var5, String var6, String var7, Map<String, Serializable> var8, Boolean var9, Consumer<ByteRange> var10) throws IOException;

    public void downloadBlob(DownloadContext var1) throws IOException;

    public void transferBlobWithByteRange(Blob var1, ByteRange var2, Supplier<OutputStream> var3);

    @Deprecated
    default public void logDownload(DocumentModel doc, String blobXPath, String filename, String reason, Map<String, Serializable> extendedInfos) {
        this.logDownload(null, doc, blobXPath, filename, reason, extendedInfos);
    }

    public void logDownload(HttpServletRequest var1, DocumentModel var2, String var3, String var4, String var5, Map<String, Serializable> var6);

    public Blob resolveBlob(DocumentModel var1, String var2);

    public Blob resolveBlob(DocumentModel var1);

    public boolean checkPermission(DocumentModel var1, String var2, Blob var3, String var4, Map<String, Serializable> var5);

    public static class DownloadContext {
        protected final HttpServletRequest request;
        protected final HttpServletResponse response;
        protected final DocumentModel doc;
        protected final String xpath;
        protected final Blob blob;
        protected final String filename;
        protected final String reason;
        protected final Map<String, Serializable> extendedInfos;
        protected final Boolean inline;
        protected final Consumer<ByteRange> blobTransferer;
        protected final Calendar lastModified;

        public DownloadContext(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason, Map<String, Serializable> extendedInfos, Boolean inline, Consumer<ByteRange> blobTransferer, Calendar lastModified) {
            this.request = request;
            this.response = response;
            this.doc = doc;
            this.xpath = xpath;
            this.blob = blob;
            this.filename = filename;
            this.reason = reason;
            this.extendedInfos = extendedInfos;
            this.inline = inline;
            this.blobTransferer = blobTransferer;
            this.lastModified = lastModified;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public DocumentModel getDocumentModel() {
            return this.doc;
        }

        public String getXPath() {
            return this.xpath;
        }

        public Blob getBlob() {
            return this.blob;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getReason() {
            return this.reason;
        }

        public Map<String, Serializable> getExtendedInfos() {
            return this.extendedInfos;
        }

        public Boolean getInline() {
            return this.inline;
        }

        public Consumer<ByteRange> getBlobTransferer() {
            return this.blobTransferer;
        }

        public Calendar getLastModified() {
            return this.lastModified;
        }

        public static Builder builder(HttpServletRequest request, HttpServletResponse response) {
            return new Builder(request, response);
        }

        public static class Builder {
            protected final HttpServletRequest request;
            protected final HttpServletResponse response;
            protected DocumentModel doc;
            protected String xpath;
            protected Blob blob;
            protected String filename;
            protected String reason;
            protected Map<String, Serializable> extendedInfos;
            protected Boolean inline;
            protected Consumer<ByteRange> blobTransferer;
            protected Calendar lastModified;

            public Builder(HttpServletRequest request, HttpServletResponse response) {
                this.request = request;
                this.response = response;
            }

            public Builder doc(DocumentModel doc) {
                this.doc = doc;
                return this;
            }

            public Builder xpath(String xpath) {
                this.xpath = xpath;
                return this;
            }

            public Builder blob(Blob blob) {
                this.blob = blob;
                return this;
            }

            public Builder filename(String filename) {
                this.filename = filename;
                return this;
            }

            public Builder reason(String reason) {
                this.reason = reason;
                return this;
            }

            public Builder extendedInfos(Map<String, Serializable> extendedInfos) {
                this.extendedInfos = extendedInfos;
                return this;
            }

            public Builder inline(Boolean inline) {
                this.inline = inline;
                return this;
            }

            public Builder blobTransferer(Consumer<ByteRange> blobTransferer) {
                this.blobTransferer = blobTransferer;
                return this;
            }

            public Builder lastModified(Calendar lastModified) {
                this.lastModified = lastModified;
                return this;
            }

            public DownloadContext build() {
                return new DownloadContext(this.request, this.response, this.doc, this.xpath, this.blob, this.filename, this.reason, this.extendedInfos, this.inline, this.blobTransferer, this.lastModified);
            }
        }
    }

    public static class ByteRange {
        private final long start;
        private final long end;

        public ByteRange(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public long getLength() {
            return this.end - this.start + 1L;
        }
    }
}

