/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderAdapterService;
import org.nuxeo.ecm.core.api.impl.blob.AsyncBlob;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.DefaultBinaryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.io.download.BufferingServletOutputStream;
import org.nuxeo.ecm.core.io.download.DefaultRedirectResolver;
import org.nuxeo.ecm.core.io.download.DownloadBlobInfo;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.core.io.download.DownloadPermissionDescriptor;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.io.download.RedirectResolver;
import org.nuxeo.ecm.core.io.download.RedirectResolverDescriptor;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DownloadServiceImpl
extends DefaultComponent
implements DownloadService {
    private static final Logger log = LogManager.getLogger(DownloadServiceImpl.class);
    public static final String XP_PERMISSIONS = "permissions";
    public static final String XP_REDIRECT_RESOLVER = "redirectResolver";
    protected static final int DOWNLOAD_BUFFER_SIZE = 524288;
    private static final String NUXEO_VIRTUAL_HOST = "nuxeo-virtual-host";
    private static final String VH_PARAM = "nuxeo.virtual.host";
    private static final String FORCE_NO_CACHE_ON_MSIE = "org.nuxeo.download.force.nocache.msie";
    private static final String RUN_FUNCTION = "run";
    private static final Pattern FILENAME_SANITIZATION_REGEX = Pattern.compile(";\\w+=.*");
    private static final String DC_MODIFIED = "dc:modified";
    private static final String MD5 = "MD5";
    protected ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    protected RedirectResolver redirectResolver;
    protected static final String CHEMISTRY_HEAD_REQUEST_CLASS = "HEADHttpServletRequestWrapper";

    public void start(ComponentContext context) {
        super.start(context);
        List descriptors = this.getDescriptors(XP_REDIRECT_RESOLVER);
        if (!descriptors.isEmpty()) {
            RedirectResolverDescriptor descriptor = (RedirectResolverDescriptor)descriptors.get(descriptors.size() - 1);
            try {
                this.redirectResolver = descriptor.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error("Unable to instantiate redirectResolver", (Throwable)e);
            }
        }
        if (this.redirectResolver == null) {
            this.redirectResolver = new DefaultRedirectResolver();
        }
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.redirectResolver = null;
    }

    @Override
    public String storeBlobs(List<Blob> blobs) {
        if (blobs.size() > 1) {
            throw new IllegalArgumentException("multipart download not yet implemented");
        }
        TransientStore ts = ((TransientStoreService)Framework.getService(TransientStoreService.class)).getStore("download");
        String storeKey = UUID.randomUUID().toString();
        ts.putBlobs(storeKey, blobs);
        ts.setCompleted(storeKey, true);
        return storeKey;
    }

    @Override
    public String getDownloadUrl(DocumentModel doc, String xpath, String filename) {
        return this.getDownloadUrl(doc.getRepositoryName(), doc.getId(), xpath, filename, doc.getChangeToken());
    }

    @Override
    public String getDownloadUrl(String repositoryName, String docId, String xpath, String filename) {
        return this.getDownloadUrl(repositoryName, docId, xpath, filename, null);
    }

    @Override
    public String getDownloadUrl(String repositoryName, String docId, String xpath, String filename, String changeToken) {
        StringBuilder sb = new StringBuilder();
        sb.append("nxfile");
        sb.append("/").append(repositoryName);
        sb.append("/").append(docId);
        if (xpath != null) {
            sb.append("/").append(xpath);
            if (filename != null) {
                filename = this.getSanitizedFilenameWithoutPath(filename);
                sb.append("/").append(URIUtils.quoteURIPathComponent((String)filename, (boolean)true));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)changeToken)) {
            try {
                sb.append("?").append("changeToken").append("=").append(URLEncoder.encode(changeToken, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("Cannot append changeToken", (Throwable)e);
            }
        }
        return sb.toString();
    }

    protected String getSanitizedFilenameWithoutPath(String filename) {
        int sep = Math.max(filename.lastIndexOf(92), filename.lastIndexOf(47));
        if (sep != -1) {
            filename = filename.substring(sep + 1);
        }
        return FILENAME_SANITIZATION_REGEX.matcher(filename).replaceAll("");
    }

    @Override
    public String getDownloadUrl(String storeKey) {
        return "nxbigblob/" + storeKey;
    }

    protected Pair<String, Action> getDownloadPathAndAction(String path) {
        int slash;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((slash = path.indexOf(47)) < 0) {
            return null;
        }
        path = path.replaceFirst("\\?.*$", "");
        String type = path.substring(0, slash);
        String downloadPath = path.substring(slash + 1);
        switch (type) {
            case "nxdownloadinfo": {
                return Pair.of((Object)downloadPath, (Object)((Object)Action.INFO));
            }
            case "nxfile": 
            case "nxbigfile": {
                return Pair.of((Object)downloadPath, (Object)((Object)Action.DOWNLOAD_FROM_DOC));
            }
            case "nxbigzipfile": 
            case "nxbigblob": {
                return Pair.of((Object)downloadPath, (Object)((Object)Action.DOWNLOAD));
            }
            case "nxblobstatus": {
                return Pair.of((Object)downloadPath, (Object)((Object)Action.BLOBSTATUS));
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob resolveBlobFromDownloadUrl(String downloadURL) {
        Pair<String, Action> pair = this.getDownloadPathAndAction(downloadURL);
        if (pair == null) {
            return null;
        }
        String downloadPath = (String)pair.getLeft();
        try {
            DownloadBlobInfo downloadBlobInfo = new DownloadBlobInfo(downloadPath);
            try (CloseableCoreSession session = CoreInstance.openCoreSession((String)downloadBlobInfo.repository);){
                Blob blob;
                IdRef docRef = new IdRef(downloadBlobInfo.docId);
                if (!session.exists((DocumentRef)docRef)) {
                    Blob blob2 = null;
                    return blob2;
                }
                DocumentModel doc = session.getDocument((DocumentRef)docRef);
                if (!this.checkPermission(doc, downloadBlobInfo.xpath, blob = this.resolveBlob(doc, downloadBlobInfo.xpath), null, null)) {
                    Blob blob3 = null;
                    return blob3;
                }
                Blob blob4 = blob;
                return blob4;
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void handleDownload(HttpServletRequest req, HttpServletResponse resp, String baseUrl, String path) throws IOException {
        Pair<String, Action> pair = this.getDownloadPathAndAction(path);
        if (pair == null) {
            resp.sendError(404, "Invalid URL syntax");
            return;
        }
        String downloadPath = (String)pair.getLeft();
        Action action = (Action)((Object)pair.getRight());
        switch (action) {
            case INFO: {
                this.handleDownload(req, resp, downloadPath, baseUrl, true);
                break;
            }
            case DOWNLOAD_FROM_DOC: {
                this.handleDownload(req, resp, downloadPath, baseUrl, false);
                break;
            }
            case DOWNLOAD: {
                this.downloadBlob(req, resp, downloadPath, "download");
                break;
            }
            case BLOBSTATUS: {
                this.downloadBlobStatus(req, resp, downloadPath, "download");
                break;
            }
            default: {
                resp.sendError(404, "Invalid URL syntax");
            }
        }
    }

    protected static boolean isHead(HttpServletRequest request) {
        return "HEAD".equals(request.getMethod()) || request.getClass().getSimpleName().equals(CHEMISTRY_HEAD_REQUEST_CLASS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleDownload(HttpServletRequest req, HttpServletResponse resp, String downloadPath, String baseUrl, boolean info) throws IOException {
        DownloadBlobInfo downloadBlobInfo;
        boolean tx = false;
        try {
            downloadBlobInfo = new DownloadBlobInfo(downloadPath);
        }
        catch (IllegalArgumentException e) {
            resp.sendError(404, "Invalid URL syntax");
            return;
        }
        try {
            if (!TransactionHelper.isTransactionActive()) {
                tx = TransactionHelper.startTransaction();
            }
            String xpath = downloadBlobInfo.xpath;
            String filename = downloadBlobInfo.filename;
            try (CloseableCoreSession session = CoreInstance.openCoreSession((String)downloadBlobInfo.repository);){
                IdRef docRef = new IdRef(downloadBlobInfo.docId);
                if (!session.exists((DocumentRef)docRef)) {
                    NuxeoPrincipal principal = NuxeoPrincipal.getCurrent();
                    if (principal != null && principal.isAnonymous()) {
                        throw new DocumentSecurityException("Authentication is needed for downloading the blob");
                    }
                    resp.sendError(404, "No document found");
                    return;
                }
                DocumentModel doc = session.getDocument((DocumentRef)docRef);
                if (info) {
                    Blob blob = this.resolveBlob(doc, xpath);
                    if (blob == null) {
                        resp.sendError(404, "No blob found");
                        return;
                    }
                    String downloadUrl = baseUrl + this.getDownloadUrl(doc, xpath, filename);
                    String result = blob.getMimeType() + ":" + URLEncoder.encode(blob.getFilename(), "UTF-8") + ":" + downloadUrl;
                    resp.setContentType("text/plain");
                    if (DownloadServiceImpl.isHead(req)) return;
                    resp.getWriter().write(result);
                    resp.getWriter().flush();
                    return;
                }
                DownloadService.DownloadContext context = DownloadService.DownloadContext.builder(req, resp).doc(doc).xpath(xpath).filename(filename).reason("download").build();
                this.downloadBlob(context);
                return;
            }
        }
        catch (NuxeoException e) {
            if (!tx) throw new IOException(e);
            TransactionHelper.setTransactionRollbackOnly();
            throw new IOException(e);
        }
        finally {
            if (tx) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    @Override
    public void downloadBlobStatus(HttpServletRequest request, HttpServletResponse response, String key, String reason) throws IOException {
        this.downloadBlob(request, response, key, reason, true);
    }

    @Override
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, String key, String reason) throws IOException {
        this.downloadBlob(request, response, key, reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadBlob(HttpServletRequest request, HttpServletResponse response, String key, String reason, boolean status) throws IOException {
        Serializable progress;
        TransientStore ts = ((TransientStoreService)Framework.getService(TransientStoreService.class)).getStore("download");
        if (!ts.exists(key)) {
            response.sendError(404);
            return;
        }
        List blobs = ts.getBlobs(key);
        if (blobs == null || blobs.isEmpty()) {
            response.sendError(404);
            return;
        }
        if (blobs.size() > 1) {
            throw new IllegalArgumentException("multipart download not yet implemented");
        }
        if (ts.getParameter(key, "error") != null) {
            response.sendError(500, (String)((Object)ts.getParameter(key, "error")));
            return;
        }
        boolean isCompleted = ts.isCompleted(key);
        if (!status && !isCompleted) {
            response.setStatus(202);
            return;
        }
        Object blob = status ? new AsyncBlob(key, isCompleted, (progress = ts.getParameter(key, "progress")) != null ? (Integer)progress : -1) : (Blob)blobs.get(0);
        try {
            DownloadService.DownloadContext context = DownloadService.DownloadContext.builder(request, response).blob((Blob)blob).reason(reason).build();
            this.downloadBlob(context);
        }
        finally {
            if (!status) {
                ts.remove(key);
            }
        }
    }

    @Override
    @Deprecated
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason) throws IOException {
        DownloadService.DownloadContext context = DownloadService.DownloadContext.builder(request, response).doc(doc).xpath(xpath).blob(blob).filename(filename).reason(reason).build();
        this.downloadBlob(context);
    }

    @Override
    @Deprecated
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason, Map<String, Serializable> extendedInfos) throws IOException {
        DownloadService.DownloadContext context = DownloadService.DownloadContext.builder(request, response).doc(doc).xpath(xpath).blob(blob).filename(filename).reason(reason).extendedInfos(extendedInfos).build();
        this.downloadBlob(context);
    }

    @Override
    @Deprecated
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason, Map<String, Serializable> extendedInfos, Boolean inline) throws IOException {
        DownloadService.DownloadContext context = DownloadService.DownloadContext.builder(request, response).doc(doc).xpath(xpath).blob(blob).filename(filename).reason(reason).extendedInfos(extendedInfos).inline(inline).build();
        this.downloadBlob(context);
    }

    @Override
    @Deprecated
    public void downloadBlob(HttpServletRequest request, HttpServletResponse response, DocumentModel doc, String xpath, Blob blob, String filename, String reason, Map<String, Serializable> extendedInfos, Boolean inline, Consumer<DownloadService.ByteRange> blobTransferer) throws IOException {
        DownloadService.DownloadContext context = DownloadService.DownloadContext.builder(request, response).doc(doc).xpath(xpath).blob(blob).filename(filename).reason(reason).extendedInfos(extendedInfos).inline(inline).blobTransferer(blobTransferer).build();
        this.downloadBlob(context);
    }

    @Override
    public void downloadBlob(DownloadService.DownloadContext context) throws IOException {
        Calendar lastModified;
        Map<String, Serializable> extendedInfos;
        String filename;
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        DocumentModel doc = context.getDocumentModel();
        String xpath = context.getXPath();
        Blob blob = context.getBlob();
        if (blob == null) {
            if (doc == null) {
                throw new NuxeoException("No doc specified");
            }
            blob = this.resolveBlob(doc, xpath);
            if (blob == null) {
                response.sendError(404, "No blob found");
                return;
            }
        }
        if ((filename = context.getFilename()) == null) {
            filename = blob.getFilename();
        }
        String reason = context.getReason();
        String requestReason = (String)request.getAttribute("nuxeo.download.reason");
        if (requestReason != null) {
            reason = requestReason;
        }
        extendedInfos = (extendedInfos = context.getExtendedInfos()) == null ? new HashMap<String, Serializable>() : new HashMap<String, Serializable>(extendedInfos);
        String requestRendition = (String)request.getAttribute("nuxeo.download.rendition");
        if (requestRendition != null) {
            extendedInfos.put("rendition", (Serializable)((Object)requestRendition));
        }
        Boolean inline = context.getInline();
        Consumer<DownloadService.ByteRange> blobTransferer = context.getBlobTransferer();
        if (blobTransferer == null) {
            Blob fblob = blob;
            blobTransferer = byteRange -> this.transferBlobWithByteRange(fblob, (DownloadService.ByteRange)byteRange, response);
        }
        if ((lastModified = context.getLastModified()) == null && doc != null) {
            try {
                lastModified = (Calendar)doc.getPropertyValue(DC_MODIFIED);
            }
            catch (ClassCastException | PropertyNotFoundException throwable) {
                // empty catch block
            }
        }
        if (!this.checkPermission(doc, xpath, blob, reason, extendedInfos)) {
            response.sendError(403, "Permission denied");
            return;
        }
        URI uri = this.redirectResolver.getURI(blob, BlobManager.UsageHint.DOWNLOAD, request);
        if (uri != null) {
            try {
                extendedInfos.put("redirect", (Serializable)((Object)uri.toString()));
                this.logDownload(request, doc, xpath, filename, reason, extendedInfos);
                response.sendRedirect(uri.toString());
            }
            catch (IOException ioe) {
                DownloadHelper.handleClientDisconnect(ioe);
            }
            return;
        }
        try {
            BlobProvider blobProvider;
            Set<String> wantDigests;
            long length = blob.getLength();
            DownloadService.ByteRange byteRange2 = this.getByteRange(request, length);
            String digest = blob.getDigest();
            String digestAlgorithm = blob.getDigestAlgorithm();
            if (digest == null) {
                digest = DigestUtils.md5Hex((InputStream)blob.getStream());
                digestAlgorithm = MD5;
            }
            if (!(wantDigests = this.getWantDigests(request)).isEmpty()) {
                if (wantDigests.contains(digestAlgorithm.toLowerCase())) {
                    response.setHeader("Digest", digestAlgorithm + "=" + DownloadServiceImpl.hexToBase64(digest));
                }
                if (wantDigests.contains("contentmd5") && byteRange2 == null && MD5.equalsIgnoreCase(digestAlgorithm)) {
                    response.setHeader("Content-MD5", DownloadServiceImpl.hexToBase64(digest));
                }
            }
            this.addCacheControlHeaders(request, response);
            if (lastModified != null) {
                long ifModifiedSince;
                long lastModifiedMillis = lastModified.getTimeInMillis();
                response.setDateHeader("Last-Modified", lastModifiedMillis);
                try {
                    ifModifiedSince = request.getDateHeader("If-Modified-Since");
                }
                catch (IllegalArgumentException e) {
                    log.debug("Invalid If-Modified-Since header", (Throwable)e);
                    ifModifiedSince = -1L;
                }
                if (ifModifiedSince != -1L && ifModifiedSince >= lastModifiedMillis) {
                    response.sendError(304);
                    return;
                }
            }
            String etag = "\"" + digest + "\"";
            response.setHeader("ETag", etag);
            String ifNoneMatch = request.getHeader("If-None-Match");
            if (ifNoneMatch != null) {
                boolean match = false;
                if (ifNoneMatch.equals("*")) {
                    match = true;
                } else {
                    for (String previousEtag : StringUtils.split((String)ifNoneMatch, (String)", ")) {
                        if (!previousEtag.equals(etag)) continue;
                        match = true;
                        break;
                    }
                }
                if (match) {
                    String method = request.getMethod();
                    if (method.equals("GET") || method.equals("HEAD")) {
                        response.sendError(304);
                    } else {
                        response.sendError(412);
                    }
                    return;
                }
            }
            if (StringUtils.isBlank((CharSequence)filename)) {
                filename = (String)StringUtils.defaultIfBlank((CharSequence)blob.getFilename(), (CharSequence)"file");
            }
            String contentDisposition = DownloadHelper.getRFC2231ContentDisposition(request, filename, inline);
            response.setHeader("Content-Disposition", contentDisposition);
            response.setContentType(blob.getMimeType());
            if (StringUtils.isNotBlank((CharSequence)blob.getEncoding())) {
                try {
                    response.setCharacterEncoding(blob.getEncoding());
                }
                catch (IllegalArgumentException method) {
                    // empty catch block
                }
            }
            response.setHeader("Accept-Ranges", "bytes");
            if (byteRange2 != null) {
                response.setHeader("Content-Range", "bytes " + byteRange2.getStart() + "-" + byteRange2.getEnd() + "/" + length);
                response.setStatus(206);
            }
            long contentLength = byteRange2 == null ? length : byteRange2.getLength();
            response.setContentLengthLong(contentLength);
            if (byteRange2 == null || byteRange2.getStart() == 0L) {
                this.logDownload(request, doc, xpath, filename, reason, extendedInfos);
            }
            Object xAccelLocation = request.getHeader("X-Accel-Location");
            if (Framework.isBooleanPropertyTrue((String)"nuxeo.nginx.accel.enabled") && StringUtils.isNotEmpty((CharSequence)xAccelLocation) && (blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blob)) != null && blobProvider.getBinaryManager() instanceof DefaultBinaryManager) {
                DefaultBinaryManager binaryManager = (DefaultBinaryManager)blobProvider.getBinaryManager();
                String relative = binaryManager.getStorageDir().toURI().relativize(blob.getFile().toURI()).getPath();
                xAccelLocation = ((String)xAccelLocation).endsWith("/") ? (String)xAccelLocation + relative : (String)xAccelLocation + "/" + relative;
                response.setHeader("X-Accel-Redirect", (String)xAccelLocation);
                return;
            }
            if (!DownloadServiceImpl.isHead(request)) {
                blobTransferer.accept(byteRange2);
            }
        }
        catch (UncheckedIOException e) {
            DownloadHelper.handleClientDisconnect(e.getCause());
        }
        catch (IOException ioe) {
            DownloadHelper.handleClientDisconnect(ioe);
        }
    }

    protected DownloadService.ByteRange getByteRange(HttpServletRequest request, long length) {
        String range = request.getHeader("Range");
        if (StringUtils.isBlank((CharSequence)range)) {
            return null;
        }
        DownloadService.ByteRange byteRange = DownloadHelper.parseRange(range, length);
        if (byteRange == null) {
            log.debug("Invalid byte range received: {}", (Object)range);
        }
        return byteRange;
    }

    protected Set<String> getWantDigests(HttpServletRequest request) {
        Enumeration values = request.getHeaders("Want-Digest");
        if (values == null) {
            return Collections.emptySet();
        }
        HashSet<String> wantDigests = new HashSet<String>();
        for (String value : Collections.list(values)) {
            int semicolon = value.indexOf(59);
            if (semicolon >= 0) {
                value = value.substring(0, semicolon);
            }
            wantDigests.add(value.trim().toLowerCase());
        }
        return wantDigests;
    }

    protected static String hexToBase64(String hexString) {
        try {
            return Base64.encodeBase64String((byte[])Hex.decodeHex((char[])hexString.toCharArray()));
        }
        catch (DecoderException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected void transferBlobWithByteRange(Blob blob, DownloadService.ByteRange byteRange, HttpServletResponse response) {
        this.transferBlobWithByteRange(blob, byteRange, () -> {
            try {
                return response.getOutputStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        try {
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void transferBlobWithByteRange(Blob blob, DownloadService.ByteRange byteRange, Supplier<OutputStream> outputStreamSupplier) {
        try (InputStream in = blob.getStream();){
            OutputStream out = outputStreamSupplier.get();
            BufferingServletOutputStream.stopBuffering(out);
            if (byteRange == null) {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            } else {
                IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)byteRange.getStart(), (long)byteRange.getLength());
            }
            out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String fixXPath(String xpath) {
        return xpath == null ? null : xpath.replace(';', ':');
    }

    @Override
    public Blob resolveBlob(DocumentModel doc) {
        BlobHolderAdapterService blobHolderAdapterService = (BlobHolderAdapterService)Framework.getService(BlobHolderAdapterService.class);
        return blobHolderAdapterService.getBlobHolderAdapter(doc, "download").getBlob();
    }

    @Override
    public Blob resolveBlob(DocumentModel doc, String xpath) {
        Blob blob;
        if (xpath == null) {
            return this.resolveBlob(doc);
        }
        if ((xpath = this.fixXPath(xpath)).startsWith("blobholder:")) {
            int index;
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh == null) {
                log.debug("{} is not a BlobHolder", (Object)doc);
                return null;
            }
            String suffix = xpath.substring("blobholder:".length());
            try {
                index = Integer.parseInt(suffix);
            }
            catch (NumberFormatException e) {
                log.debug(e.getMessage());
                return null;
            }
            if (!suffix.equals(Integer.toString(index))) {
                log.debug("Non-canonical index: {}", (Object)suffix);
                return null;
            }
            blob = index == 0 ? bh.getBlob() : (Blob)bh.getBlobs().get(index);
        } else {
            if (!xpath.contains(":")) {
                log.debug("Non-canonical xpath: {}", (Object)xpath);
                return null;
            }
            try {
                blob = (Blob)doc.getPropertyValue(xpath);
            }
            catch (PropertyNotFoundException e) {
                log.debug("Property '{}' not found", (Object)xpath, (Object)e);
                return null;
            }
        }
        return blob;
    }

    @Override
    public boolean checkPermission(DocumentModel doc, String xpath, Blob blob, String reason, Map<String, Serializable> extendedInfos) {
        List descriptors = this.getDescriptors(XP_PERMISSIONS);
        if (descriptors.isEmpty()) {
            return true;
        }
        xpath = this.fixXPath(xpath);
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<Object, Object> ei = extendedInfos == null ? Collections.emptyMap() : extendedInfos;
        NuxeoPrincipal currentUser = NuxeoPrincipal.getCurrent();
        context.put("Document", doc);
        context.put("XPath", xpath);
        context.put("Blob", blob);
        context.put("Reason", reason);
        context.put("Infos", ei);
        context.put("Rendition", ei.get("rendition"));
        context.put("CurrentUser", currentUser);
        for (DownloadPermissionDescriptor descriptor : descriptors) {
            Object result;
            ScriptEngine engine = this.scriptEngineManager.getEngineByName(descriptor.getScriptLanguage());
            if (engine == null) {
                throw new NuxeoException("Engine not found for language: " + descriptor.getScriptLanguage() + " in permission: " + descriptor.name);
            }
            if (!(engine instanceof Invocable)) {
                throw new NuxeoException("Engine " + engine.getClass().getName() + " not Invocable for language: " + descriptor.getScriptLanguage() + " in permission: " + descriptor.name);
            }
            try {
                engine.eval(descriptor.script);
                engine.getBindings(100).putAll((Map<? extends String, ? extends Object>)context);
                result = ((Invocable)((Object)engine)).invokeFunction(RUN_FUNCTION, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new NuxeoException("Script does not contain function: run() in permission: " + descriptor.name, (Throwable)e);
            }
            catch (ScriptException e) {
                log.error("Failed to evaluate script: {}", (Object)descriptor.name, (Object)e);
                continue;
            }
            if (!(result instanceof Boolean)) {
                log.error("Failed to get boolean result from permission: {} ({})", (Object)descriptor.name, result);
                continue;
            }
            boolean allow = (Boolean)result;
            if (allow) continue;
            return false;
        }
        return true;
    }

    protected void addCacheControlHeaders(HttpServletRequest request, HttpServletResponse response) {
        String userAgent = request.getHeader("User-Agent");
        boolean secure = request.isSecure();
        if (!secure) {
            String nvh = request.getHeader(NUXEO_VIRTUAL_HOST);
            if (nvh == null) {
                nvh = Framework.getProperty((String)VH_PARAM);
            }
            if (nvh != null) {
                secure = nvh.startsWith("https");
            }
        }
        if (userAgent != null && userAgent.contains("MSIE") && (secure || DownloadServiceImpl.forceNoCacheOnMSIE())) {
            String cacheControl = "max-age=15, must-revalidate";
            log.debug("Setting Cache-Control: {}", (Object)cacheControl);
            response.setHeader("Cache-Control", cacheControl);
        }
    }

    protected static boolean forceNoCacheOnMSIE() {
        return Framework.isBooleanPropertyTrue((String)FORCE_NO_CACHE_ON_MSIE);
    }

    @Override
    public void logDownload(HttpServletRequest request, DocumentModel doc, String xpath, String filename, String reason, Map<String, Serializable> extendedInfos) {
        EventContextImpl ctx;
        if (request != null && DownloadServiceImpl.isHead(request)) {
            return;
        }
        if ("webengine".equals(reason)) {
            return;
        }
        EventService eventService = (EventService)Framework.getService(EventService.class);
        if (eventService == null) {
            return;
        }
        if (doc != null) {
            CoreSession session = doc.getCoreSession();
            NuxeoPrincipal principal = session == null ? DownloadServiceImpl.getPrincipal() : session.getPrincipal();
            ctx = new DocumentEventContext(session, principal, doc);
            ctx.setProperty("repositoryName", (Serializable)((Object)doc.getRepositoryName()));
            ctx.setProperty("sessionId", (Serializable)((Object)doc.getSessionId()));
        } else {
            ctx = new EventContextImpl(null, DownloadServiceImpl.getPrincipal());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blobXPath", xpath);
        map.put("blobFilename", filename);
        map.put("downloadReason", reason);
        if (extendedInfos != null) {
            map.putAll(extendedInfos);
        }
        ctx.setProperty("extendedInfos", (Serializable)map);
        ctx.setProperty("comment", (Serializable)((Object)filename));
        Event event = ctx.newEvent("download");
        eventService.fireEvent(event);
    }

    protected static NuxeoPrincipal getPrincipal() {
        return NuxeoPrincipal.getCurrent();
    }

    protected static enum Action {
        DOWNLOAD,
        DOWNLOAD_FROM_DOC,
        INFO,
        BLOBSTATUS;

    }
}

