/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.ecm.core.bulk.BulkActionDescriptor;
import org.nuxeo.ecm.core.bulk.BulkActionValidation;
import org.nuxeo.ecm.core.bulk.BulkAdminService;
import org.nuxeo.ecm.core.bulk.computation.BulkScrollerComputation;
import org.nuxeo.ecm.core.bulk.computation.BulkStatusComputation;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.ComputationPolicy;
import org.nuxeo.lib.stream.computation.ComputationPolicyBuilder;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Settings;
import org.nuxeo.lib.stream.computation.StreamManager;
import org.nuxeo.lib.stream.computation.StreamProcessor;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.codec.CodecService;
import org.nuxeo.runtime.model.Descriptor;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.stream.StreamService;

public class BulkAdminServiceImpl
implements BulkAdminService {
    public static final String SCROLLER_NAME = "scroller";
    public static final String STATUS_NAME = "status";
    public static final String BULK_SCROLLER_CONCURRENCY_PROPERTY = "nuxeo.core.bulk.scroller.concurrency";
    public static final String BULK_STATUS_CONCURRENCY_PROPERTY = "nuxeo.core.bulk.status.concurrency";
    public static final String BULK_STATUS_CONTINUE_ON_FAILURE_PROPERTY = "nuxeo.core.bulk.status.continueOnFailure";
    public static final String BULK_STATUS_MAX_RETRIES_PROPERTY = "nuxeo.core.bulk.status.maxRetries";
    public static final String BULK_STATUS_DELAY_PROPERTY = "nuxeo.core.bulk.status.delayMillis";
    public static final String BULK_STATUS_MAX_DELAY_PROPERTY = "nuxeo.core.bulk.status.maxDelayMillis";
    public static final String BULK_SCROLL_SIZE_PROPERTY = "nuxeo.core.bulk.scroller.scroll.size";
    public static final String BULK_SCROLL_KEEP_ALIVE_PROPERTY = "nuxeo.core.bulk.scroller.scroll.keepAliveSeconds";
    public static final String BULK_SCROLL_PRODUCE_IMMEDIATE_PROPERTY = "nuxeo.core.bulk.scroller.produceImmediate";
    public static final String BULK_SCROLL_CONTINUE_ON_FAILURE_PROPERTY = "nuxeo.core.bulk.scroller.continueOnFailure";
    public static final int DEFAULT_STATUS_CONCURRENCY = 1;
    public static final int DEFAULT_STATUS_MAX_RETRIES = 3;
    public static final int DEFAULT_STATUS_DELAY_MILLIS = 500;
    public static final int DEFAULT_STATUS_MAX_DELAY_MILLIS = 10000;
    public static final int DEFAULT_SCROLLER_CONCURRENCY = 1;
    public static final int DEFAULT_SCROLL_SIZE = 100;
    public static final int DEFAULT_SCROLL_KEEP_ALIVE = 60;
    public static final Duration STOP_DURATION = Duration.ofSeconds(1L);
    protected final Map<String, BulkActionDescriptor> descriptors;
    protected final List<String> actions;
    protected StreamProcessor streamProcessor;
    protected Map<String, BulkActionValidation> actionValidations;

    public BulkAdminServiceImpl(List<BulkActionDescriptor> descriptorsList) {
        this.actions = descriptorsList.stream().map(Descriptor::getId).collect(Collectors.toList());
        this.descriptors = new HashMap<String, BulkActionDescriptor>(descriptorsList.size());
        descriptorsList.forEach(descriptor -> this.descriptors.put(descriptor.name, (BulkActionDescriptor)descriptor));
        this.actionValidations = descriptorsList.stream().collect(HashMap::new, (map, desc) -> map.put(desc.name, desc.validationClass != null ? desc.newValidationInstance() : null), HashMap::putAll);
    }

    protected void initProcessor() {
        StreamService service = (StreamService)Framework.getService(StreamService.class);
        ConfigurationService confService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        StreamManager streamManager = service.getStreamManager("bulk");
        CodecService codecService = (CodecService)Framework.getService(CodecService.class);
        Codec codec = codecService.getCodec("avro", Record.class);
        Settings settings = new Settings(1, 1, codec);
        settings.setConcurrency(SCROLLER_NAME, confService.getInteger(BULK_SCROLLER_CONCURRENCY_PROPERTY, 1));
        settings.setConcurrency(STATUS_NAME, confService.getInteger(BULK_STATUS_CONCURRENCY_PROPERTY, 1));
        ComputationPolicy scrollerPolicy = new ComputationPolicyBuilder().continueOnFailure(confService.isBooleanTrue(BULK_SCROLL_CONTINUE_ON_FAILURE_PROPERTY)).retryPolicy(ComputationPolicy.NO_RETRY).build();
        settings.setPolicy(SCROLLER_NAME, scrollerPolicy);
        RetryPolicy retryPolicy = new RetryPolicy().withMaxRetries(confService.getInteger(BULK_STATUS_MAX_RETRIES_PROPERTY, 3)).withBackoff((long)confService.getInteger(BULK_STATUS_DELAY_PROPERTY, 500), (long)confService.getInteger(BULK_STATUS_MAX_DELAY_PROPERTY, 10000), TimeUnit.MILLISECONDS);
        ComputationPolicy statusPolicy = new ComputationPolicyBuilder().continueOnFailure(confService.isBooleanTrue(BULK_STATUS_CONTINUE_ON_FAILURE_PROPERTY)).retryPolicy(retryPolicy).build();
        settings.setPolicy(SCROLLER_NAME, statusPolicy);
        int scrollSize = confService.getInteger(BULK_SCROLL_SIZE_PROPERTY, 100);
        int scrollKeepAlive = confService.getInteger(BULK_SCROLL_KEEP_ALIVE_PROPERTY, 60);
        boolean scrollProduceImmediate = confService.isBooleanTrue(BULK_SCROLL_PRODUCE_IMMEDIATE_PROPERTY);
        this.streamProcessor = streamManager.registerAndCreateProcessor("bulk", this.getTopology(scrollSize, scrollKeepAlive, scrollProduceImmediate), settings);
    }

    protected Topology getTopology(int scrollBatchSize, int scrollKeepAlive, boolean scrollProduceImmediate) {
        ArrayList<String> mapping = new ArrayList<String>();
        mapping.add("i1:command");
        int i = 1;
        for (String action : this.actions) {
            mapping.add(String.format("o%s:%s", i, action));
            ++i;
        }
        mapping.add(String.format("o%s:%s", i, STATUS_NAME));
        return Topology.builder().addComputation(() -> new BulkScrollerComputation(SCROLLER_NAME, this.actions.size() + 1, scrollBatchSize, scrollKeepAlive, scrollProduceImmediate), mapping).addComputation(() -> new BulkStatusComputation(STATUS_NAME), Arrays.asList("i1:status", "o1:done")).build();
    }

    @Override
    public List<String> getActions() {
        return this.actions;
    }

    @Override
    public int getBucketSize(String action) {
        return this.descriptors.get(action).getBucketSize();
    }

    @Override
    public int getBatchSize(String action) {
        return this.descriptors.get(action).getBatchSize();
    }

    @Override
    public boolean isHttpEnabled(String actionId) {
        return this.descriptors.get((Object)actionId).httpEnabled;
    }

    @Override
    public boolean isSequentialCommands(String actionId) {
        return this.descriptors.get((Object)actionId).sequentialCommands;
    }

    @Override
    public BulkActionValidation getActionValidation(String action) {
        return this.actionValidations.get(action);
    }

    public void afterStart() {
        this.initProcessor();
        this.streamProcessor.start();
    }

    public void beforeStop() {
        if (this.streamProcessor != null) {
            this.streamProcessor.stop(STOP_DURATION);
        }
    }
}

