/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.action.computation;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractTransientBlobComputation
extends AbstractComputation {
    private static final Logger log = LogManager.getLogger(AbstractTransientBlobComputation.class);
    private Path temp;

    public void init(ComputationContext context) {
        super.init(context);
        try {
            this.temp = Files.createTempDirectory(this.metadata().name(), new FileAttribute[0]);
            Framework.trackFile((File)this.temp.toFile(), (Object)this.temp);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create temp directory for " + this);
        }
    }

    public AbstractTransientBlobComputation(String name) {
        super(name, 1, 1);
    }

    public AbstractTransientBlobComputation(String name, int nbOutputStreams) {
        super(name, 1, nbOutputStreams);
    }

    protected String getTransientStoreKey(String commandId) {
        return this.metadata.name() + commandId;
    }

    public Blob getBlob(String key, String storeName) {
        Blob blob;
        TransientStore store = ((TransientStoreService)Framework.getService(TransientStoreService.class)).getStore(storeName);
        List blobs = store.getBlobs(key);
        Blob blob2 = blob = blobs == null || blobs.isEmpty() ? null : (Blob)blobs.get(0);
        if (blob == null) {
            log.error("[{}] Could not retrieve blob for key {}", (Object)this.metadata.name(), (Object)key);
        }
        return blob;
    }

    protected void storeBlob(Blob blob, String commandId, String storeName) {
        TransientStore store = ((TransientStoreService)Framework.getService(TransientStoreService.class)).getStore(storeName);
        store.putBlobs(this.getTransientStoreKey(commandId), Collections.singletonList(blob));
        store.setCompleted(this.getTransientStoreKey(commandId), true);
    }

    protected Path createTemp(String commandId) {
        return this.temp.resolve(commandId + ".csv");
    }
}

