/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.descriptors;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutTypeConfigurationImpl;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutDescriptors;
import org.nuxeo.ecm.platform.forms.layout.descriptors.PropertiesDescriptor;
import org.w3c.dom.DocumentFragment;

@XObject(value="configuration")
public class LayoutTypeConfigurationDescriptor {
    private static final Log log = LogFactory.getLog(LayoutTypeConfigurationDescriptor.class);
    @XNode(value="sinceVersion")
    String sinceVersion;
    @XNode(value="deprecatedVersion")
    String deprecatedVersion;
    @XNode(value="title")
    String title;
    String description;
    @XNode(value="demo@id")
    String demoId;
    @XNode(value="demo@previewEnabled")
    boolean demoPreviewEnabled = false;
    @XNodeList(value="supportedModes/mode", type=ArrayList.class, componentType=String.class)
    List<String> supportedModes;
    @XNode(value="handlingLabels")
    boolean handlingLabels = false;
    @XNodeList(value="supportedControls/control", type=ArrayList.class, componentType=String.class)
    List<String> supportedControls;
    @XNode(value="containingForm")
    boolean containingForm = false;
    @XNodeList(value="categories/category", type=ArrayList.class, componentType=String.class)
    List<String> categories;
    @XNodeMap(value="properties/layouts", key="@mode", type=HashMap.class, componentType=LayoutDescriptors.class)
    Map<String, LayoutDescriptors> propertyLayouts;
    @XNodeMap(value="properties/defaultValues", key="@mode", type=HashMap.class, componentType=PropertiesDescriptor.class)
    Map<String, PropertiesDescriptor> defaultPropertyValues;
    Map<String, Serializable> properties;

    public List<String> getCategories() {
        return this.categories;
    }

    public String getDescription() {
        return this.description;
    }

    @XContent(value="description")
    public void setDescription(DocumentFragment descriptionDOM) {
        try {
            OutputFormat of = new OutputFormat();
            of.setOmitXMLDeclaration(true);
            this.description = DOMSerializer.toString((DocumentFragment)descriptionDOM, (OutputFormat)of).trim();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getDemoId() {
        return this.demoId;
    }

    public boolean isDemoPreviewEnabled() {
        return this.demoPreviewEnabled;
    }

    public boolean isHandlingLabels() {
        return this.handlingLabels;
    }

    public List<String> getSupportedControls() {
        return this.supportedControls;
    }

    public boolean isContainingForm() {
        return this.containingForm;
    }

    public Map<String, Serializable> getConfProperties() {
        return this.properties;
    }

    public Serializable getConfProperty(String propName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propName);
    }

    @XNode(value="confProperties")
    public void setConfProperties(PropertiesDescriptor propsDesc) {
        this.properties = propsDesc.getProperties();
    }

    protected List<LayoutDefinition> getLayouts(Map<String, LayoutDescriptors> descs, String mode, String additionalMode) {
        if (descs != null) {
            List<LayoutDefinition> modeLayoutsList;
            LayoutDescriptors modeLayouts;
            List<LayoutDefinition> defaultLayoutsList;
            LayoutDescriptors defaultLayouts;
            ArrayList<LayoutDefinition> res = new ArrayList<LayoutDefinition>();
            if (additionalMode != null && (defaultLayouts = descs.get(additionalMode)) != null && (defaultLayoutsList = defaultLayouts.getLayouts()) != null) {
                res.addAll(defaultLayoutsList);
            }
            if ((modeLayouts = descs.get(mode)) != null && (modeLayoutsList = modeLayouts.getLayouts()) != null) {
                res.addAll(modeLayoutsList);
            }
            return res;
        }
        return null;
    }

    protected Map<String, List<LayoutDefinition>> getLayouts(Map<String, LayoutDescriptors> descs) {
        if (descs != null) {
            HashMap<String, List<LayoutDefinition>> res = new HashMap<String, List<LayoutDefinition>>();
            for (Map.Entry<String, LayoutDescriptors> entry : descs.entrySet()) {
                res.put(entry.getKey(), entry.getValue().getLayouts());
            }
            return res;
        }
        return null;
    }

    public List<LayoutDefinition> getPropertyLayouts(String mode, String additionalMode) {
        return this.getLayouts(this.propertyLayouts, mode, additionalMode);
    }

    public Map<String, List<LayoutDefinition>> getPropertyLayouts() {
        return this.getLayouts(this.propertyLayouts);
    }

    public Map<String, Map<String, Serializable>> getDefaultPropertyValues() {
        if (this.defaultPropertyValues != null) {
            HashMap<String, Map<String, Serializable>> res = new HashMap<String, Map<String, Serializable>>();
            for (Map.Entry<String, PropertiesDescriptor> entry : this.defaultPropertyValues.entrySet()) {
                res.put(entry.getKey(), entry.getValue().getProperties());
            }
            return res;
        }
        return null;
    }

    public String getSinceVersion() {
        return this.sinceVersion;
    }

    public String getDeprecatedVersion() {
        return this.deprecatedVersion;
    }

    public List<String> getSupportedModes() {
        return this.supportedModes;
    }

    public LayoutTypeConfiguration getLayoutTypeConfiguration() {
        LayoutTypeConfigurationImpl res = new LayoutTypeConfigurationImpl();
        res.setSinceVersion(this.getSinceVersion());
        res.setDeprecatedVersion(this.getDeprecatedVersion());
        res.setTitle(this.getTitle());
        res.setDescription(this.getDescription());
        res.setDemoId(this.getDemoId());
        res.setDemoPreviewEnabled(this.isDemoPreviewEnabled());
        res.setSupportedModes(this.getSupportedModes());
        res.setHandlingLabels(this.isHandlingLabels());
        res.setContainingForm(this.isContainingForm());
        res.setCategories(this.getCategories());
        res.setPropertyLayouts(this.getPropertyLayouts());
        res.setDefaultPropertyValues(this.getDefaultPropertyValues());
        res.setSupportedControls(this.getSupportedControls());
        return res;
    }
}

