/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.filemanager.service.extension.FileImporter;
import org.nuxeo.runtime.model.Descriptor;

@XObject(value="plugin")
public class FileImporterDescriptor
implements Descriptor,
Serializable {
    public static final List<String> DEFAULT_FILTER = new ArrayList<String>();
    private static final long serialVersionUID = 1L;
    @XNode(value="@enabled")
    boolean enabled = true;
    @XNode(value="@name")
    protected String name;
    @Deprecated(since="11.1")
    @XNode(value="@class")
    protected String className;
    @XNode(value="@class")
    protected Class<? extends FileImporter> klass;
    @XNode(value="@docType")
    protected String docType;
    @XNodeList(value="filter", type=ArrayList.class, componentType=String.class)
    protected List<String> filters = DEFAULT_FILTER;
    @XNode(value="@filter")
    protected String filter;
    @XNode(value="@order")
    private Integer order;
    @XNode(value="@merge")
    private boolean merge = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated(since="11.1")
    public String getClassName() {
        return this.className;
    }

    @Deprecated(since="11.1")
    public void setClassName(String className) {
        this.className = className;
    }

    public String getDocType() {
        return this.docType;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Integer getOrder() {
        return this.order;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public FileImporter newInstance() {
        try {
            FileImporter fileImporter = this.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            fileImporter.setName(this.name);
            fileImporter.setEnabled(this.enabled);
            fileImporter.setDocType(this.docType);
            fileImporter.setFilters(this.filters);
            fileImporter.setOrder(this.order);
            return fileImporter;
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public String getId() {
        return this.name;
    }

    public Descriptor merge(Descriptor o) {
        FileImporterDescriptor other = (FileImporterDescriptor)o;
        if (!other.merge) {
            return other;
        }
        FileImporterDescriptor merged = new FileImporterDescriptor();
        merged.name = other.name;
        merged.enabled = other.enabled;
        merged.klass = this.defaultValue(other.klass, this.klass);
        merged.className = this.defaultValue(other.className, this.className);
        merged.docType = this.defaultValue(other.docType, this.docType);
        merged.filters = new ArrayList<String>();
        merged.filters.addAll(this.filters);
        merged.filters.addAll(other.filters);
        merged.order = this.defaultValue(other.order, this.order);
        return merged;
    }

    protected <T> T defaultValue(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public boolean doesRemove() {
        return !this.enabled;
    }
}

