/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.runtime.api.Framework;
import redis.clients.jedis.Jedis;

public class RedisLockManager
implements LockManager {
    private static final Log log = LogFactory.getLog(RedisLockManager.class);
    protected final String redisNamespace;
    protected final String repositoryName;
    protected String prefix;
    protected String scriptSetSha;
    protected String scriptRemoveSha;

    public RedisLockManager(String repositoryName) {
        this.repositoryName = repositoryName;
        RedisAdmin redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        this.redisNamespace = redisAdmin.namespace(new String[]{"lock", repositoryName});
        try {
            this.scriptSetSha = redisAdmin.load("org.nuxeo.ecm.core.redis", "set-lock");
            this.scriptRemoveSha = redisAdmin.load("org.nuxeo.ecm.core.redis", "remove-lock");
        }
        catch (IOException cause) {
            throw new NuxeoException("Cannot load lock scripts in redis", (Throwable)cause);
        }
    }

    protected String stringFromLock(Lock lock) {
        if (lock == null) {
            throw new NullPointerException("null lock");
        }
        return lock.getOwner() + ":" + lock.getCreated().getTimeInMillis();
    }

    protected Lock lockFromString(String lockString) {
        if (lockString == null) {
            return null;
        }
        String[] split = lockString.split(":");
        if (split.length != 2 || !StringUtils.isNumeric((CharSequence)split[1])) {
            throw new IllegalArgumentException("Invalid Redis lock : " + lockString + ", should be " + this.redisNamespace + "<id>");
        }
        Calendar created = Calendar.getInstance();
        created.setTimeInMillis(Long.parseLong(split[1]));
        return new Lock(split[0], created);
    }

    public Lock getLock(final String id) {
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        return (Lock)redisExecutor.execute((RedisCallable)new RedisCallable<Lock>(){

            public Lock call(Jedis jedis) {
                String lockString = jedis.get(RedisLockManager.this.redisNamespace + id);
                return RedisLockManager.this.lockFromString(lockString);
            }
        });
    }

    public Lock setLock(String id, Lock lock) {
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        List<CallSite> keys = Collections.singletonList(this.redisNamespace + id);
        List<String> args = Collections.singletonList(this.stringFromLock(lock));
        String lockString = (String)redisExecutor.evalsha(this.scriptSetSha, keys, args);
        return this.lockFromString(lockString);
    }

    public Lock removeLock(String id, String owner) {
        List<String> args;
        List<CallSite> keys;
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        String lockString = (String)redisExecutor.evalsha(this.scriptRemoveSha, keys = Collections.singletonList(this.redisNamespace + id), args = Collections.singletonList(owner == null ? "" : owner));
        Lock lock = this.lockFromString(lockString);
        if (lock != null && owner != null && !owner.equals(lock.getOwner())) {
            lock = new Lock(lock, true);
        }
        return lock;
    }

    public void closeLockManager() {
    }

    public void clearLockManagerCaches() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.repositoryName + ")";
    }
}

