/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.security.Principal;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableObject;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.CoreSessionService;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.LoginComponent;

public class CoreInstance {
    private CoreInstance() {
    }

    public static CloseableCoreSession openCoreSession(String repositoryName) {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal(null));
    }

    public static CloseableCoreSession openCoreSession(String repositoryName, String username) {
        return CoreInstance.openCoreSession(repositoryName, CoreInstance.getPrincipal(username));
    }

    public static CloseableCoreSession openCoreSessionSystem(String repositoryName) {
        return CoreInstance.openCoreSession(repositoryName, new SystemPrincipal(null));
    }

    public static CloseableCoreSession openCoreSessionSystem(String repositoryName, String originatingUsername) {
        return CoreInstance.openCoreSession(repositoryName, new SystemPrincipal(originatingUsername));
    }

    public static CloseableCoreSession openCoreSession(String repositoryName, NuxeoPrincipal principal) {
        if (repositoryName == null) {
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
            repositoryName = repositoryManager.getDefaultRepositoryName();
        }
        return ((CoreSessionService)Framework.getService(CoreSessionService.class)).createCoreSession(repositoryName, principal);
    }

    public CoreSession getSession(String sessionId) {
        return ((CoreSessionService)Framework.getService(CoreSessionService.class)).getCoreSession(sessionId);
    }

    public static void closeCoreSession(CloseableCoreSession session) {
        ((CoreSessionService)Framework.getService(CoreSessionService.class)).releaseCoreSession(session);
    }

    protected static NuxeoPrincipal getPrincipal(String username) {
        if (username != null) {
            return new UserPrincipal(username, new ArrayList<String>(), false, false);
        }
        Principal p = LoginComponent.getCurrentPrincipal();
        if (p != null) {
            if (p instanceof NuxeoPrincipal) {
                return (NuxeoPrincipal)p;
            }
            if (LoginComponent.isSystemLogin((Object)p)) {
                return new SystemPrincipal(p.getName());
            }
            throw new RuntimeException("Unsupported principal: " + p.getClass());
        }
        if (Framework.isTestModeSet()) {
            return new SystemPrincipal(null);
        }
        throw new NuxeoException("Cannot create a CoreSession outside a security context,  login() missing.");
    }

    protected static String getCurrentPrincipalName() {
        NuxeoPrincipal p = NuxeoPrincipal.getCurrent();
        return p == null ? null : p.getName();
    }

    public static <R> R doPrivileged(String repositoryName, final Function<CoreSession, R> function) {
        final MutableObject result = new MutableObject();
        new UnrestrictedSessionRunner(repositoryName, CoreInstance.getCurrentPrincipalName()){

            @Override
            public void run() {
                result.setValue(function.apply(this.session));
            }
        }.runUnrestricted();
        return (R)result.getValue();
    }

    public static <R> R doPrivileged(CoreSession session, final Function<CoreSession, R> function) {
        final MutableObject result = new MutableObject();
        new UnrestrictedSessionRunner(session){

            @Override
            public void run() {
                result.setValue(function.apply(this.session));
            }
        }.runUnrestricted();
        return (R)result.getValue();
    }

    public static void doPrivileged(String repositoryName, final Consumer<CoreSession> consumer) {
        new UnrestrictedSessionRunner(repositoryName, CoreInstance.getCurrentPrincipalName()){

            @Override
            public void run() {
                consumer.accept(this.session);
            }
        }.runUnrestricted();
    }

    public static void doPrivileged(CoreSession session, final Consumer<CoreSession> consumer) {
        new UnrestrictedSessionRunner(session){

            @Override
            public void run() {
                consumer.accept(this.session);
            }
        }.runUnrestricted();
    }
}

