/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.io.api.IOManager;
import org.nuxeo.ecm.platform.io.api.IOResourceAdapter;
import org.nuxeo.ecm.platform.io.descriptors.IOResourceAdapterDescriptor;
import org.nuxeo.ecm.platform.io.impl.IOManagerImpl;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class IOManagerComponent
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName(IOManagerComponent.class.getName());
    public static final String ADAPTERS_EP_NAME = "adapters";
    private static final Log log = LogFactory.getLog(IOManagerComponent.class);
    private final IOManager service = new IOManagerImpl();

    public IOManager getIOManager() {
        return this.service;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(ADAPTERS_EP_NAME)) {
            IOResourceAdapter adapter;
            IOResourceAdapterDescriptor desc = (IOResourceAdapterDescriptor)contribution;
            String name = desc.getName();
            String className = desc.getClassName();
            try {
                adapter = (IOResourceAdapter)IOManagerComponent.class.getClassLoader().loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Caught error when instantiating adapter", (Throwable)e);
                return;
            }
            adapter.setProperties(desc.getProperties());
            IOResourceAdapter existing = this.service.getAdapter(name);
            if (existing != null) {
                log.warn((Object)String.format("Overriding IO Resource adapter definition %s", name));
                this.service.removeAdapter(name);
            }
            this.service.addAdapter(name, adapter);
            log.info((Object)String.format("IO resource adapter %s registered", name));
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't register !", extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(ADAPTERS_EP_NAME)) {
            IOResourceAdapterDescriptor desc = (IOResourceAdapterDescriptor)contribution;
            this.service.removeAdapter(desc.getName());
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't unregister !", extensionPoint));
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IOManager.class)) {
            return (T)this.service;
        }
        return null;
    }
}

