/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.time.Duration;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.lib.stream.computation.ComputationPolicyBuilder;

public class ComputationPolicy {
    public static final RetryPolicy NO_RETRY = new RetryPolicy().withMaxRetries(0);
    public static final ComputationPolicy NONE = new ComputationPolicyBuilder().retryPolicy(NO_RETRY).continueOnFailure(false).build();
    protected final RetryPolicy retryPolicy;
    protected final int batchCapacity;
    protected final Duration batchThreshold;
    protected final boolean skipFailure;
    protected final int skipFirstFailures;

    public ComputationPolicy(ComputationPolicyBuilder builder) {
        this.batchCapacity = builder.batchCapacity;
        this.batchThreshold = builder.batchThreshold;
        this.skipFailure = builder.skipFailure;
        this.retryPolicy = builder.retryPolicy;
        this.skipFirstFailures = builder.skipFirstFailures;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public int getBatchCapacity() {
        return this.batchCapacity;
    }

    public Duration getBatchThreshold() {
        return this.batchThreshold;
    }

    public boolean continueOnFailure() {
        return this.skipFailure;
    }

    public int getSkipFirstFailures() {
        return this.skipFirstFailures;
    }

    @Deprecated
    public boolean isSkipFailure() {
        return this.skipFailure;
    }

    public String toString() {
        return "ComputationPolicy{maxRetries=" + this.retryPolicy.getMaxRetries() + ", delay=" + this.retryPolicy.getDelay() + ", delayMax=" + this.retryPolicy.getMaxDelay() + ", continueOnFailure=" + this.skipFailure + ", batchCapacity=" + this.batchCapacity + ", batchThreshold=" + this.batchThreshold + "}";
    }
}

