/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RerouteExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;

public class CancelAllocationCommand
implements AllocationCommand {
    public static final String NAME = "cancel";
    public static final ParseField COMMAND_NAME_FIELD = new ParseField("cancel", new String[0]);
    private final String index;
    private final int shardId;
    private final String node;
    private final boolean allowPrimary;

    public CancelAllocationCommand(String index, int shardId, String node, boolean allowPrimary) {
        this.index = index;
        this.shardId = shardId;
        this.node = node;
        this.allowPrimary = allowPrimary;
    }

    public CancelAllocationCommand(StreamInput in) throws IOException {
        this.index = in.readString();
        this.shardId = in.readVInt();
        this.node = in.readString();
        this.allowPrimary = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        out.writeString(this.node);
        out.writeBoolean(this.allowPrimary);
    }

    @Override
    public String name() {
        return NAME;
    }

    public String index() {
        return this.index;
    }

    public int shardId() {
        return this.shardId;
    }

    public String node() {
        return this.node;
    }

    public boolean allowPrimary() {
        return this.allowPrimary;
    }

    @Override
    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) {
        DiscoveryNode discoNode = allocation.nodes().resolveNode(this.node);
        ShardRouting shardRouting = null;
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNode routingNode = routingNodes.node(discoNode.getId());
        IndexMetaData indexMetaData = null;
        if (routingNode != null) {
            indexMetaData = allocation.metaData().index(this.index());
            if (indexMetaData == null) {
                throw new IndexNotFoundException(this.index());
            }
            ShardId shardId = new ShardId(indexMetaData.getIndex(), this.shardId());
            shardRouting = routingNode.getByShardId(shardId);
        }
        if (shardRouting == null) {
            if (explain) {
                return new RerouteExplanation(this, allocation.decision(Decision.NO, "cancel_allocation_command", "can't cancel " + this.shardId + ", failed to find it on node " + discoNode, new Object[0]));
            }
            throw new IllegalArgumentException("[cancel_allocation] can't cancel " + this.shardId + ", failed to find it on node " + discoNode);
        }
        if (shardRouting.primary() && !this.allowPrimary && !(shardRouting.initializing() && shardRouting.relocatingNodeId() != null)) {
            if (explain) {
                return new RerouteExplanation(this, allocation.decision(Decision.NO, "cancel_allocation_command", "can't cancel " + this.shardId + " on node " + discoNode + ", shard is primary and " + shardRouting.state().name().toLowerCase(Locale.ROOT), new Object[0]));
            }
            throw new IllegalArgumentException("[cancel_allocation] can't cancel " + this.shardId + " on node " + discoNode + ", shard is primary and " + shardRouting.state().name().toLowerCase(Locale.ROOT));
        }
        routingNodes.failShard(Loggers.getLogger(CancelAllocationCommand.class), shardRouting, new UnassignedInfo(UnassignedInfo.Reason.REROUTE_CANCELLED, null), indexMetaData, allocation.changes());
        allocation.removeAllocationId(shardRouting);
        return new RerouteExplanation(this, allocation.decision(Decision.YES, "cancel_allocation_command", "shard " + this.shardId + " on node " + discoNode + " can be cancelled", new Object[0]));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("index", this.index());
        builder.field("shard", this.shardId());
        builder.field("node", this.node());
        builder.field("allow_primary", this.allowPrimary());
        return builder.endObject();
    }

    public static CancelAllocationCommand fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String index = null;
        int shardId = -1;
        String nodeId = null;
        boolean allowPrimary = false;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("index".equals(currentFieldName)) {
                    index = parser.text();
                    continue;
                }
                if ("shard".equals(currentFieldName)) {
                    shardId = parser.intValue();
                    continue;
                }
                if ("node".equals(currentFieldName)) {
                    nodeId = parser.text();
                    continue;
                }
                if ("allow_primary".equals(currentFieldName) || "allowPrimary".equals(currentFieldName)) {
                    allowPrimary = parser.booleanValue();
                    continue;
                }
                throw new ElasticsearchParseException("[{}] command does not support field [{}]", NAME, currentFieldName);
            }
            throw new ElasticsearchParseException("[{}] command does not support complex json tokens [{}]", NAME, token);
        }
        if (index == null) {
            throw new ElasticsearchParseException("[{}] command missing the index parameter", NAME);
        }
        if (shardId == -1) {
            throw new ElasticsearchParseException("[{}] command missing the shard parameter", NAME);
        }
        if (nodeId == null) {
            throw new ElasticsearchParseException("[{}] command missing the node parameter", NAME);
        }
        return new CancelAllocationCommand(index, shardId, nodeId, allowPrimary);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CancelAllocationCommand other = (CancelAllocationCommand)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.shardId, other.shardId) && Objects.equals(this.node, other.node) && Objects.equals(this.allowPrimary, other.allowPrimary);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.shardId, this.node, this.allowPrimary);
    }
}

