/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.utils;

import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class DateMatcher {
    private static final Pattern YEAR_ONLY_MATCHER = Pattern.compile("^\\d{4}$");
    private static final Pattern MONTH_DIGIT_ONLY_MATCHER = Pattern.compile("^\\d{2}$");
    private static final Pattern YEAR_MONTHS_MATCHER = Pattern.compile("^\\d{4}[_ -:]\\d{2}$");
    private static final Pattern MONTHS_YEAR_MATCHER = Pattern.compile("^\\d{2}[_ -:]\\d{4}$");
    private static final Pattern MONTHS_DAY_YEAR_MATCHER = Pattern.compile("^\\d{2}[_ -:]\\d{2,}[_ -:]\\d{4}$");
    private static final Pattern YEAR_MONTHS_DAY_MATCHER = Pattern.compile("^\\d{4}[_ -:]\\d{2,}[_ -:]\\d{2}$");
    private boolean withYears = false;
    private boolean withMonth = false;
    private boolean withDay = false;
    private final Calendar dateSuggestion;

    private DateMatcher(boolean withYears, boolean withMonth, boolean withDay, Calendar dateSuggestion) {
        this.withYears = withYears;
        this.withMonth = withMonth;
        this.withDay = withDay;
        this.dateSuggestion = dateSuggestion;
    }

    public boolean isWithYears() {
        return this.withYears;
    }

    public void setWithYears(boolean withYears) {
        this.withYears = withYears;
    }

    public boolean isWithMonth() {
        return this.withMonth;
    }

    public void setWithMonth(boolean withMonth) {
        this.withMonth = withMonth;
    }

    public boolean isWitDay() {
        return this.withDay;
    }

    public void setWitDay(boolean witDay) {
        this.withDay = witDay;
    }

    public Calendar getDateSuggestion() {
        return this.dateSuggestion;
    }

    public boolean hasMatch() {
        return this.getDateSuggestion() != null;
    }

    public static Matcher parsingDate(Pattern pattern, String input) {
        return pattern.matcher(input.trim());
    }

    public static DateMatcher fromInput(String input) {
        try {
            return DateMatcher.doFromInput(input);
        }
        catch (NumberFormatException e) {
            return new DateMatcher(false, false, false, null);
        }
    }

    public static DateMatcher doFromInput(String input) {
        Matcher matcher = DateMatcher.parsingDate(YEAR_ONLY_MATCHER, input);
        if (matcher.find()) {
            return new DateMatcher(true, false, false, DateMatcher.dateToInstance(Integer.parseInt(matcher.group()), 1, 1));
        }
        matcher = DateMatcher.parsingDate(MONTH_DIGIT_ONLY_MATCHER, input);
        if (matcher.find()) {
            int month = Integer.parseInt(matcher.group());
            if (month > 12 || month < 1) {
                return new DateMatcher(false, true, false, null);
            }
            return new DateMatcher(false, true, false, DateMatcher.dateToInstance(Calendar.getInstance().get(1), month, 1));
        }
        matcher = DateMatcher.parsingDate(YEAR_MONTHS_MATCHER, input);
        if (matcher.find()) {
            int month = Integer.parseInt(matcher.group().substring(5));
            if (month > 12 || month < 1) {
                return new DateMatcher(true, true, false, null);
            }
            int year = Integer.parseInt(matcher.group().substring(0, 4));
            return new DateMatcher(true, true, false, DateMatcher.dateToInstance(year, month, 1));
        }
        matcher = DateMatcher.parsingDate(MONTHS_YEAR_MATCHER, input);
        if (matcher.find()) {
            int month = Integer.parseInt(matcher.group().substring(0, 2));
            if (month > 12 || month < 1) {
                return new DateMatcher(true, true, false, null);
            }
            int year = Integer.parseInt(matcher.group().substring(3));
            return new DateMatcher(true, true, false, DateMatcher.dateToInstance(year, month, 1));
        }
        matcher = DateMatcher.parsingDate(MONTHS_DAY_YEAR_MATCHER, input);
        if (matcher.find()) {
            int first = Integer.parseInt(matcher.group().substring(0, 2));
            int second = Integer.parseInt(matcher.group().substring(3, 5));
            int year = Integer.parseInt(matcher.group().substring(6));
            int control = first + second;
            if (control < 2 || control > 43 || first < 1 || second < 1) {
                return new DateMatcher(true, true, true, null);
            }
            if (control < 25) {
                return new DateMatcher(true, true, true, DateMatcher.dateToInstance(year, first, second));
            }
            int month = first;
            int day = second;
            if (first > second) {
                month = second;
                day = first;
            }
            Calendar dateToInstance = DateMatcher.dateToInstance(year, month, day);
            return new DateMatcher(true, true, true, dateToInstance);
        }
        matcher = DateMatcher.parsingDate(YEAR_MONTHS_DAY_MATCHER, input);
        if (matcher.find()) {
            int second;
            int year = Integer.parseInt(matcher.group().substring(0, 4));
            int first = Integer.parseInt(matcher.group().substring(5, 7));
            int control = first + (second = Integer.parseInt(matcher.group().substring(8)));
            if (control < 2 || control > 43 || first < 1 || second < 1) {
                return new DateMatcher(true, true, true, null);
            }
            if (control < 25) {
                return new DateMatcher(true, true, true, DateMatcher.dateToInstance(year, first, second));
            }
            int month = first;
            int day = second;
            if (first > second) {
                month = second;
                day = first;
            }
            Calendar dateToInstance = DateMatcher.dateToInstance(year, month, day);
            return new DateMatcher(true, true, true, dateToInstance);
        }
        return new DateMatcher(false, false, false, null);
    }

    protected static Calendar dateToInstance(int year, int month, int day) {
        try {
            return GregorianCalendar.from(ZonedDateTime.of(year, month, day, 12, 0, 0, 0, ZoneOffset.UTC));
        }
        catch (IllegalArgumentException | DateTimeException e) {
            return null;
        }
    }
}

