/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io.documents;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;

@Deprecated
@Provider
@Consumes(value={"application/json"})
public class JSONDocumentModelReader
implements MessageBodyReader<DocumentModel> {
    protected static final Log log = LogFactory.getLog(JSONDocumentModelReader.class);
    @Context
    HttpServletRequest request;
    @Context
    JsonFactory factory;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DocumentModel.class.isAssignableFrom(type);
    }

    public DocumentModel readFrom(Class<DocumentModel> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)entityStream);
        if (content.isEmpty()) {
            throw new NuxeoException("No content in request body", 400);
        }
        try {
            return this.readRequest(content, httpHeaders);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    private DocumentModel readRequest(String content, MultivaluedMap<String, String> httpHeaders) throws IOException {
        return this.readRequest(content, httpHeaders, this.request);
    }

    protected DocumentModel readRequest(String content, MultivaluedMap<String, String> httpHeaders, HttpServletRequest request) throws IOException {
        JsonParser jp = this.factory.createJsonParser(content);
        return JSONDocumentModelReader.readJson(jp, httpHeaders, request);
    }

    public static DocumentModel readJson(JsonParser jp, MultivaluedMap<String, String> httpHeaders, HttpServletRequest request) throws IOException {
        JsonToken tok = jp.nextToken();
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            tok = jp.nextToken();
        }
        SimpleDocumentModel simpleDoc = SimpleDocumentModel.empty();
        String type = null;
        String name = null;
        String uid = null;
        while (tok != null && tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("properties".equals(key)) {
                DocumentHelper.setJSONProperties(null, (DocumentModel)simpleDoc, (Properties)JSONDocumentModelReader.readProperties(jp));
            } else if ("name".equals(key)) {
                name = (String)jp.readValueAs(String.class);
            } else if ("type".equals(key)) {
                type = (String)jp.readValueAs(String.class);
            } else if ("uid".equals(key)) {
                uid = (String)jp.readValueAs(String.class);
            } else if ("entity-type".equals(key)) {
                String entityType = (String)jp.readValueAs(String.class);
                if (!"document".equals(entityType)) {
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
            } else {
                log.debug((Object)("Unknown key: " + key));
                jp.skipChildren();
            }
            tok = jp.nextToken();
        }
        if (tok == null) {
            throw new IllegalArgumentException("Unexpected end of stream.");
        }
        if (StringUtils.isNotBlank(type)) {
            simpleDoc.setType(type);
        }
        if (StringUtils.isNotBlank(name)) {
            simpleDoc.setPathInfo(null, name);
        }
        if (uid != null) {
            CoreSession session = SessionFactory.getSession((HttpServletRequest)request);
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(uid));
            JSONDocumentModelReader.applyPropertyValues((DocumentModel)simpleDoc, doc);
            return doc;
        }
        return simpleDoc;
    }

    static Properties readProperties(JsonParser jp) throws IOException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        return new Properties(node);
    }

    private static Serializable decodeBlob(Serializable data) {
        if (data instanceof Blob) {
            return data;
        }
        return null;
    }

    public static void applyPropertyValues(DocumentModel src, DocumentModel dst) {
        for (String schema : src.getSchemas()) {
            DataModelImpl dataModel = (DataModelImpl)dst.getDataModel(schema);
            DataModelImpl fromDataModel = (DataModelImpl)src.getDataModel(schema);
            for (String field : fromDataModel.getDirtyFields()) {
                Serializable data = (Serializable)fromDataModel.getData(field);
                try {
                    if (!(dataModel.getDocumentPart().get(field) instanceof BlobProperty)) {
                        dataModel.setData(field, (Object)data);
                        continue;
                    }
                    dataModel.setData(field, (Object)JSONDocumentModelReader.decodeBlob(data));
                }
                catch (PropertyNotFoundException e) {
                    log.warn((Object)String.format("Trying to deserialize unexistent field : {%s}", field));
                }
            }
        }
    }
}

