/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.URLBlob;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteTableElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingPersister;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.LockableDocumentRoute;
import org.nuxeo.ecm.platform.routing.api.RouteFolderElement;
import org.nuxeo.ecm.platform.routing.api.RouteModelResourceType;
import org.nuxeo.ecm.platform.routing.api.RouteTable;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteAlredayLockedException;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteNotLockedException;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.ecm.platform.routing.core.audit.RoutingAuditHelper;
import org.nuxeo.ecm.platform.routing.core.impl.ChainToTypeMappingDescriptor;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.core.impl.PersisterDescriptor;
import org.nuxeo.ecm.platform.routing.core.listener.RouteModelsInitializator;
import org.nuxeo.ecm.platform.routing.core.registries.RouteTemplateResourceRegistry;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.helpers.TaskActorsHelper;
import org.nuxeo.ecm.platform.task.core.service.TaskEventNotificationHelper;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.RuntimeContext;

public class DocumentRoutingServiceImpl
extends DefaultComponent
implements DocumentRoutingService {
    private static Logger log = LogManager.getLogger(DocumentRoutingServiceImpl.class);
    private static final String AVAILABLE_ROUTES_QUERY = String.format("SELECT * FROM %s", "DocumentRoute");
    private static final String AVAILABLE_ROUTES_MODEL_QUERY = String.format("SELECT * FROM %s WHERE ecm:currentLifeCycleState = '%s'", "DocumentRoute", "validated");
    private static final String ROUTE_MODEL_DOC_ID_WITH_ID_QUERY = String.format("SELECT ecm:uuid FROM %s WHERE ecm:name = %%s AND ecm:currentLifeCycleState = 'validated' AND ecm:isVersion = 0  AND ecm:isProxy = 0 ", "DocumentRoute");
    private static final String ORDERED_CHILDREN_QUERY = "SELECT * FROM Document WHERE ecm:parentId = '%s' AND ecm:isVersion = 0 AND ecm:isTrashed = 0 ORDER BY ecm:pos";
    public static final String CHAINS_TO_TYPE_XP = "chainsToType";
    public static final String PERSISTER_XP = "persister";
    public static final String ACTOR_ACE_CREATOR = "Workflow";
    public static final String ROUTE_MODELS_IMPORTER_XP = "routeModelImporter";
    protected Map<String, String> typeToChain = new HashMap<String, String>();
    protected Map<String, String> undoChainIdFromRunning = new HashMap<String, String>();
    protected Map<String, String> undoChainIdFromDone = new HashMap<String, String>();
    protected DocumentRoutingPersister persister;
    protected RouteTemplateResourceRegistry routeResourcesRegistry = new RouteTemplateResourceRegistry();
    protected RepositoryInitializationHandler repositoryInitializationHandler;
    private Cache<String, String> modelsChache;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CHAINS_TO_TYPE_XP.equals(extensionPoint)) {
            ChainToTypeMappingDescriptor desc = (ChainToTypeMappingDescriptor)contribution;
            this.typeToChain.put(desc.getDocumentType(), desc.getChainId());
            this.undoChainIdFromRunning.put(desc.getDocumentType(), desc.getUndoChainIdFromRunning());
            this.undoChainIdFromDone.put(desc.getDocumentType(), desc.getUndoChainIdFromDone());
        } else if (PERSISTER_XP.equals(extensionPoint)) {
            PersisterDescriptor des = (PersisterDescriptor)contribution;
            try {
                this.persister = des.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException((Throwable)e);
            }
        } else if (ROUTE_MODELS_IMPORTER_XP.equals(extensionPoint)) {
            RouteModelResourceType res = (RouteModelResourceType)contribution;
            this.registerRouteResource(res, contributor.getRuntimeContext());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof RouteModelResourceType) {
            this.routeResourcesRegistry.removeContribution((RouteModelResourceType)contribution);
        }
        super.unregisterContribution(contribution, extensionPoint, contributor);
    }

    protected static void fireEvent(String eventName, Map<String, Serializable> eventProperties, DocumentRoute route, CoreSession session) {
        eventProperties.put("documentElementEventContextKey", (Serializable)route);
        eventProperties.put("category", (Serializable)((Object)"Routing"));
        DocumentEventContext envContext = new DocumentEventContext(session, session.getPrincipal(), route.getDocument());
        envContext.setProperties(eventProperties);
        EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        eventProducer.fireEvent(envContext.newEvent(eventName));
    }

    public String createNewInstance(String routeModelId, List<String> docIds, Map<String, Serializable> map, CoreSession s, boolean startInstance) {
        return (String)CoreInstance.doPrivileged((CoreSession)s, session -> {
            String routeDocId = this.getRouteModelDocIdWithId((CoreSession)session, routeModelId);
            DocumentModel model = session.getDocument((DocumentRef)new IdRef(routeDocId));
            DocumentModel instance = this.persister.createDocumentRouteInstanceFromDocumentRouteModel(model, session);
            DocumentRoute route = (DocumentRoute)instance.getAdapter(DocumentRoute.class);
            route.setAttachedDocuments(docIds);
            route.save(session);
            HashMap<String, Serializable> props = new HashMap<String, Serializable>();
            props.put("initiator", (Serializable)((Object)session.getPrincipal().getActingUser()));
            DocumentRoutingServiceImpl.fireEvent(DocumentRoutingConstants.Events.beforeRouteReady.name(), props, route, session);
            route.setReady(session);
            DocumentRoutingServiceImpl.fireEvent(DocumentRoutingConstants.Events.afterRouteReady.name(), props, route, session);
            route.save(session);
            if (startInstance) {
                DocumentRoutingServiceImpl.fireEvent(DocumentRoutingConstants.Events.beforeRouteStart.name(), new HashMap<String, Serializable>(), route, session);
                DocumentRoutingEngineService routingEngine = (DocumentRoutingEngineService)Framework.getService(DocumentRoutingEngineService.class);
                routingEngine.start(route, map, (CoreSession)session);
                this.fireEventAfterWorkflowStarted(route, (CoreSession)session);
            }
            return instance.getId();
        });
    }

    public String createNewInstance(String routeModelId, List<String> docIds, CoreSession session, boolean startInstance) {
        return this.createNewInstance(routeModelId, docIds, null, session, startInstance);
    }

    public DocumentRoute createNewInstance(DocumentRoute model, List<String> docIds, CoreSession session, boolean startInstance) {
        String id = this.createNewInstance(model.getDocument().getName(), docIds, session, startInstance);
        return (DocumentRoute)session.getDocument((DocumentRef)new IdRef(id)).getAdapter(DocumentRoute.class);
    }

    @Deprecated
    public DocumentRoute createNewInstance(DocumentRoute model, String documentId, CoreSession session, boolean startInstance) {
        return this.createNewInstance(model, Collections.singletonList(documentId), session, startInstance);
    }

    @Deprecated
    public DocumentRoute createNewInstance(DocumentRoute model, List<String> documentIds, CoreSession session) {
        return this.createNewInstance(model, documentIds, session, true);
    }

    @Deprecated
    public DocumentRoute createNewInstance(DocumentRoute model, String documentId, CoreSession session) {
        return this.createNewInstance(model, Collections.singletonList(documentId), session, true);
    }

    public void startInstance(String routeInstanceId, List<String> docIds, Map<String, Serializable> map, CoreSession s) {
        CoreInstance.doPrivileged((CoreSession)s, session -> {
            DocumentModel instance = session.getDocument((DocumentRef)new IdRef(routeInstanceId));
            DocumentRoute route = (DocumentRoute)instance.getAdapter(DocumentRoute.class);
            if (docIds != null) {
                route.setAttachedDocuments(docIds);
                route.save(session);
            }
            DocumentRoutingServiceImpl.fireEvent(DocumentRoutingConstants.Events.beforeRouteStart.name(), new HashMap<String, Serializable>(), route, session);
            DocumentRoutingEngineService routingEngine = (DocumentRoutingEngineService)Framework.getService(DocumentRoutingEngineService.class);
            routingEngine.start(route, map, (CoreSession)session);
            this.fireEventAfterWorkflowStarted(route, (CoreSession)session);
        });
    }

    protected void fireEventAfterWorkflowStarted(DocumentRoute route, CoreSession session) {
        HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
        eventProperties.put("workflowInitiator", (Serializable)((Object)route.getInitiator()));
        eventProperties.put("modelId", (Serializable)((Object)route.getModelId()));
        eventProperties.put("modelName", (Serializable)((Object)route.getModelName()));
        if (route instanceof GraphRoute) {
            eventProperties.put("workflowVariables", (Serializable)((Object)((GraphRoute)route).getVariables()));
        }
        DocumentRoutingServiceImpl.fireEvent(DocumentRoutingConstants.Events.afterWorkflowStarted.name(), eventProperties, route, session);
    }

    public void resumeInstance(String routeId, String nodeId, Map<String, Object> data, String status, CoreSession session) {
        AttachedDocumentsChecker adc = new AttachedDocumentsChecker(session, routeId);
        adc.runUnrestricted();
        if (!adc.isWorkflowCanceled) {
            this.completeTask(routeId, nodeId, null, data, status, session);
        }
    }

    public void completeTask(String routeId, String taskId, Map<String, Object> data, String status, CoreSession session) {
        DocumentModel task = session.getDocument((DocumentRef)new IdRef(taskId));
        this.completeTask(routeId, null, task != null ? (Task)task.getAdapter(Task.class) : null, data, status, session);
    }

    protected void completeTask(String routeId, String nodeId, Task task, Map<String, Object> data, String status, CoreSession session) {
        if (task == null) {
            log.debug("Resuming workflow instance: {} associated to node: {}", (Object)routeId, (Object)nodeId);
        } else {
            log.debug("Completing task: {} associated to node: {} for workflow instance: {}", (Object)task.getId(), (Object)nodeId, (Object)routeId);
        }
        CompleteTaskRunner runner = new CompleteTaskRunner(routeId, nodeId, task, data, status, session);
        runner.runUnrestricted();
    }

    public List<DocumentRoute> getAvailableDocumentRouteModel(CoreSession session) {
        DocumentModelList list = session.query(AVAILABLE_ROUTES_MODEL_QUERY);
        ArrayList<DocumentRoute> routes = new ArrayList<DocumentRoute>();
        for (DocumentModel model : list) {
            routes.add((DocumentRoute)model.getAdapter(DocumentRoute.class));
        }
        return routes;
    }

    public List<DocumentRoute> getAvailableDocumentRoute(CoreSession session) {
        DocumentModelList list = session.query(AVAILABLE_ROUTES_QUERY);
        ArrayList<DocumentRoute> routes = new ArrayList<DocumentRoute>();
        for (DocumentModel model : list) {
            routes.add((DocumentRoute)model.getAdapter(DocumentRoute.class));
        }
        return routes;
    }

    public String getOperationChainId(String documentType) {
        return this.typeToChain.get(documentType);
    }

    public String getUndoFromRunningOperationChainId(String documentType) {
        return this.undoChainIdFromRunning.get(documentType);
    }

    public String getUndoFromDoneOperationChainId(String documentType) {
        return this.undoChainIdFromDone.get(documentType);
    }

    public DocumentRoute unlockDocumentRouteUnrestrictedSession(DocumentRoute routeModel, CoreSession userSession) {
        CoreInstance.doPrivileged((CoreSession)userSession, session -> {
            DocumentRoute route = (DocumentRoute)session.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
            LockableDocumentRoute lockableRoute = (LockableDocumentRoute)route.getDocument().getAdapter(LockableDocumentRoute.class);
            lockableRoute.unlockDocument(session);
        });
        return (DocumentRoute)userSession.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
    }

    public DocumentRoute validateRouteModel(DocumentRoute routeModel, CoreSession userSession) throws DocumentRouteNotLockedException {
        if (!routeModel.getDocument().isLocked()) {
            throw new DocumentRouteNotLockedException();
        }
        CoreInstance.doPrivileged((CoreSession)userSession, session -> {
            DocumentRoute route = (DocumentRoute)session.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
            route.validate(session);
        });
        return (DocumentRoute)userSession.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
    }

    @Deprecated
    public List<DocumentRouteTableElement> getRouteElements(DocumentRoute route, CoreSession session) {
        RouteTable table = new RouteTable(route);
        ArrayList<DocumentRouteTableElement> elements = new ArrayList<DocumentRouteTableElement>();
        this.processElementsInFolder(route.getDocument(), elements, table, session, 0, null);
        int maxDepth = 0;
        for (DocumentRouteTableElement element : elements) {
            int d = element.getDepth();
            maxDepth = d > maxDepth ? d : maxDepth;
        }
        table.setMaxDepth(maxDepth);
        for (DocumentRouteTableElement element : elements) {
            element.computeFirstChildList();
        }
        return elements;
    }

    @Deprecated
    protected void processElementsInFolder(DocumentModel doc, List<DocumentRouteTableElement> elements, RouteTable table, CoreSession session, int depth, RouteFolderElement folder) {
        DocumentModelList children = session.getChildren(doc.getRef());
        boolean first = true;
        for (DocumentModel child : children) {
            if (child.isFolder() && !session.getChildren(child.getRef()).isEmpty()) {
                RouteFolderElement thisFolder = new RouteFolderElement((DocumentRouteElement)child.getAdapter(DocumentRouteElement.class), table, first, folder, depth);
                this.processElementsInFolder(child, elements, table, session, depth + 1, thisFolder);
            } else {
                if (folder != null) {
                    folder.increaseTotalChildCount();
                } else {
                    table.increaseTotalChildCount();
                }
                elements.add(new DocumentRouteTableElement((DocumentRouteElement)child.getAdapter(DocumentRouteElement.class), table, depth, folder, first));
            }
            first = false;
        }
    }

    @Deprecated
    protected List<DocumentRouteTableElement> getRouteElements(DocumentRouteElement routeElementDocument, CoreSession session, List<DocumentRouteTableElement> routeElements, int depth) {
        return null;
    }

    public List<DocumentRoute> getDocumentRoutesForAttachedDocument(CoreSession session, String attachedDocId) {
        ArrayList<DocumentRouteElement.ElementLifeCycleState> states = new ArrayList<DocumentRouteElement.ElementLifeCycleState>();
        states.add(DocumentRouteElement.ElementLifeCycleState.ready);
        states.add(DocumentRouteElement.ElementLifeCycleState.running);
        return this.getDocumentRoutesForAttachedDocument(session, attachedDocId, states);
    }

    public List<DocumentRoute> getDocumentRoutesForAttachedDocument(CoreSession session, String attachedDocId, List<DocumentRouteElement.ElementLifeCycleState> states) {
        StringBuilder statesString = new StringBuilder();
        if (states != null && !states.isEmpty()) {
            statesString.append(" ecm:currentLifeCycleState IN (");
            for (DocumentRouteElement.ElementLifeCycleState state : states) {
                statesString.append("'").append(state.name()).append("',");
            }
            statesString.deleteCharAt(statesString.length() - 1);
            statesString.append(") AND");
        }
        String query = String.format("SELECT * FROM DocumentRoute WHERE " + statesString.toString() + " docri:participatingDocuments/* = '%s' ORDER BY dc:created", attachedDocId);
        UnrestrictedQueryRunner queryRunner = new UnrestrictedQueryRunner(session, query);
        DocumentModelList list = queryRunner.runQuery();
        ArrayList<DocumentRoute> routes = new ArrayList<DocumentRoute>();
        for (DocumentModel model : list) {
            routes.add((DocumentRoute)model.getAdapter(DocumentRoute.class));
        }
        return routes;
    }

    public boolean canUserValidateRoute(NuxeoPrincipal currentUser) {
        return currentUser.getGroups().contains("routeManagers");
    }

    public boolean canValidateRoute(DocumentModel documentRoute, CoreSession coreSession) {
        if (!coreSession.hasChildren(documentRoute.getRef())) {
            return false;
        }
        return coreSession.hasPermission(documentRoute.getRef(), "Everything");
    }

    @Deprecated
    public void addRouteElementToRoute(DocumentRef parentDocumentRef, int idx, DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException {
        DocumentRoute route = this.getParentRouteModel(parentDocumentRef, session);
        if (!this.isLockedByCurrentUser(route, session)) {
            throw new DocumentRouteNotLockedException();
        }
        DocumentModelList children = session.query(String.format(ORDERED_CHILDREN_QUERY, session.getDocument(parentDocumentRef).getId()));
        try {
            DocumentModel sourceDoc = (DocumentModel)children.get(idx);
            this.addRouteElementToRoute(parentDocumentRef, sourceDoc.getName(), routeElement, session);
        }
        catch (IndexOutOfBoundsException e) {
            this.addRouteElementToRoute(parentDocumentRef, null, routeElement, session);
        }
    }

    @Deprecated
    public void addRouteElementToRoute(DocumentRef parentDocumentRef, String sourceName, DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException {
        DocumentRoute parentRoute = this.getParentRouteModel(parentDocumentRef, session);
        if (!this.isLockedByCurrentUser(parentRoute, session)) {
            throw new DocumentRouteNotLockedException();
        }
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        DocumentModel docRouteElement = routeElement.getDocument();
        DocumentModel parentDocument = session.getDocument(parentDocumentRef);
        docRouteElement.setPathInfo(parentDocument.getPathAsString(), pss.generatePathSegment(docRouteElement));
        String lifecycleState = parentDocument.getCurrentLifeCycleState().equals(DocumentRouteElement.ElementLifeCycleState.draft.name()) ? DocumentRouteElement.ElementLifeCycleState.draft.name() : DocumentRouteElement.ElementLifeCycleState.ready.name();
        docRouteElement.putContextData("initialLifecycleState", (Serializable)((Object)lifecycleState));
        docRouteElement = session.createDocument(docRouteElement);
        session.orderBefore(parentDocumentRef, docRouteElement.getName(), sourceName);
        session.save();
    }

    public void removeRouteElement(DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException {
        DocumentRoute parentRoute = routeElement.getDocumentRoute(session);
        if (!this.isLockedByCurrentUser(parentRoute, session)) {
            throw new DocumentRouteNotLockedException();
        }
        session.removeDocument(routeElement.getDocument().getRef());
        session.save();
    }

    public DocumentModelList getOrderedRouteElement(String routeElementId, CoreSession session) {
        String query = String.format(ORDERED_CHILDREN_QUERY, routeElementId);
        return session.query(query);
    }

    public void lockDocumentRoute(DocumentRoute routeModel, CoreSession session) throws DocumentRouteAlredayLockedException {
        LockableDocumentRoute lockableRoute = (LockableDocumentRoute)routeModel.getDocument().getAdapter(LockableDocumentRoute.class);
        boolean lockedByCurrent = this.isLockedByCurrentUser(routeModel, session);
        if (lockableRoute.isLocked(session) && !lockedByCurrent) {
            throw new DocumentRouteAlredayLockedException();
        }
        if (!lockedByCurrent) {
            lockableRoute.lockDocument(session);
        }
    }

    public void unlockDocumentRoute(DocumentRoute routeModel, CoreSession session) throws DocumentRouteNotLockedException {
        LockableDocumentRoute lockableRoute = (LockableDocumentRoute)routeModel.getDocument().getAdapter(LockableDocumentRoute.class);
        if (!lockableRoute.isLockedByCurrentUser(session)) {
            throw new DocumentRouteNotLockedException();
        }
        lockableRoute.unlockDocument(session);
    }

    public boolean isLockedByCurrentUser(DocumentRoute routeModel, CoreSession session) {
        LockableDocumentRoute lockableRoute = (LockableDocumentRoute)routeModel.getDocument().getAdapter(LockableDocumentRoute.class);
        return lockableRoute.isLockedByCurrentUser(session);
    }

    public void updateRouteElement(DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException {
        if (!this.isLockedByCurrentUser(routeElement.getDocumentRoute(session), session)) {
            throw new DocumentRouteNotLockedException();
        }
        routeElement.save(session);
    }

    private DocumentRoute getParentRouteModel(DocumentRef documentRef, CoreSession session) {
        DocumentModel parentDoc = session.getDocument(documentRef);
        if (parentDoc.hasFacet("DocumentRoute")) {
            return (DocumentRoute)parentDoc.getAdapter(DocumentRoute.class);
        }
        DocumentRouteElement rElement = (DocumentRouteElement)parentDoc.getAdapter(DocumentRouteElement.class);
        return rElement.getDocumentRoute(session);
    }

    public DocumentRoute saveRouteAsNewModel(DocumentRoute instance, CoreSession session) {
        String newName;
        DocumentModel parent;
        DocumentModel instanceModel = instance.getDocument();
        DocumentModel newmodel = this.persister.saveDocumentRouteInstanceAsNewModel(instanceModel, parent = this.persister.getParentFolderForNewModel(session, instanceModel), newName = this.persister.getNewModelName(instanceModel), session);
        DocumentRoute newRoute = (DocumentRoute)newmodel.getAdapter(DocumentRoute.class);
        if (!newRoute.isDraft()) {
            newRoute.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toDraft, session, false);
        }
        newRoute.getDocument().setPropertyValue("dc:title", (Serializable)((Object)newName));
        newRoute.setAttachedDocuments(new ArrayList());
        newRoute.save(session);
        return newRoute;
    }

    public boolean isRoutable(DocumentModel doc) {
        if (doc == null) {
            return false;
        }
        String type = doc.getType();
        return type.equals("File") || type.equals("Note");
    }

    public void importAllRouteModels(CoreSession session) {
        for (URL url : this.getRouteModelTemplateResources()) {
            this.importRouteModel(url, true, session);
        }
    }

    public DocumentRoute importRouteModel(URL modelToImport, boolean overwrite, CoreSession session) {
        DocumentModel doc;
        if (modelToImport == null) {
            throw new NuxeoException("No resource containing route templates found");
        }
        URLBlob blob = new URLBlob(modelToImport);
        String file = modelToImport.getFile();
        try {
            FileImporterContext context = FileImporterContext.builder((CoreSession)session, (Blob)blob, (String)this.persister.getParentFolderForDocumentRouteModels(session).getPathAsString()).overwrite(true).fileName(file).build();
            doc = this.getFileManager().createOrUpdateDocument(context);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (doc == null) {
            throw new NuxeoException("Can not import document " + file);
        }
        if (this.modelsChache != null) {
            this.modelsChache.invalidate((Object)doc.getName());
        }
        return (DocumentRoute)doc.getAdapter(DocumentRoute.class);
    }

    protected FileManager getFileManager() {
        return (FileManager)Framework.getService(FileManager.class);
    }

    public void activate(ComponentContext context) {
        super.activate(context);
        this.modelsChache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        this.repositoryInitializationHandler = new RouteModelsInitializator();
        this.repositoryInitializationHandler.install();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        if (this.repositoryInitializationHandler != null) {
            this.repositoryInitializationHandler.uninstall();
        }
    }

    public List<URL> getRouteModelTemplateResources() {
        return new ArrayList<URL>(this.routeResourcesRegistry.getRouteModelTemplateResources());
    }

    public List<DocumentModel> searchRouteModels(CoreSession session, String searchString) {
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("maxResults", "PAGE_SIZE");
        props.put("coreSession", (Serializable)session);
        PageProvider pageProvider = StringUtils.isEmpty((CharSequence)searchString) ? pageProviderService.getPageProvider("DOC_ROUTING_SEARCH_ALL_ROUTE_MODELS", null, null, Long.valueOf(0L), props, new Object[0]) : pageProviderService.getPageProvider("DOC_ROUTING_SEARCH_ROUTE_MODELS_WITH_TITLE", null, null, Long.valueOf(0L), props, new Object[]{searchString + "%"});
        ArrayList<DocumentModel> allRouteModels = new ArrayList<DocumentModel>(pageProvider.getCurrentPage());
        while (pageProvider.isNextPageAvailable()) {
            pageProvider.nextPage();
            allRouteModels.addAll(pageProvider.getCurrentPage());
        }
        return allRouteModels;
    }

    public void registerRouteResource(RouteModelResourceType res, RuntimeContext context) {
        if (res.getPath() != null && res.getId() != null) {
            if (this.routeResourcesRegistry.getResource(res.getId()) != null) {
                this.routeResourcesRegistry.removeContribution(res);
            }
            if (res.getUrl() == null) {
                res.setUrl(this.getUrlFromPath(res, context));
            }
            this.routeResourcesRegistry.addContribution(res);
        }
    }

    protected URL getUrlFromPath(RouteModelResourceType res, RuntimeContext extensionContext) {
        URL url;
        block4: {
            String path = res.getPath();
            if (path == null) {
                return null;
            }
            try {
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                url = extensionContext.getLocalResource(path);
                if (url == null) {
                    url = extensionContext.getResource(path);
                }
                if (url != null) break block4;
                url = res.getClass().getResource(path);
            }
        }
        return url;
    }

    public DocumentRoute getRouteModelWithId(CoreSession session, String id) {
        String routeDocModelId = this.getRouteModelDocIdWithId(session, id);
        DocumentModel routeDoc = session.getDocument((DocumentRef)new IdRef(routeDocModelId));
        return (DocumentRoute)routeDoc.getAdapter(DocumentRoute.class);
    }

    public String getRouteModelDocIdWithId(CoreSession session, String id) {
        String routeDocId;
        if (this.modelsChache != null && (routeDocId = (String)this.modelsChache.getIfPresent((Object)id)) != null) {
            return routeDocId;
        }
        String query = String.format(ROUTE_MODEL_DOC_ID_WITH_ID_QUERY, NXQL.escapeString((String)id));
        ArrayList<String> routeIds = new ArrayList<String>();
        try (IterableQueryResult results = session.queryAndFetch(query, "NXQL", new Object[0]);){
            if (results.size() == 0L) {
                throw new NuxeoException("No route found for id: " + id);
            }
            if (results.size() != 1L) {
                throw new NuxeoException("More than one route model found with id: " + id);
            }
            for (Map map : results) {
                routeIds.add(((Serializable)map.get("ecm:uuid")).toString());
            }
        }
        String routeDocId2 = (String)routeIds.get(0);
        if (this.modelsChache == null) {
            this.modelsChache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        }
        this.modelsChache.put((Object)id, (Object)routeDocId2);
        return routeDocId2;
    }

    @Deprecated
    public void makeRoutingTasks(CoreSession coreSession, List<Task> tasks) {
        CoreInstance.doPrivileged((CoreSession)coreSession, session -> {
            for (Task task : tasks) {
                DocumentModel taskDoc = task.getDocument();
                taskDoc.addFacet("RoutingTask");
                session.saveDocument(taskDoc);
            }
        });
    }

    public void endTask(CoreSession session, Task task, Map<String, Object> data, String status) {
        String comment = (String)data.get("comment");
        TaskService taskService = (TaskService)Framework.getService(TaskService.class);
        taskService.endTask(session, session.getPrincipal(), task, comment, null, false);
        Map taskVariables = task.getVariables();
        String routeInstanceId = (String)taskVariables.get("routeInstanceDocId");
        if (StringUtils.isEmpty((CharSequence)routeInstanceId)) {
            throw new DocumentRouteException("Can not resume workflow, no related route");
        }
        this.completeTask(routeInstanceId, null, task, data, status, session);
    }

    public List<DocumentModel> getWorkflowInputDocuments(CoreSession session, Task task) {
        DocumentModel routeDoc;
        String routeInstanceId;
        try {
            routeInstanceId = task.getProcessId();
        }
        catch (PropertyException e) {
            throw new DocumentRouteException("Can not get the related workflow instance");
        }
        if (StringUtils.isEmpty((CharSequence)routeInstanceId)) {
            throw new DocumentRouteException("Can not get the related workflow instance");
        }
        try {
            routeDoc = session.getDocument((DocumentRef)new IdRef(routeInstanceId));
        }
        catch (DocumentNotFoundException e) {
            throw new DocumentRouteException("No workflow with the id:" + routeInstanceId);
        }
        DocumentRoute route = (DocumentRoute)routeDoc.getAdapter(DocumentRoute.class);
        return route.getAttachedDocuments(session);
    }

    public void grantPermissionToTaskAssignees(CoreSession session, String permission, List<DocumentModel> docs, Task task) {
        this.setAclForActors(session, DocumentRoutingServiceImpl.getRoutingACLName(task), permission, docs, task.getActors());
    }

    public void grantPermissionToTaskDelegatedActors(CoreSession session, String permission, List<DocumentModel> docs, Task task) {
        this.setAclForActors(session, DocumentRoutingServiceImpl.getDelegationACLName(task), permission, docs, task.getDelegatedActors());
    }

    public void removePermissionFromTaskAssignees(CoreSession s, List<DocumentModel> docs, Task task) {
        String aclName = DocumentRoutingServiceImpl.getRoutingACLName(task);
        CoreInstance.doPrivileged((CoreSession)s, session -> {
            for (DocumentModel doc : docs) {
                ACP acp = doc.getACP();
                acp.removeACL(aclName);
                doc.setACP(acp, true);
            }
        });
    }

    public void removePermissionsForTaskActors(CoreSession s, List<DocumentModel> docs, String taskId) {
        String aclRoutingName = DocumentRoutingServiceImpl.getRoutingACLName(taskId);
        String aclDelegationName = DocumentRoutingServiceImpl.getDelegationACLName(taskId);
        CoreInstance.doPrivileged((CoreSession)s, session -> {
            for (DocumentModel doc : docs) {
                ACP acp = doc.getACP();
                acp.removeACL(aclRoutingName);
                acp.removeACL(aclDelegationName);
                doc.setACP(acp, true);
            }
        });
    }

    public void removePermissionsForTaskActors(CoreSession session, List<DocumentModel> docs, Task task) {
        this.removePermissionsForTaskActors(session, docs, task.getId());
    }

    protected static String getRoutingACLName(Task task) {
        return DocumentRoutingServiceImpl.getRoutingACLName(task.getId());
    }

    protected static String getRoutingACLName(String taskId) {
        return "routing/" + taskId;
    }

    protected static String getDelegationACLName(Task task) {
        return DocumentRoutingServiceImpl.getDelegationACLName(task.getId());
    }

    protected static String getDelegationACLName(String taskId) {
        return "delegation/" + taskId;
    }

    public void finishTask(CoreSession session, DocumentRoute route, Task task, boolean delete) throws DocumentRouteException {
        DocumentModelList docs = route.getAttachedDocuments(session);
        try {
            this.removePermissionsForTaskActors(session, (List<DocumentModel>)docs, task);
            if (delete) {
                session.removeDocument((DocumentRef)new IdRef(task.getId()));
            }
        }
        catch (DocumentNotFoundException e) {
            throw new DocumentRouteException("Cannot finish task", (Throwable)e);
        }
    }

    public void cancelTask(CoreSession s, String taskId) throws DocumentRouteException {
        CoreInstance.doPrivileged((CoreSession)s, session -> {
            DocumentModel taskDoc = session.getDocument((DocumentRef)new IdRef(taskId));
            Task task = (Task)taskDoc.getAdapter(Task.class);
            if (task == null) {
                throw new DocumentRouteException("Invalid taskId: " + taskId);
            }
            if (!task.isOpened().booleanValue()) {
                log.info("Can not cancel task: {} as is not open", (Object)taskId);
                return;
            }
            task.cancel(session);
            String routeId = task.getProcessId();
            if (routeId != null) {
                DocumentModel routeDoc = session.getDocument((DocumentRef)new IdRef(routeId));
                GraphRoute routeInstance = (GraphRoute)routeDoc.getAdapter(GraphRoute.class);
                if (routeInstance == null) {
                    throw new DocumentRouteException("Invalid routeInstanceId: " + routeId);
                }
                DocumentModelList docs = routeInstance.getAttachedDocumentModels();
                this.removePermissionsForTaskActors((CoreSession)session, (List<DocumentModel>)docs, task);
                this.updateTaskInfo((CoreSession)session, routeInstance, task, null);
            }
            session.saveDocument(task.getDocument());
        });
    }

    protected void updateTaskInfo(CoreSession session, GraphRoute graph, Task task, String status) {
        String nodeId = task.getVariable("nodeId");
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            throw new DocumentRouteException("No nodeId found on task: " + task.getId());
        }
        GraphNode node = graph.getNode(nodeId);
        NuxeoPrincipal principal = session.getPrincipal();
        String actor = principal.getActingUser();
        node.updateTaskInfo(task.getId(), true, status, actor, null);
    }

    public void reassignTask(CoreSession s, String taskId, List<String> actors, String comment) throws DocumentRouteException {
        CoreInstance.doPrivileged((CoreSession)s, session -> {
            DocumentModel taskDoc = session.getDocument((DocumentRef)new IdRef(taskId));
            Task task = (Task)taskDoc.getAdapter(Task.class);
            if (task == null) {
                throw new DocumentRouteException("Invalid taskId: " + taskId);
            }
            if (!task.isOpened().booleanValue()) {
                throw new DocumentRouteException("Task  " + taskId + " is not opened, can not reassign it");
            }
            String routeId = task.getProcessId();
            if (routeId != null) {
                DocumentModel routeDoc = session.getDocument((DocumentRef)new IdRef(routeId));
                GraphRoute routeInstance = (GraphRoute)routeDoc.getAdapter(GraphRoute.class);
                if (routeInstance == null) {
                    throw new DocumentRouteException("Invalid routeInstanceId: " + routeId + " referenced by the task " + taskId);
                }
                GraphNode node = routeInstance.getNode(task.getType());
                if (node == null) {
                    throw new DocumentRouteException("Invalid node " + routeId + " referenced by the task " + taskId);
                }
                if (!node.allowTaskReassignment()) {
                    throw new DocumentRouteException("Task " + taskId + " can not be reassigned. Node " + node.getId() + " doesn't allow reassignment.");
                }
                DocumentModelList docs = routeInstance.getAttachedDocumentModels();
                this.removePermissionFromTaskAssignees((CoreSession)session, (List<DocumentModel>)docs, task);
                ((TaskService)Framework.getService(TaskService.class)).reassignTask(session, taskId, actors, comment);
                task.getDocument().refresh();
                this.grantPermissionToTaskAssignees((CoreSession)session, node.getTaskAssigneesPermission(), (List<DocumentModel>)docs, task);
                HashMap<String, Object> eventProperties = new HashMap<String, Object>();
                eventProperties.put("category", "Routing");
                eventProperties.put("taskName", task.getName());
                eventProperties.put("actors", (Serializable)((Object)actors));
                eventProperties.put("modelId", routeInstance.getModelId());
                eventProperties.put("modelName", routeInstance.getModelName());
                eventProperties.put("workflowInitiator", routeInstance.getInitiator());
                eventProperties.put("taskActor", session.getPrincipal().getActingUser());
                eventProperties.put("comment", comment);
                long timeSinceWfStarted = RoutingAuditHelper.computeDurationSinceWfStarted(task.getProcessId());
                if (timeSinceWfStarted >= 0L) {
                    eventProperties.put("timeSinceWfStarted", timeSinceWfStarted);
                }
                long timeSinceTaskStarted = RoutingAuditHelper.computeDurationSinceTaskStarted(task.getId());
                if (timeSinceWfStarted >= 0L) {
                    eventProperties.put("timeSinceTaskStarted", timeSinceTaskStarted);
                }
                DocumentEventContext envContext = new DocumentEventContext(session, session.getPrincipal(), task.getDocument());
                envContext.setProperties(eventProperties);
                EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
                eventProducer.fireEvent(envContext.newEvent(DocumentRoutingConstants.Events.afterWorkflowTaskReassigned.name()));
            }
        });
    }

    public void delegateTask(CoreSession s, String taskId, List<String> delegatedActors, String comment) throws DocumentRouteException {
        CoreInstance.doPrivileged((CoreSession)s, session -> {
            DocumentModel taskDoc = session.getDocument((DocumentRef)new IdRef(taskId));
            Task task = (Task)taskDoc.getAdapter(Task.class);
            if (task == null) {
                throw new DocumentRouteException("Invalid taskId: " + taskId);
            }
            String routeId = task.getProcessId();
            if (routeId != null) {
                DocumentModel routeDoc = session.getDocument((DocumentRef)new IdRef(routeId));
                GraphRoute routeInstance = (GraphRoute)routeDoc.getAdapter(GraphRoute.class);
                if (routeInstance == null) {
                    throw new DocumentRouteException("Invalid routeInstanceId: " + routeId + " referenced by the task " + taskId);
                }
                GraphNode node = routeInstance.getNode(task.getType());
                if (node == null) {
                    throw new DocumentRouteException("Invalid node " + routeId + " referenced by the task " + taskId);
                }
                DocumentModelList docs = routeInstance.getAttachedDocumentModels();
                ((TaskService)Framework.getService(TaskService.class)).delegateTask(session, taskId, delegatedActors, comment);
                task.getDocument().refresh();
                this.grantPermissionToTaskDelegatedActors((CoreSession)session, node.getTaskAssigneesPermission(), (List<DocumentModel>)docs, task);
                HashMap<String, Object> eventProperties = new HashMap<String, Object>();
                eventProperties.put("category", "Routing");
                eventProperties.put("taskName", task.getName());
                eventProperties.put("delegatedActors", (Serializable)((Object)delegatedActors));
                eventProperties.put("modelId", routeInstance.getModelId());
                eventProperties.put("modelName", routeInstance.getModelName());
                eventProperties.put("workflowInitiator", routeInstance.getInitiator());
                eventProperties.put("taskActor", session.getPrincipal().getActingUser());
                eventProperties.put("comment", comment);
                long timeSinceWfStarted = RoutingAuditHelper.computeDurationSinceWfStarted(task.getProcessId());
                if (timeSinceWfStarted >= 0L) {
                    eventProperties.put("timeSinceWfStarted", timeSinceWfStarted);
                }
                long timeSinceTaskStarted = RoutingAuditHelper.computeDurationSinceTaskStarted(task.getId());
                if (timeSinceWfStarted >= 0L) {
                    eventProperties.put("timeSinceTaskStarted", timeSinceTaskStarted);
                }
                DocumentEventContext envContext = new DocumentEventContext(session, session.getPrincipal(), task.getDocument());
                envContext.setProperties(eventProperties);
                EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
                eventProducer.fireEvent(envContext.newEvent(DocumentRoutingConstants.Events.afterWorkflowTaskDelegated.name()));
            }
        });
    }

    protected void setAclForActors(CoreSession s, String aclName, String permission, List<DocumentModel> docs, List<String> actors) {
        ArrayList<String> actorIds = new ArrayList<String>();
        for (String actor : actors) {
            if (actor.startsWith("user:")) {
                actorIds.add(actor.substring("user:".length()));
                continue;
            }
            if (actor.startsWith("group:")) {
                actorIds.add(actor.substring("group:".length()));
                continue;
            }
            actorIds.add(actor);
        }
        CoreInstance.doPrivileged((CoreSession)s, session -> {
            for (DocumentModel doc : docs) {
                ACP acp = doc.getACP();
                acp.removeACL(aclName);
                ACLImpl acl = new ACLImpl(aclName);
                for (String actorId : actorIds) {
                    acl.add(ACE.builder((String)actorId, (String)permission).creator(ACTOR_ACE_CREATOR).build());
                }
                acp.addACL(0, (ACL)acl);
                doc.setACP(acp, true);
            }
        });
    }

    public void cleanupDoneAndCanceledRouteInstances(String reprositoryName, int limit) {
        this.doCleanupDoneAndCanceledRouteInstances(reprositoryName, limit);
    }

    public int doCleanupDoneAndCanceledRouteInstances(String reprositoryName, int limit) {
        WfCleaner unrestrictedSessionRunner = new WfCleaner(reprositoryName, limit);
        unrestrictedSessionRunner.runUnrestricted();
        return unrestrictedSessionRunner.getNumberOfCleanedUpWf();
    }

    public void invalidateRouteModelsCache() {
        this.modelsChache.invalidateAll();
    }

    public List<Task> getTasks(DocumentModel document, String actorId, String workflowInstanceId, String worflowModelName, CoreSession s) {
        StringBuilder query = new StringBuilder(String.format("SELECT * FROM Document WHERE ecm:mixinType = '%s' AND ecm:currentLifeCycleState = '%s'", "Task", "opened"));
        if (StringUtils.isNotBlank((CharSequence)actorId)) {
            ArrayList<String> actors = new ArrayList<String>();
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            NuxeoPrincipal principal = userManager.getPrincipal(actorId);
            if (principal != null) {
                for (String actor : TaskActorsHelper.getTaskActors((NuxeoPrincipal)principal)) {
                    actors.add(NXQL.escapeString((String)actor));
                }
            } else {
                actors.add(NXQL.escapeString((String)actorId));
            }
            String actorsParam = StringUtils.join(actors, (String)", ");
            query.append(String.format(" AND (nt:actors/* IN (%s) OR nt:delegatedActors/* IN (%s))", actorsParam, actorsParam));
        }
        if (StringUtils.isNotBlank((CharSequence)workflowInstanceId)) {
            query.append(String.format(" AND nt:processId = %s", NXQL.escapeString((String)workflowInstanceId)));
        }
        if (document != null) {
            query.append(String.format(" AND nt:targetDocumentsIds = '%s'", document.getId()));
        }
        query.append(String.format(" ORDER BY %s ASC", "nt:dueDate"));
        DocumentModelList documentModelList = s.query(query.toString());
        return (List)CoreInstance.doPrivileged((CoreSession)s, session -> {
            ArrayList<Task> result = new ArrayList<Task>();
            for (DocumentModel documentModel : documentModelList) {
                Task task = (Task)documentModel.getAdapter(Task.class);
                if (StringUtils.isNotBlank((CharSequence)worflowModelName)) {
                    String routeInstanceName;
                    DocumentRoute routeInstance;
                    String processId = task.getProcessId();
                    if (processId == null || !session.exists((DocumentRef)new IdRef(processId)) || (routeInstance = (DocumentRoute)session.getDocument((DocumentRef)new IdRef(processId)).getAdapter(DocumentRoute.class)) == null || (routeInstanceName = routeInstance.getName()) == null || !routeInstanceName.equals(worflowModelName) && !routeInstanceName.matches("^(" + worflowModelName + ")\\.\\d+")) continue;
                    result.add(task);
                    continue;
                }
                result.add(task);
            }
            return result;
        });
    }

    public List<DocumentRoute> getDocumentRelatedWorkflows(DocumentModel document, CoreSession session) {
        String query = String.format("SELECT * FROM %s WHERE docri:participatingDocuments/* = '%s' AND ecm:currentLifeCycleState = '%s'", "DocumentRoute", document.getId(), DocumentRouteElement.ElementLifeCycleState.running);
        DocumentModelList documentModelList = session.query(query);
        ArrayList<DocumentRoute> result = new ArrayList<DocumentRoute>();
        for (DocumentModel documentModel : documentModelList) {
            result.add((DocumentRoute)documentModel.getAdapter(GraphRoute.class));
        }
        return result;
    }

    public List<DocumentRoute> getRunningWorkflowInstancesLaunchedByCurrentUser(CoreSession session) {
        return this.getRunningWorkflowInstancesLaunchedByCurrentUser(session, null);
    }

    public List<DocumentRoute> getRunningWorkflowInstancesLaunchedByCurrentUser(CoreSession session, String worflowModelName) {
        String query = String.format("SELECT * FROM %s WHERE docri:initiator = '%s' AND ecm:currentLifeCycleState = '%s'", "DocumentRoute", session.getPrincipal().getName(), DocumentRouteElement.ElementLifeCycleState.running);
        DocumentModelList documentModelList = session.query(query);
        ArrayList<DocumentRoute> result = new ArrayList<DocumentRoute>();
        for (DocumentModel documentModel : documentModelList) {
            GraphRoute graphRoute = (GraphRoute)documentModel.getAdapter(GraphRoute.class);
            if (StringUtils.isNotBlank((CharSequence)worflowModelName)) {
                DocumentRoute model;
                String modelId = graphRoute.getModelId();
                if (!StringUtils.isNotBlank((CharSequence)modelId) || !worflowModelName.equals((model = (DocumentRoute)session.getDocument((DocumentRef)new IdRef(modelId)).getAdapter(DocumentRoute.class)).getName())) continue;
                result.add(graphRoute);
                continue;
            }
            result.add(graphRoute);
        }
        return result;
    }

    public boolean isWorkflowModel(DocumentRoute documentRoute) {
        return documentRoute.isValidated();
    }

    public static class AttachedDocumentsChecker
    extends UnrestrictedSessionRunner {
        String workflowInstanceId;
        boolean isWorkflowCanceled;

        protected AttachedDocumentsChecker(CoreSession session, String workflowInstanceId) {
            super(session);
            this.workflowInstanceId = workflowInstanceId;
        }

        public void run() {
            DocumentModel routeDoc = this.session.getDocument((DocumentRef)new IdRef(this.workflowInstanceId));
            DocumentRoute routeInstance = (DocumentRoute)routeDoc.getAdapter(DocumentRoute.class);
            List attachedDocumentIds = routeInstance.getAttachedDocuments();
            if (attachedDocumentIds.isEmpty()) {
                return;
            }
            for (String attachedDocumentId : attachedDocumentIds) {
                if (!this.session.exists((DocumentRef)new IdRef(attachedDocumentId))) continue;
                return;
            }
            DocumentRoutingEngineService routingEngine = (DocumentRoutingEngineService)Framework.getService(DocumentRoutingEngineService.class);
            routingEngine.cancel(routeInstance, this.session);
            this.isWorkflowCanceled = true;
        }
    }

    class UnrestrictedQueryRunner
    extends UnrestrictedSessionRunner {
        String query;
        DocumentModelList docs;

        protected UnrestrictedQueryRunner(CoreSession session, String query) {
            super(session);
            this.query = query;
        }

        public void run() {
            this.docs = this.session.query(this.query);
            for (DocumentModel documentModel : this.docs) {
                documentModel.detach(true);
            }
        }

        public DocumentModelList runQuery() {
            this.runUnrestricted();
            return this.docs;
        }
    }

    private final class WfCleaner
    extends UnrestrictedSessionRunner {
        private static final String WORKFLOWS_QUERY = "SELECT ecm:uuid FROM DocumentRoute WHERE ecm:currentLifeCycleState IN ('done', 'canceled')";
        private static final String TASKS_QUERY = "SELECT ecm:uuid FROM Document WHERE ecm:mixinType = 'Task' AND nt:processId = '%s'";
        private final int limit;
        private int numberOfCleanedUpWorkflows;

        private WfCleaner(String repositoryName, int limit) {
            super(repositoryName);
            this.numberOfCleanedUpWorkflows = 0;
            this.limit = limit;
        }

        public void run() {
            PartialList workflows = this.session.queryProjection(WORKFLOWS_QUERY, (long)this.limit, 0L);
            this.numberOfCleanedUpWorkflows = workflows.size();
            for (Map workflow : workflows) {
                String routeDocId = ((Serializable)workflow.get("ecm:uuid")).toString();
                String associatedTaskQuery = String.format(TASKS_QUERY, routeDocId);
                this.session.queryProjection(associatedTaskQuery, 0L, 0L).stream().map(task -> new IdRef(((Serializable)task.get("ecm:uuid")).toString())).forEach(arg_0 -> ((CoreSession)this.session).removeDocument(arg_0));
                this.session.removeDocument((DocumentRef)new IdRef(routeDocId));
            }
        }

        public int getNumberOfCleanedUpWf() {
            return this.numberOfCleanedUpWorkflows;
        }
    }

    private class CompleteTaskRunner
    extends UnrestrictedSessionRunner {
        String routeId;
        String nodeId;
        Task task;
        Map<String, Object> data;
        String status;

        protected CompleteTaskRunner(String routeId, String nodeId, Task task, Map<String, Object> data, String status, CoreSession session) {
            super(session);
            this.routeId = routeId;
            this.nodeId = nodeId;
            this.task = task;
            this.data = data;
            this.status = status;
        }

        public void run() {
            DocumentRoutingEngineService routingEngine = (DocumentRoutingEngineService)Framework.getService(DocumentRoutingEngineService.class);
            DocumentModel routeDoc = this.session.getDocument((DocumentRef)new IdRef(this.routeId));
            DocumentRoute routeInstance = (DocumentRoute)routeDoc.getAdapter(DocumentRoute.class);
            routingEngine.resume(routeInstance, this.nodeId, this.task != null ? this.task.getId() : null, this.data, this.status, this.session);
            if (this.task != null) {
                String comment = this.data != null ? (String)this.data.get("comment") : null;
                HashMap<String, String> extraEventProperties = new HashMap<String, String>();
                extraEventProperties.put("workflowTaskCompletionAction", this.status);
                TaskEventNotificationHelper.notifyTaskEnded((CoreSession)this.session, (NuxeoPrincipal)this.session.getPrincipal(), (Task)this.task, (String)comment, (String)"workflowTaskCompleted", extraEventProperties);
            }
        }
    }
}

