/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.runtime.api.Framework;

public class RoutingTaskSecurityUpdaterListener
implements EventListener {
    public void handleEvent(Event event) {
        EventContext eventCtx = event.getContext();
        if (!(eventCtx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docEventCtx = (DocumentEventContext)eventCtx;
        Task task = (Task)docEventCtx.getProperties().get("taskInstance");
        if (task == null) {
            return;
        }
        CoreSession session = eventCtx.getCoreSession();
        List actors = null;
        if ("workflowTaskAssigned".equals(event.getName()) || "workflowTaskReassigned".equals(event.getName())) {
            actors = task.getActors();
        }
        if ("workflowTaskDelegated".equals(event.getName())) {
            actors = task.getDelegatedActors();
        }
        if (actors == null || actors.isEmpty()) {
            return;
        }
        String routeDocId = (String)task.getVariables().get("routeInstanceDocId");
        if (routeDocId == null) {
            return;
        }
        DocumentModel routeDoc = session.getDocument((DocumentRef)new IdRef(routeDocId));
        for (String userName : actors) {
            ACE ace;
            ACP acp;
            ACL routeACL;
            if (userName.startsWith("group:") || userName.startsWith("user:")) {
                userName = userName.substring(userName.indexOf(":") + 1);
            }
            if (!(routeACL = (acp = routeDoc.getACP()).getOrCreateACL("routingTask")).contains((Object)(ace = new ACE(userName, "ReadWrite", true)))) {
                routeACL.add(ace);
            }
            acp.addACL(routeACL);
            session.setACP(routeDoc.getRef(), acp, false);
        }
        session.saveDocument(routeDoc);
    }

    protected DocumentRoutingService getDocumentRoutingService() {
        return (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
    }
}

