/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.lazy;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.rendition.extension.DefaultAutomationRenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractLazyCachableRenditionProvider
extends DefaultAutomationRenditionProvider {
    public static final String SOURCE_DOCUMENT_MODIFICATION_DATE_KEY = "sourceDocumentModificationDate";
    public static final String CACHE_NAME = "LazyRenditionCache";
    protected static Logger log = LogManager.getLogger(AbstractLazyCachableRenditionProvider.class);
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    @Override
    public List<Blob> render(DocumentModel doc, RenditionDefinition definition) {
        List blobs;
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> ((RenditionDefinition)definition).getName();
        supplierArray[1] = () -> ((DocumentModel)doc).getPathAsString();
        supplierArray[2] = () -> ((DocumentModel)doc).getId();
        log.debug("Asking \"{}\" rendition lazy rendering for document {} (id={}).", supplierArray);
        String key = this.buildRenditionKey(doc, definition);
        String sourceDocumentModificationDate = this.getSourceDocumentModificationDate(doc, definition);
        TransientStore ts = this.getTransientStore();
        if (!ts.exists(key)) {
            blobs = this.handleNewRendition(key, doc, definition, sourceDocumentModificationDate);
        } else {
            String tsSourceDocumentModificationDate = (String)((Object)ts.getParameter(key, SOURCE_DOCUMENT_MODIFICATION_DATE_KEY));
            blobs = ts.getBlobs(key);
            if (ts.isCompleted(key)) {
                this.handleCompletedRendition(key, doc, definition, sourceDocumentModificationDate, tsSourceDocumentModificationDate, blobs);
            } else {
                this.handleIncompleteRendition(key, doc, definition, sourceDocumentModificationDate, tsSourceDocumentModificationDate);
            }
        }
        List finalBlobs = blobs;
        log.debug("Returning blobs: {}.", new Supplier[]{() -> this.getBlobInfo(finalBlobs)});
        return blobs;
    }

    protected String getBlobInfo(List<Blob> blobs) {
        if (blobs == null) {
            return null;
        }
        return blobs.stream().map(blob -> String.format("{filename=%s, MIME type=%s}", blob.getFilename(), blob.getMimeType())).collect(Collectors.joining(",", "[", "]"));
    }

    public String buildRenditionKey(DocumentModel doc, RenditionDefinition def) {
        StringBuilder sb = new StringBuilder(doc.getId());
        sb.append("::");
        String variant = this.getVariant(doc, def);
        if (variant != null) {
            sb.append(variant);
            sb.append("::");
        }
        sb.append(def.getName());
        String key = this.getDigest(sb.toString());
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
        supplierArray[1] = () -> ((DocumentModel)doc).getId();
        supplierArray[2] = () -> key;
        log.debug("Built rendition key for document {} (id={}): {}.", supplierArray);
        return key;
    }

    public String getSourceDocumentModificationDate(DocumentModel doc, RenditionDefinition definition) {
        String modificationDatePropertyName = definition.getSourceDocumentModificationDatePropertyName();
        Calendar modificationDate = (Calendar)doc.getPropertyValue(modificationDatePropertyName);
        if (modificationDate == null) {
            return null;
        }
        long millis = modificationDate.getTimeInMillis();
        millis -= millis % 1000L;
        return String.valueOf(millis);
    }

    protected String getDigest(String key) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return key;
        }
        byte[] buf = digest.digest(key.getBytes());
        return this.toHexString(buf);
    }

    protected String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(2 * data.length);
        for (byte b : data) {
            sb.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            sb.append(HEX_DIGITS[0xF & b]);
        }
        return sb.toString();
    }

    protected TransientStore getTransientStore() {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore(CACHE_NAME);
        if (ts == null) {
            throw new NuxeoException("Unable to find Transient Store  LazyRenditionCache");
        }
        return ts;
    }

    protected List<Blob> handleNewRendition(String key, DocumentModel doc, RenditionDefinition definition, String sourceDocumentModificationDate) {
        Work work = this.getRenditionWork(key, doc, definition);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> key;
        supplierArray[1] = () -> CACHE_NAME;
        supplierArray[2] = () -> ((Work)work).getId();
        log.debug("No entry found for key {} in the {} transient store, scheduling rendition work with id {} and storing an empty blob for now.", supplierArray);
        if (sourceDocumentModificationDate != null) {
            this.getTransientStore().putParameter(key, SOURCE_DOCUMENT_MODIFICATION_DATE_KEY, (Serializable)((Object)sourceDocumentModificationDate));
        }
        StringBlob emptyBlob = new StringBlob("");
        emptyBlob.setFilename("inprogress");
        emptyBlob.setMimeType("text/plain;empty=true");
        this.getTransientStore().putBlobs(key, Collections.singletonList(emptyBlob));
        ((WorkManager)Framework.getService(WorkManager.class)).schedule(work);
        return Collections.singletonList(emptyBlob);
    }

    protected void handleCompletedRendition(String key, DocumentModel doc, RenditionDefinition definition, String sourceDocumentModificationDate, String tsSourceDocumentModificationDate, List<Blob> blobs) {
        log.debug("Completed entry found for key {} in the {} transient store.", (Object)key, (Object)CACHE_NAME);
        if (blobs == null || blobs.size() != 1) {
            log.debug("No (or more than one) rendition blob for key {}, releasing entry from the transient store.", (Object)key);
            this.getTransientStore().release(key);
            return;
        }
        Blob blob = blobs.get(0);
        String mimeType = blob.getMimeType();
        if (mimeType != null && mimeType.contains("error=true")) {
            log.debug("Rendition blob is in error for key {}.", (Object)key);
            if (Objects.equals(tsSourceDocumentModificationDate, sourceDocumentModificationDate)) {
                log.debug("Removing entry from the transient store.");
                this.getTransientStore().remove(key);
                return;
            }
            Work work = this.getRenditionWork(key, doc, definition);
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> sourceDocumentModificationDate;
            supplierArray[1] = () -> tsSourceDocumentModificationDate;
            supplierArray[2] = () -> ((Work)work).getId();
            log.debug("Source document modification date {} is different from the corresponding transient store parameter {}, scheduling rendition work with id {} and returning an error/stale rendition.", supplierArray);
            ((WorkManager)Framework.getService(WorkManager.class)).schedule(work);
            blob.setMimeType(blob.getMimeType() + ";stale=true");
            return;
        }
        if (Objects.equals(tsSourceDocumentModificationDate, sourceDocumentModificationDate)) {
            log.debug("Rendition blob is up-to-date for key {}, returning it and releasing entry from the transient store.", (Object)key);
            this.getTransientStore().release(key);
            return;
        }
        Work work = this.getRenditionWork(key, doc, definition);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> sourceDocumentModificationDate;
        supplierArray[1] = () -> tsSourceDocumentModificationDate;
        supplierArray[2] = () -> ((Work)work).getId();
        log.debug("Source document modification date {} is different from the corresponding transient store parameter {}, scheduling rendition work with id {} and returning a stale rendition.", supplierArray);
        ((WorkManager)Framework.getService(WorkManager.class)).schedule(work);
        blob.setMimeType(blob.getMimeType() + ";stale=true");
    }

    protected void handleIncompleteRendition(String key, DocumentModel doc, RenditionDefinition definition, String sourceDocumentModificationDate, String tsSourceDocumentModificationDate) {
        log.debug("Incomplete entry found for key {} in the {} transient store.", (Object)key, (Object)CACHE_NAME);
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        Work work = this.getRenditionWork(key, doc, definition);
        String workId = work.getId();
        boolean scheduleWork = false;
        if (Objects.equals(tsSourceDocumentModificationDate, sourceDocumentModificationDate)) {
            Work.State workState = workManager.getWorkState(workId);
            if (workState == null) {
                log.debug("Found no existing work with id {}.", (Object)workId);
                scheduleWork = true;
            } else {
                log.debug("Found an existing work with id {} in sate {}.", (Object)workId, (Object)workState);
            }
        } else {
            log.debug("Source document modification date {} is different from the corresponding transient store parameter {}.", (Object)sourceDocumentModificationDate, (Object)tsSourceDocumentModificationDate);
            scheduleWork = true;
        }
        if (scheduleWork) {
            log.debug("Scheduling rendition work with id {}.", (Object)workId);
            workManager.schedule(work);
        }
    }

    protected abstract Work getRenditionWork(String var1, DocumentModel var2, RenditionDefinition var3);
}

