/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification.service;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerHook;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerVeto;
import org.nuxeo.ecm.platform.ec.notification.SubscriptionAdapter;
import org.nuxeo.ecm.platform.ec.notification.email.EmailHelper;
import org.nuxeo.ecm.platform.ec.notification.service.GeneralSettingsDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationEventDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationListenerHookDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationListenerVetoDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationListenerVetoRegistry;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationRegistryImpl;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.ec.notification.service.TemplateDescriptor;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.ecm.platform.notification.api.NotificationRegistry;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class NotificationService
extends DefaultComponent
implements NotificationManager {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.ec.notification.service.NotificationService");
    private static final Log log = LogFactory.getLog(NotificationService.class);
    @Deprecated
    public static final String SUBSCRIPTION_NAME = "UserSubscription";
    protected static final String NOTIFICATIONS_EP = "notifications";
    protected static final String TEMPLATES_EP = "templates";
    protected static final String GENERAL_SETTINGS_EP = "generalSettings";
    protected static final String NOTIFICATION_HOOK_EP = "notificationListenerHook";
    protected static final String NOTIFICATION_VETO_EP = "notificationListenerVeto";
    protected static final Map<String, URL> TEMPLATES_MAP = new HashMap<String, URL>();
    protected EmailHelper emailHelper = new EmailHelper();
    protected GeneralSettingsDescriptor generalSettings;
    protected NotificationRegistry notificationRegistry;
    protected DocumentViewCodecManager docLocator;
    protected final Map<String, NotificationListenerHook> hookListeners = new HashMap<String, NotificationListenerHook>();
    protected NotificationListenerVetoRegistry notificationVetoRegistry;
    protected EventProducer producer;

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(NotificationManager.class)) {
            return (T)((Object)this);
        }
        return null;
    }

    public void activate(ComponentContext context) {
        this.notificationRegistry = new NotificationRegistryImpl();
        this.notificationVetoRegistry = new NotificationListenerVetoRegistry();
        this.generalSettings = new GeneralSettingsDescriptor();
        this.generalSettings.serverPrefix = "http://localhost:8080/nuxeo/";
        this.generalSettings.eMailSubjectPrefix = "[Nuxeo]";
        this.generalSettings.mailSessionJndiName = "java:/Mail";
    }

    public void deactivate(ComponentContext context) {
        this.notificationRegistry.clear();
        this.notificationVetoRegistry.clear();
        this.notificationRegistry = null;
        this.notificationVetoRegistry = null;
    }

    public void registerExtension(Extension extension) {
        block8: {
            Object[] contribs;
            String xp;
            block11: {
                Object[] contribs2;
                block10: {
                    Object[] contribs3;
                    block9: {
                        Object[] contribs4;
                        block7: {
                            Object[] contribs5;
                            log.info((Object)"Registering notification extension");
                            xp = extension.getExtensionPoint();
                            if (!NOTIFICATIONS_EP.equals(xp)) break block7;
                            for (Object contrib : contribs5 = extension.getContributions()) {
                                NotificationDescriptor notifDesc = (NotificationDescriptor)contrib;
                                this.notificationRegistry.registerNotification((Notification)notifDesc, NotificationService.getNames(notifDesc.getEvents()));
                            }
                            break block8;
                        }
                        if (!TEMPLATES_EP.equals(xp)) break block9;
                        for (Object contrib : contribs4 = extension.getContributions()) {
                            TemplateDescriptor templateDescriptor = (TemplateDescriptor)contrib;
                            templateDescriptor.setContext(extension.getContext());
                            NotificationService.registerTemplate(templateDescriptor);
                        }
                        break block8;
                    }
                    if (!GENERAL_SETTINGS_EP.equals(xp)) break block10;
                    for (Object contrib : contribs3 = extension.getContributions()) {
                        this.registerGeneralSettings((GeneralSettingsDescriptor)contrib);
                    }
                    break block8;
                }
                if (!NOTIFICATION_HOOK_EP.equals(xp)) break block11;
                for (Object contrib : contribs2 = extension.getContributions()) {
                    NotificationListenerHookDescriptor desc = (NotificationListenerHookDescriptor)contrib;
                    Class<? extends NotificationListenerHook> clazz = desc.hookListener;
                    try {
                        NotificationListenerHook hookListener = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.registerHookListener(desc.name, hookListener);
                    }
                    catch (ReflectiveOperationException e) {
                        log.error((Object)e);
                    }
                }
                break block8;
            }
            if (!NOTIFICATION_VETO_EP.equals(xp)) break block8;
            for (Object contrib : contribs = extension.getContributions()) {
                NotificationListenerVetoDescriptor desc = (NotificationListenerVetoDescriptor)contrib;
                this.notificationVetoRegistry.addContribution(desc);
            }
        }
    }

    private void registerHookListener(String name, NotificationListenerHook hookListener) {
        this.hookListeners.put(name, hookListener);
    }

    protected void registerGeneralSettings(GeneralSettingsDescriptor desc) {
        this.generalSettings = desc;
        String serverPrefix = Framework.expandVars((String)this.generalSettings.serverPrefix);
        if (serverPrefix != null) {
            this.generalSettings.serverPrefix = serverPrefix.endsWith("//") ? serverPrefix.substring(0, serverPrefix.length() - 1) : serverPrefix;
        }
        this.generalSettings.eMailSubjectPrefix = Framework.expandVars((String)this.generalSettings.eMailSubjectPrefix);
        this.generalSettings.mailSessionJndiName = Framework.expandVars((String)this.generalSettings.mailSessionJndiName);
    }

    private static List<String> getNames(List<NotificationEventDescriptor> events) {
        ArrayList<String> eventNames = new ArrayList<String>();
        for (NotificationEventDescriptor descriptor : events) {
            eventNames.add(descriptor.name);
        }
        return eventNames;
    }

    public void unregisterExtension(Extension extension) {
        block4: {
            Object[] contribs;
            String xp;
            block5: {
                Object[] contribs2;
                block3: {
                    Object[] contribs3;
                    xp = extension.getExtensionPoint();
                    if (!NOTIFICATIONS_EP.equals(xp)) break block3;
                    for (Object contrib : contribs3 = extension.getContributions()) {
                        NotificationDescriptor notifDesc = (NotificationDescriptor)contrib;
                        this.notificationRegistry.unregisterNotification((Notification)notifDesc);
                    }
                    break block4;
                }
                if (!TEMPLATES_EP.equals(xp)) break block5;
                for (Object contrib : contribs2 = extension.getContributions()) {
                    TemplateDescriptor templateDescriptor = (TemplateDescriptor)contrib;
                    templateDescriptor.setContext(extension.getContext());
                    NotificationService.unregisterTemplate(templateDescriptor);
                }
                break block4;
            }
            if (!NOTIFICATION_VETO_EP.equals(xp)) break block4;
            for (Object contrib : contribs = extension.getContributions()) {
                NotificationListenerVetoDescriptor vetoDescriptor = (NotificationListenerVetoDescriptor)contrib;
                this.notificationVetoRegistry.removeContribution(vetoDescriptor);
            }
        }
    }

    public NotificationListenerVetoRegistry getNotificationListenerVetoRegistry() {
        return this.notificationVetoRegistry;
    }

    public List<String> getSubscribers(String notification, DocumentModel doc) {
        return ((SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class)).getNotificationSubscribers(notification);
    }

    public List<String> getSubscriptionsForUserOnDocument(String username, DocumentModel doc) {
        return ((SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class)).getUserSubscriptions(username);
    }

    protected void disableEvents(DocumentModel doc) {
        doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
    }

    protected void restoreEvents(DocumentModel doc) {
        doc.putContextData("disableDublinCoreListener", null);
        doc.putContextData("disableNotificationService", null);
        doc.putContextData("disableAuditLogger", null);
        doc.putContextData("DisableAutoCheckOut", null);
    }

    public void addSubscription(String username, String notification, DocumentModel doc, Boolean sendConfirmationEmail, NuxeoPrincipal principal, String notificationName) {
        CoreInstance.doPrivileged((String)doc.getRepositoryName(), session -> {
            ((SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class)).addSubscription(username, notification);
            this.disableEvents(doc);
            session.saveDocument(doc);
            this.restoreEvents(doc);
        });
        if (sendConfirmationEmail.booleanValue()) {
            this.raiseConfirmationEvent(principal, doc, username, notificationName);
        }
    }

    public void addSubscriptions(String username, DocumentModel doc, Boolean sendConfirmationEmail, NuxeoPrincipal principal) {
        CoreInstance.doPrivileged((String)doc.getRepositoryName(), session -> {
            ((SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class)).addSubscriptionsToAll(username);
            this.disableEvents(doc);
            session.saveDocument(doc);
            this.restoreEvents(doc);
        });
        if (sendConfirmationEmail.booleanValue()) {
            this.raiseConfirmationEvent(principal, doc, username, "All Notifications");
        }
    }

    public void removeSubscriptions(String username, List<String> notifications, DocumentModel doc) {
        CoreInstance.doPrivileged((String)doc.getRepositoryName(), session -> {
            SubscriptionAdapter sa = (SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class);
            for (String notification : notifications) {
                sa.removeUserNotificationSubscription(username, notification);
            }
            this.disableEvents(doc);
            session.saveDocument(doc);
            this.restoreEvents(doc);
        });
    }

    protected void doFireEvent(Event event) {
        if (this.producer == null) {
            this.producer = (EventProducer)Framework.getService(EventProducer.class);
        }
        this.producer.fireEvent(event);
    }

    private void raiseConfirmationEvent(NuxeoPrincipal principal, DocumentModel doc, String username, String notification) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("repositoryName", doc.getRepositoryName());
        options.put("sessionId", doc.getSessionId());
        options.put("recipients", username);
        options.put("notifName", notification);
        CoreSession session = doc.getCoreSession();
        DocumentEventContext ctx = new DocumentEventContext(session, principal, doc);
        ctx.setCategory("clientCodeNotificationCategory");
        ctx.setProperties(options);
        Event event = ctx.newEvent("subscriptionAssigned");
        this.doFireEvent(event);
    }

    public void removeSubscription(String username, String notification, DocumentModel doc) {
        this.removeSubscriptions(username, Collections.singletonList(notification), doc);
    }

    private static void registerTemplate(TemplateDescriptor td) {
        if (td.src != null && td.src.length() > 0) {
            URL url = td.getContext().getResource(td.src);
            TEMPLATES_MAP.put(td.name, url);
        }
    }

    private static void unregisterTemplate(TemplateDescriptor td) {
        if (td.name != null) {
            TEMPLATES_MAP.remove(td.name);
        }
    }

    public static URL getTemplateURL(String name) {
        return TEMPLATES_MAP.get(name);
    }

    public String getServerUrlPrefix() {
        return this.generalSettings.getServerPrefix();
    }

    public String getEMailSubjectPrefix() {
        return this.generalSettings.getEMailSubjectPrefix();
    }

    public String getMailSessionJndiName() {
        return this.generalSettings.getMailSessionJndiName();
    }

    public Notification getNotificationByName(String selectedNotification) {
        List listNotif = this.notificationRegistry.getNotifications();
        for (Notification notification : listNotif) {
            if (!notification.getName().equals(selectedNotification)) continue;
            return notification;
        }
        return null;
    }

    public void sendNotification(String notificationName, Map<String, Object> infoMap, String userPrincipal) {
        Object subject;
        Notification notif = this.getNotificationByName(notificationName);
        NuxeoPrincipal recipient = NotificationServiceHelper.getUsersService().getPrincipal(userPrincipal);
        String email = recipient.getEmail();
        String mailTemplate = notif.getTemplate();
        infoMap.put("mail.to", email);
        String authorUsername = (String)infoMap.get("author");
        if (authorUsername != null) {
            NuxeoPrincipal author = NotificationServiceHelper.getUsersService().getPrincipal(authorUsername);
            infoMap.put("principalAuthor", author);
        }
        Object object = subject = notif.getSubject() == null ? "Alert" : notif.getSubject();
        if (notif.getSubjectTemplate() != null) {
            subject = notif.getSubjectTemplate();
        }
        subject = NotificationServiceHelper.getNotificationService().getEMailSubjectPrefix() + " " + (String)subject;
        infoMap.put("subject", subject);
        infoMap.put("template", mailTemplate);
        try {
            this.emailHelper.sendmail(infoMap);
        }
        catch (MessagingException e) {
            throw new NuxeoException("Failed to send notification email ", (Throwable)e);
        }
    }

    public void sendDocumentByMail(DocumentModel doc, String freemarkerTemplateName, String subject, String comment, NuxeoPrincipal sender, List<String> sendTo) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("document", doc);
        infoMap.put("subject", subject);
        infoMap.put("comment", comment);
        infoMap.put("sender", sender);
        DocumentLocationImpl docLoc = new DocumentLocationImpl(doc);
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc);
        docView.setViewId("view_documents");
        infoMap.put("docUrl", this.getDocLocator().getUrlFromDocumentView((DocumentView)docView, true, NotificationServiceHelper.getNotificationService().getServerUrlPrefix()));
        if (freemarkerTemplateName == null) {
            freemarkerTemplateName = "defaultNotifTemplate";
        }
        infoMap.put("template", freemarkerTemplateName);
        for (String to : sendTo) {
            infoMap.put("mail.to", to);
            try {
                this.emailHelper.sendmail(infoMap);
            }
            catch (MessagingException e) {
                log.debug((Object)("Failed to send notification email " + e));
            }
        }
    }

    private DocumentViewCodecManager getDocLocator() {
        if (this.docLocator == null) {
            this.docLocator = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        }
        return this.docLocator;
    }

    public List<Notification> getNotificationsForSubscriptions(String parentType) {
        return this.notificationRegistry.getNotificationsForSubscriptions(parentType);
    }

    public List<Notification> getNotificationsForEvents(String eventId) {
        return this.notificationRegistry.getNotificationsForEvent(eventId);
    }

    public EmailHelper getEmailHelper() {
        return this.emailHelper;
    }

    public void setEmailHelper(EmailHelper emailHelper) {
        this.emailHelper = emailHelper;
    }

    public Set<String> getNotificationEventNames() {
        return this.notificationRegistry.getNotificationEventNames();
    }

    public Collection<NotificationListenerHook> getListenerHooks() {
        return this.hookListeners.values();
    }

    public Collection<NotificationListenerVeto> getNotificationVetos() {
        return this.notificationVetoRegistry.getVetos();
    }

    public List<String> getUsersSubscribedToNotificationOnDocument(String notification, DocumentModel doc) {
        return this.getSubscribers(notification, doc);
    }

    public List<DocumentModel> getSubscribedDocuments(String prefixedPrincipalName, String repositoryName) {
        String nxql = "SELECT * FROM Document WHERE ecm:mixinType = 'Notifiable' AND ecm:isVersion = 0 AND notif:notifications/*/subscribers/* = " + NXQL.escapeString((String)prefixedPrincipalName);
        return (List)CoreInstance.doPrivileged((String)repositoryName, s -> s.query(nxql).stream().map(NotificationService::detachDocumentModel).collect(Collectors.toList()));
    }

    protected static DocumentModel detachDocumentModel(DocumentModel doc) {
        doc.detach(true);
        return doc;
    }
}

