/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.service;

import com.thetransactioncompany.cors.CORSFilter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.FilterConfigDescriptor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.LRUCachingMap;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.NuxeoCorsFilterDescriptor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.NuxeoCorsFilterDescriptorRegistry;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.NuxeoHeaderDescriptor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.NuxeoHeaderDescriptorRegistry;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestControllerManager;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestFilterConfig;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestFilterConfigImpl;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class RequestControllerService
extends DefaultComponent
implements RequestControllerManager {
    public static final String FILTER_CONFIG_EP = "filterConfig";
    public static final String CORS_CONFIG_EP = "corsConfig";
    public static final String HEADERS_CONFIG_EP = "responseHeaders";
    private static final Log log = LogFactory.getLog(RequestControllerService.class);
    protected final Map<String, FilterConfigDescriptor> grantPatterns = new LinkedHashMap<String, FilterConfigDescriptor>();
    protected final Map<String, FilterConfigDescriptor> denyPatterns = new LinkedHashMap<String, FilterConfigDescriptor>();
    protected final Map<String, RequestFilterConfig> configCache = new LRUCachingMap<String, RequestFilterConfig>(250);
    protected final NuxeoCorsFilterDescriptorRegistry corsFilterRegistry = new NuxeoCorsFilterDescriptorRegistry();
    protected final NuxeoHeaderDescriptorRegistry headersRegistry = new NuxeoHeaderDescriptorRegistry();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (FILTER_CONFIG_EP.equals(extensionPoint)) {
            FilterConfigDescriptor desc = (FilterConfigDescriptor)contribution;
            this.registerFilterConfig(desc);
        } else if (CORS_CONFIG_EP.equals(extensionPoint)) {
            this.corsFilterRegistry.addContribution((NuxeoCorsFilterDescriptor)contribution);
        } else if (HEADERS_CONFIG_EP.equals(extensionPoint)) {
            this.headersRegistry.addContribution((NuxeoHeaderDescriptor)contribution);
        } else {
            log.error((Object)("Unknown ExtensionPoint " + extensionPoint));
        }
    }

    public void registerFilterConfig(String name, String pattern, boolean grant, boolean tx, boolean sync, boolean cached, boolean isPrivate, String cacheTime) {
        FilterConfigDescriptor desc = new FilterConfigDescriptor(name, pattern, grant, tx, sync, cached, isPrivate, cacheTime);
        this.registerFilterConfig(desc);
    }

    public void registerFilterConfig(FilterConfigDescriptor desc) {
        if (desc.isGrantRule()) {
            this.grantPatterns.put(desc.getName(), desc);
            log.debug((Object)"Registered grant filter config");
        } else {
            this.denyPatterns.put(desc.getName(), desc);
            log.debug((Object)"Registered deny filter config");
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CORS_CONFIG_EP.equals(extensionPoint)) {
            this.corsFilterRegistry.removeContribution((NuxeoCorsFilterDescriptor)contribution);
        }
    }

    @Override
    public CORSFilter getCorsFilterForRequest(HttpServletRequest request) {
        String uri = request.getRequestURI();
        NuxeoCorsFilterDescriptor descriptor = this.corsFilterRegistry.getFirstMatchingDescriptor(uri);
        return descriptor == null ? null : descriptor.getFilter();
    }

    @Override
    @Deprecated
    public FilterConfig getCorsConfigForRequest(HttpServletRequest request) {
        String uri = request.getRequestURI();
        NuxeoCorsFilterDescriptor descriptor = this.corsFilterRegistry.getFirstMatchingDescriptor(uri);
        return descriptor != null ? descriptor.buildFilterConfig() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestFilterConfig getConfigForRequest(HttpServletRequest request) {
        Object uri = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            uri = (String)uri + "?" + queryString;
        }
        RequestFilterConfig config = null;
        Map<String, RequestFilterConfig> map = this.configCache;
        synchronized (map) {
            config = this.configCache.get(uri);
        }
        if (config == null) {
            config = this.computeConfigForRequest((String)uri);
            map = this.configCache;
            synchronized (map) {
                this.configCache.put((String)uri, config);
            }
        }
        return config;
    }

    public RequestFilterConfig computeConfigForRequest(String uri) {
        Matcher m;
        Pattern pat;
        for (FilterConfigDescriptor desc : this.denyPatterns.values()) {
            pat = desc.getCompiledPattern();
            m = pat.matcher(uri);
            if (!m.matches()) continue;
            return new RequestFilterConfigImpl(false, false, false, false, false, "");
        }
        for (FilterConfigDescriptor desc : this.grantPatterns.values()) {
            pat = desc.getCompiledPattern();
            m = pat.matcher(uri);
            if (!m.matches()) continue;
            return new RequestFilterConfigImpl(desc.useSync(), desc.useTx(), desc.useTxBuffered(), desc.isCached(), desc.isPrivate(), desc.getCacheTime());
        }
        return new RequestFilterConfigImpl(false, false, false, false, false, "");
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        HashMap<String, String> headersCache = new HashMap<String, String>();
        for (NuxeoHeaderDescriptor header : this.headersRegistry.descs.values()) {
            if (!header.isEnabled()) continue;
            headersCache.put(header.name, header.getValue());
        }
        return headersCache;
    }
}

