/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.csv.export.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryEntryResolver;
import org.nuxeo.runtime.api.Framework;

public class DocumentModelCSVHelper {
    public static final String[] SYSTEM_PROPERTIES_HEADER_FIELDS = new String[]{"repository", "uid", "path", "type", "state", "parentRef", "isCheckedOut", "isVersion", "isProxy", "proxyTargetId", "versionableId", "changeToken", "isTrashed", "title", "versionLabel", "lockOwner", "lockCreated", "lastModified"};
    public static final List<String> VOCABULARY_TYPES = Arrays.asList("vocabulary", "xvocabulary", "l10nxvocabulary");

    public static void printSystemPropertiesHeader(CSVPrinter printer) throws IOException {
        for (String header : SYSTEM_PROPERTIES_HEADER_FIELDS) {
            printer.print((Object)header);
        }
    }

    public static void printPropertiesHeader(List<String> schemas, List<String> xpaths, CSVPrinter printer) throws IOException {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        for (String schemaName : schemas) {
            Schema schema = schemaManager.getSchema(schemaName);
            if (schema == null) continue;
            ArrayList<Field> fields = new ArrayList<Field>(schema.getFields());
            fields.sort(Comparator.comparing(o -> o.getName().getLocalName()));
            Object prefix = schema.getNamespace().prefix;
            if (StringUtils.isBlank((CharSequence)prefix)) {
                prefix = schema.getName();
            }
            prefix = (String)prefix + ":";
            for (Field f : fields) {
                String prefixedName = (String)prefix + f.getName().getLocalName();
                printer.print((Object)prefixedName);
                if (!DocumentModelCSVHelper.isVocabulary(f.getType())) continue;
                printer.print((Object)(prefixedName + "[label]"));
            }
        }
        for (String xpath : xpaths) {
            Field field = schemaManager.getField(xpath);
            if (field == null) continue;
            printer.print((Object)xpath);
            if (!DocumentModelCSVHelper.isVocabulary(field.getType())) continue;
            printer.print((Object)(xpath + "[label]"));
        }
    }

    public static boolean isVocabulary(Type type) {
        ObjectResolver resolver;
        if (type instanceof ListType) {
            type = ((ListType)type).getFieldType();
        }
        if ((resolver = type.getObjectResolver()) instanceof DirectoryEntryResolver) {
            DirectoryEntryResolver directoryEntryResolver = (DirectoryEntryResolver)resolver;
            return VOCABULARY_TYPES.contains(directoryEntryResolver.getDirectory().getSchema());
        }
        return false;
    }

    public static Directory getVocabulary(Type type) {
        if (type instanceof ListType) {
            type = ((ListType)type).getFieldType();
        }
        if (DocumentModelCSVHelper.isVocabulary(type)) {
            return ((DirectoryEntryResolver)type.getObjectResolver()).getDirectory();
        }
        return null;
    }

    public static List<String> getList(RenderingContext ctx, String key) {
        Object value = ctx.getParameter(key);
        if (value == null) {
            return Collections.emptyList();
        }
        return ((List)value).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private DocumentModelCSVHelper() {
    }
}

