/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.api.operation;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.propertiesmapping.PropertiesMappingService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;

@Operation(id="Task.ApplyDocumentMapping", category="Workflow Context", label="Apply mapping on input task doc", requires="Workflow", description="Applies the mapping passed in parameter on the task document. The sourceDoc in the mapping is the input document in the workflow. The operation throws a NuxeoException if the input document is not a Task.", aliases={"Context.ApplyMappingOnTask"})
public class MapPropertiesOnTaskOperation {
    public static final String ID = "Task.ApplyDocumentMapping";
    private static Log log = LogFactory.getLog(MapPropertiesOnTaskOperation.class);
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="mappingName", required=true)
    protected String mappingName;
    @Context
    protected DocumentRoutingService routing;
    @Context
    protected PropertiesMappingService mappingService;

    @OperationMethod
    public DocumentModel run(DocumentModel taskDoc) {
        Task task = (Task)taskDoc.getAdapter(Task.class);
        if (task == null) {
            throw new NuxeoException("Input document is not a Task");
        }
        List<DocumentModel> docs = this.routing.getWorkflowInputDocuments(this.session, task);
        if (docs.size() == 0) {
            throw new NuxeoException("Can not fetch the input documents in the related workflow instance");
        }
        if (docs.size() > 1) {
            log.warn((Object)"Using as mapping source only the first document in the input documents in the workflow");
        }
        this.mappingService.mapProperties(this.session, docs.get(0), taskDoc, this.mappingName);
        return taskDoc;
    }
}

