/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobDispatcher;
import org.nuxeo.ecm.core.blob.BlobDispatcherDescriptor;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.DefaultBlobDispatcher;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.blob.DocumentBlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentBlobManagerComponent
extends DefaultComponent
implements DocumentBlobManager {
    private static final Log log = LogFactory.getLog(DocumentBlobManagerComponent.class);
    protected static final String XP = "configuration";
    protected static BlobDispatcher DEFAULT_BLOB_DISPATCHER = new DefaultBlobDispatcher();
    protected Deque<BlobDispatcherDescriptor> blobDispatcherDescriptorsRegistry = new LinkedList<BlobDispatcherDescriptor>();

    public void deactivate(ComponentContext context) {
        this.blobDispatcherDescriptorsRegistry.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint)) {
            if (!(contribution instanceof BlobDispatcherDescriptor)) {
                throw new NuxeoException("Invalid descriptor: " + contribution.getClass());
            }
        } else {
            throw new NuxeoException("Invalid extension point: " + extensionPoint);
        }
        this.registerBlobDispatcher((BlobDispatcherDescriptor)contribution);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint) && contribution instanceof BlobDispatcherDescriptor) {
            this.unregisterBlobDispatcher((BlobDispatcherDescriptor)contribution);
        }
    }

    protected void registerBlobDispatcher(BlobDispatcherDescriptor descr) {
        this.blobDispatcherDescriptorsRegistry.add(descr);
    }

    protected void unregisterBlobDispatcher(BlobDispatcherDescriptor descr) {
        this.blobDispatcherDescriptorsRegistry.remove(descr);
    }

    protected BlobDispatcher getBlobDispatcher() {
        BlobDispatcherDescriptor descr = this.blobDispatcherDescriptorsRegistry.peekLast();
        if (descr == null) {
            return DEFAULT_BLOB_DISPATCHER;
        }
        return descr.getBlobDispatcher();
    }

    protected BlobProvider getBlobProvider(String providerId) {
        return ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(providerId);
    }

    protected DocumentBlobProvider getDocumentBlobProvider(Blob blob) {
        BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blob);
        if (blobProvider instanceof DocumentBlobProvider) {
            return (DocumentBlobProvider)blobProvider;
        }
        return null;
    }

    @Override
    public Blob readBlob(BlobInfo blobInfo, String repositoryName) throws IOException {
        String key = blobInfo.key;
        if (key == null) {
            return null;
        }
        BlobProvider blobProvider = this.getBlobProvider(key, repositoryName);
        if (blobProvider == null) {
            throw new NuxeoException("No registered blob provider for key: " + key);
        }
        return blobProvider.readBlob(blobInfo);
    }

    protected BlobProvider getBlobProvider(String key, String repositoryName) {
        int colon = key.indexOf(58);
        String providerId = colon < 0 ? this.getBlobDispatcher().getBlobProvider(repositoryName) : key.substring(0, colon);
        return this.getBlobProvider(providerId);
    }

    @Override
    public String writeBlob(Blob blob, Document doc, String xpath) throws IOException {
        BlobProvider blobProvider;
        ManagedBlob managedBlob;
        String currentProviderId;
        BlobDispatcher blobDispatcher = this.getBlobDispatcher();
        BlobDispatcher.BlobDispatch dispatch = null;
        if (blob instanceof ManagedBlob && !this.getBlobProvider(currentProviderId = (managedBlob = (ManagedBlob)blob).getProviderId()).isTransient()) {
            if (!blobDispatcher.getBlobProviderIds().contains(currentProviderId)) {
                return managedBlob.getKey();
            }
            dispatch = blobDispatcher.getBlobProvider(doc, blob, xpath);
            if (dispatch.providerId.equals(currentProviderId)) {
                return managedBlob.getKey();
            }
        }
        if (dispatch == null) {
            dispatch = blobDispatcher.getBlobProvider(doc, blob, xpath);
        }
        if ((blobProvider = this.getBlobProvider(dispatch.providerId)) == null) {
            throw new NuxeoException("No registered blob provider with id: " + dispatch.providerId);
        }
        Object key = blobProvider.writeBlob(blob);
        if (dispatch.addPrefix) {
            key = dispatch.providerId + ":" + (String)key;
        }
        return key;
    }

    @Override
    public InputStream getConvertedStream(Blob blob, String mimeType, DocumentModel doc) throws IOException {
        DocumentBlobProvider blobProvider = this.getDocumentBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getConvertedStream((ManagedBlob)blob, mimeType, doc);
    }

    protected void freezeVersion(Document.BlobAccessor accessor, Document doc) {
        Blob blob = accessor.getBlob();
        DocumentBlobProvider blobProvider = this.getDocumentBlobProvider(blob);
        if (blobProvider == null) {
            return;
        }
        try {
            ManagedBlob newBlob = blobProvider.freezeVersion((ManagedBlob)blob, doc);
            if (newBlob != null) {
                accessor.setBlob((Blob)newBlob);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void freezeVersion(Document doc) {
        doc.visitBlobs(accessor -> this.freezeVersion((Document.BlobAccessor)accessor, doc));
    }

    @Override
    public void notifyChanges(Document doc, Set<String> xpaths) {
        this.getBlobDispatcher().notifyChanges(doc, xpaths);
    }

    protected List<BinaryGarbageCollector> getGarbageCollectors() {
        LinkedList<BinaryGarbageCollector> gcs = new LinkedList<BinaryGarbageCollector>();
        for (String providerId : this.getBlobDispatcher().getBlobProviderIds()) {
            BlobProvider blobProvider = this.getBlobProvider(providerId);
            BinaryManager binaryManager = blobProvider.getBinaryManager();
            if (binaryManager == null) continue;
            gcs.add(binaryManager.getGarbageCollector());
        }
        return gcs;
    }

    @Override
    public BinaryManagerStatus garbageCollectBinaries(boolean delete) {
        List<BinaryGarbageCollector> gcs = this.getGarbageCollectors();
        long start = System.currentTimeMillis();
        for (BinaryGarbageCollector binaryGarbageCollector : gcs) {
            binaryGarbageCollector.start();
        }
        RepositoryService repositoryService = (RepositoryService)((Object)Framework.getService(RepositoryService.class));
        for (String repositoryName : repositoryService.getRepositoryNames()) {
            Repository repository = repositoryService.getRepository(repositoryName);
            repository.markReferencedBinaries();
        }
        BinaryManagerStatus binaryManagerStatus = new BinaryManagerStatus();
        for (BinaryGarbageCollector gc : gcs) {
            gc.stop(delete);
            BinaryManagerStatus status = gc.getStatus();
            binaryManagerStatus.numBinaries += status.numBinaries;
            binaryManagerStatus.sizeBinaries += status.sizeBinaries;
            binaryManagerStatus.numBinariesGC += status.numBinariesGC;
            binaryManagerStatus.sizeBinariesGC += status.sizeBinariesGC;
        }
        binaryManagerStatus.gcDuration = System.currentTimeMillis() - start;
        return binaryManagerStatus;
    }

    @Override
    public void markReferencedBinary(String key, String repositoryName) {
        BlobProvider blobProvider = this.getBlobProvider(key, repositoryName);
        BinaryManager binaryManager = blobProvider.getBinaryManager();
        if (binaryManager != null) {
            int colon = key.indexOf(58);
            if (colon > 0) {
                key = key.substring(colon + 1);
            }
            binaryManager.getGarbageCollector().mark(key);
        } else {
            log.error((Object)("Unknown binary manager for key: " + key));
        }
    }

    @Override
    public boolean isBinariesGarbageCollectionInProgress() {
        for (BinaryGarbageCollector gc : this.getGarbageCollectors()) {
            if (!gc.isInProgress()) continue;
            return true;
        }
        return false;
    }
}

