/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.constraints;

import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public interface Constraint
extends Serializable {
    public static final String MESSAGES_BUNDLE = "messages";
    public static final Locale MESSAGES_DEFAULT_LANG = Locale.ENGLISH;
    public static final String MESSAGES_KEY = "label.schema.constraint.violation";

    public boolean validate(Object var1);

    public String getErrorMessage(Object var1, Locale var2);

    public Description getDescription();

    public static class Description {
        private String name;
        private Map<String, Serializable> parameters;

        public Description(String name, Map<String, Serializable> parameters) {
            this.name = name;
            this.parameters = parameters;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Serializable> getParameters() {
            return Collections.unmodifiableMap(this.parameters);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Description other = (Description)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.name);
            builder.append(this.parameters.toString());
            return builder.toString();
        }
    }
}

