/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb;

import com.novemberain.quartz.mongodb.dao.JobDao;
import com.novemberain.quartz.mongodb.dao.TriggerDao;
import com.novemberain.quartz.mongodb.trigger.TriggerConverter;
import com.novemberain.quartz.mongodb.util.Keys;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerAndJobPersister {
    private static final Logger log = LoggerFactory.getLogger(TriggerAndJobPersister.class);
    private final TriggerDao triggerDao;
    private final JobDao jobDao;
    private TriggerConverter triggerConverter;

    public TriggerAndJobPersister(TriggerDao triggerDao, JobDao jobDao, TriggerConverter triggerConverter) {
        this.triggerDao = triggerDao;
        this.jobDao = jobDao;
        this.triggerConverter = triggerConverter;
    }

    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) throws JobPersistenceException {
        Document doc = this.jobDao.getJob(jobKey);
        return this.triggerDao.getTriggersForJob(doc);
    }

    public boolean removeJob(JobKey jobKey) {
        Bson keyObject = Keys.toFilter(jobKey);
        Document item = this.jobDao.getJob(keyObject);
        if (item != null) {
            this.jobDao.remove(keyObject);
            this.triggerDao.removeByJobId(item.get((Object)"_id"));
            return true;
        }
        return false;
    }

    public boolean removeJobs(List<JobKey> jobKeys) throws JobPersistenceException {
        for (JobKey key : jobKeys) {
            this.removeJob(key);
        }
        return false;
    }

    public boolean removeTrigger(TriggerKey triggerKey) {
        Bson filter = Keys.toFilter(triggerKey);
        Document trigger = this.triggerDao.findTrigger(filter);
        if (trigger != null) {
            this.removeOrphanedJob(trigger);
            this.triggerDao.remove(filter);
            return true;
        }
        return false;
    }

    public boolean removeTriggers(List<TriggerKey> triggerKeys) throws JobPersistenceException {
        for (TriggerKey key : triggerKeys) {
            this.removeTrigger(key);
        }
        return false;
    }

    public boolean removeTriggerWithoutNextFireTime(OperableTrigger trigger) {
        if (trigger.getNextFireTime() == null) {
            log.info("Removing trigger {} as it has no next fire time.", (Object)trigger.getKey());
            this.removeTrigger(trigger.getKey());
            return true;
        }
        return false;
    }

    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger newTrigger) throws JobPersistenceException {
        OperableTrigger oldTrigger = this.triggerDao.getTrigger(triggerKey);
        if (oldTrigger == null) {
            return false;
        }
        if (!oldTrigger.getJobKey().equals((Object)newTrigger.getJobKey())) {
            throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
        }
        this.removeOldTrigger(triggerKey);
        this.copyOldJobDataMap(newTrigger, oldTrigger);
        this.storeNewTrigger(newTrigger, oldTrigger);
        return true;
    }

    public void storeJobAndTrigger(JobDetail newJob, OperableTrigger newTrigger) throws JobPersistenceException {
        ObjectId jobId = this.jobDao.storeJobInMongo(newJob, false);
        log.debug("Storing job {} and trigger {}", (Object)newJob.getKey(), (Object)newTrigger.getKey());
        this.storeTrigger(newTrigger, jobId, false);
    }

    public void storeTrigger(OperableTrigger newTrigger, boolean replaceExisting) throws JobPersistenceException {
        if (newTrigger.getJobKey() == null) {
            throw new JobPersistenceException("Trigger must be associated with a job. Please specify a JobKey.");
        }
        Document doc = this.jobDao.getJob(Keys.toFilter(newTrigger.getJobKey()));
        if (doc == null) {
            throw new JobPersistenceException("Could not find job with key " + newTrigger.getJobKey());
        }
        this.storeTrigger(newTrigger, doc.getObjectId((Object)"_id"), replaceExisting);
    }

    private void copyOldJobDataMap(OperableTrigger newTrigger, OperableTrigger trigger) {
        newTrigger.getJobDataMap().putAll((Map)trigger.getJobDataMap());
    }

    private boolean isNotDurable(Document job) {
        return !job.containsKey((Object)"durability") || job.get((Object)"durability").toString().equals("false");
    }

    private boolean isOrphan(Document job) {
        return job != null && this.isNotDurable(job) && this.triggerDao.hasLastTrigger(job);
    }

    private void removeOldTrigger(TriggerKey triggerKey) {
        this.triggerDao.remove(triggerKey);
    }

    private void removeOrphanedJob(Document trigger) {
        if (trigger.containsKey((Object)"jobId")) {
            Document job = this.jobDao.getById(trigger.get((Object)"jobId"));
            if (this.isOrphan(job)) {
                this.jobDao.remove((Bson)job);
            }
        } else {
            log.debug("The trigger had no associated jobs");
        }
    }

    private void storeNewTrigger(OperableTrigger newTrigger, OperableTrigger oldTrigger) throws JobPersistenceException {
        try {
            this.storeTrigger(newTrigger, false);
        }
        catch (JobPersistenceException jpe) {
            this.storeTrigger(oldTrigger, false);
            throw jpe;
        }
    }

    private void storeTrigger(OperableTrigger newTrigger, ObjectId jobId, boolean replaceExisting) throws JobPersistenceException {
        Document trigger = this.triggerConverter.toDocument(newTrigger, jobId);
        if (replaceExisting) {
            trigger.remove((Object)"_id");
            this.triggerDao.replace(newTrigger.getKey(), trigger);
        } else {
            this.triggerDao.insert(trigger, (Trigger)newTrigger);
        }
    }
}

