/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.pdf.PDFUtils;
import org.nuxeo.runtime.api.Framework;

public class PDFPageNumbering {
    public static final float DEFAULT_FONT_SIZE = 16.0f;
    private Blob blob;
    private String password;

    public PDFPageNumbering(Blob inBlob) {
        this.blob = inBlob;
    }

    public PDFPageNumbering(DocumentModel inDoc, String inXPath) {
        if (StringUtils.isBlank((CharSequence)inXPath)) {
            inXPath = "file:content";
        }
        this.blob = (Blob)inDoc.getPropertyValue(inXPath);
    }

    public Blob addPageNumbers(int inStartAtPage, int inStartAtNumber, String inFontName, float inFontSize, String inHex255Color, PAGE_NUMBER_POSITION inPosition) throws NuxeoException {
        FileBlob result;
        inStartAtPage = inStartAtPage < 1 ? 1 : inStartAtPage;
        int pageNumber = inStartAtNumber < 1 ? 1 : inStartAtNumber;
        inFontSize = inFontSize <= 0.0f ? 16.0f : inFontSize;
        int[] rgb = PDFUtils.hex255ToRGB(inHex255Color);
        try (PDDocument doc = PDFUtils.load(this.blob, this.password);){
            PDType1Font font;
            if (StringUtils.isBlank((CharSequence)inFontName)) {
                font = PDType1Font.HELVETICA;
            } else {
                font = PDType1Font.getStandardFont((String)inFontName);
                if (font == null) {
                    font = new PDType1Font(inFontName);
                }
            }
            List allPages = doc.getDocumentCatalog().getAllPages();
            int max = allPages.size();
            for (int i = inStartAtPage = inStartAtPage > max ? 1 : inStartAtPage; i <= max; ++i) {
                float yMoveAmount;
                float xMoveAmount;
                String pageNumAsStr = Integer.toString(pageNumber);
                ++pageNumber;
                PDPage page = (PDPage)allPages.get(i - 1);
                PDPageContentStream footercontentStream = new PDPageContentStream(doc, page, true, true);
                float stringWidth = font.getStringWidth(pageNumAsStr) * inFontSize / 1000.0f;
                float stringHeight = font.getFontDescriptor().getFontBoundingBox().getHeight() * inFontSize / 1000.0f;
                PDRectangle pageRect = page.findMediaBox();
                if (inPosition == null) {
                    inPosition = PAGE_NUMBER_POSITION.BOTTOM_RIGHT;
                }
                switch (inPosition) {
                    case BOTTOM_LEFT: {
                        xMoveAmount = 10.0f;
                        yMoveAmount = pageRect.getLowerLeftY() + 10.0f;
                        break;
                    }
                    case BOTTOM_CENTER: {
                        xMoveAmount = pageRect.getUpperRightX() / 2.0f - stringWidth / 2.0f;
                        yMoveAmount = pageRect.getLowerLeftY() + 10.0f;
                        break;
                    }
                    case TOP_LEFT: {
                        xMoveAmount = 10.0f;
                        yMoveAmount = pageRect.getHeight() - stringHeight - 10.0f;
                        break;
                    }
                    case TOP_CENTER: {
                        xMoveAmount = pageRect.getUpperRightX() / 2.0f - stringWidth / 2.0f;
                        yMoveAmount = pageRect.getHeight() - stringHeight - 10.0f;
                        break;
                    }
                    case TOP_RIGHT: {
                        xMoveAmount = pageRect.getUpperRightX() - 10.0f - stringWidth;
                        yMoveAmount = pageRect.getHeight() - stringHeight - 10.0f;
                        break;
                    }
                    default: {
                        xMoveAmount = pageRect.getUpperRightX() - 10.0f - stringWidth;
                        yMoveAmount = pageRect.getLowerLeftY() + 10.0f;
                    }
                }
                footercontentStream.beginText();
                footercontentStream.setFont((PDFont)font, inFontSize);
                footercontentStream.moveTextPositionByAmount(xMoveAmount, yMoveAmount);
                footercontentStream.setNonStrokingColor(rgb[0], rgb[1], rgb[2]);
                footercontentStream.drawString(pageNumAsStr);
                footercontentStream.endText();
                footercontentStream.close();
            }
            File tempFile = File.createTempFile("pdfutils-", ".pdf");
            doc.save(tempFile);
            result = new FileBlob(tempFile);
            Framework.trackFile((File)tempFile, (Object)result);
        }
        catch (IOException | COSVisitorException e) {
            throw new NuxeoException("Failed to handle the pdf", e);
        }
        return result;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static enum PAGE_NUMBER_POSITION {
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT,
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT;

    }
}

