/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;

public class PDFUtils {
    public static final String DEFAULT_BLOB_XPATH = "file:content";

    public static int[] hex255ToRGB(String inHex) {
        int[] result = new int[]{0, 0, 0};
        if (inHex != null && (inHex = inHex.toLowerCase().replace("#", "").replace("0x", "")).length() >= 6) {
            for (int i = 0; i < 3; ++i) {
                result[i] = Integer.parseInt(inHex.substring(i * 2, i * 2 + 2), 16);
            }
        }
        return result;
    }

    public static PDDocument load(Blob inBlob, String inPwd) throws NuxeoException {
        PDDocument pdfDoc;
        try {
            pdfDoc = PDDocument.load((InputStream)inBlob.getStream());
            if (pdfDoc.isEncrypted()) {
                pdfDoc.openProtection((DecryptionMaterial)new StandardDecryptionMaterial(inPwd));
            }
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to load the PDF", (Throwable)e);
        }
        catch (CryptographyException | BadSecurityHandlerException e) {
            throw new NuxeoException("Failed to decrypt the PDF", e);
        }
        return pdfDoc;
    }

    public static FileBlob saveInTempFile(PDDocument inPdfDoc) throws IOException, COSVisitorException {
        return PDFUtils.saveInTempFile(inPdfDoc, null);
    }

    public static FileBlob saveInTempFile(PDDocument inPdfDoc, String inFileName) throws IOException, COSVisitorException {
        Blob result = Blobs.createBlobWithExtension((String)".pdf");
        File resultFile = result.getFile();
        inPdfDoc.save(result.getFile());
        result.setMimeType("application/pdf");
        if (StringUtils.isNotBlank((CharSequence)inFileName)) {
            result.setFilename(inFileName);
        }
        FileBlob fb = new FileBlob(resultFile);
        fb.setMimeType("application/pdf");
        return fb;
    }

    public static void setInfos(PDDocument inPdfDoc, String inTitle, String inSubject, String inAuthor) {
        if (inTitle != null && inTitle.isEmpty()) {
            inTitle = null;
        }
        if (inSubject != null && inSubject.isEmpty()) {
            inSubject = null;
        }
        if (inAuthor != null && inAuthor.isEmpty()) {
            inAuthor = null;
        }
        if (inTitle != null || inAuthor != null || inSubject != null) {
            PDDocumentInformation docInfo = inPdfDoc.getDocumentInformation();
            if (inTitle != null) {
                docInfo.setTitle(inTitle);
            }
            if (inSubject != null) {
                docInfo.setSubject(inSubject);
            }
            if (inAuthor != null) {
                docInfo.setAuthor(inAuthor);
            }
            inPdfDoc.setDocumentInformation(docInfo);
        }
    }

    public static String checkXPath(String inXPath) {
        if (StringUtils.isBlank((CharSequence)inXPath)) {
            inXPath = DEFAULT_BLOB_XPATH;
        }
        return inXPath;
    }

    public static void closeSilently(PDDocument ... inPdfDocs) {
        for (PDDocument doc : inPdfDocs) {
            if (doc == null) continue;
            try {
                doc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

