/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import java.io.IOException;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.pdf.PDFMerge;

@Operation(id="PDF.MergeWithBlobs", category="Conversion", label="PDF: Merge with Blob(s) ", description="The input blob(s) always is(are) the first PDFs. The operation appends the blob referenced in the <code>toAppendVarName</code> Context variable. It then appends all the blobs stored in the <code>toAppendListVarName</code> Context variable. Returns the final PDF.")
public class PDFMergeBlobsOperation {
    public static final String ID = "PDF.MergeWithBlobs";
    @Context
    protected OperationContext ctx;
    @Param(name="toAppendVarName", required=false)
    protected String toAppendVarName = "";
    @Param(name="toAppendListVarName", required=false)
    protected String toAppendListVarName = "";
    @Param(name="fileName", required=false)
    protected String fileName = "";
    @Param(name="pdfTitle", required=false)
    protected String pdfTitle = "";
    @Param(name="pdfSubject", required=false)
    protected String pdfSubject = "";
    @Param(name="pdfAuthor", required=false)
    protected String pdfAuthor = "";

    @OperationMethod
    public Blob run(Blob inBlob) throws NuxeoException {
        PDFMerge pdfm = new PDFMerge(inBlob);
        return this.doMerge(pdfm);
    }

    @OperationMethod
    public Blob run(BlobList inBlobs) throws NuxeoException {
        PDFMerge pdfm = new PDFMerge((Blob)inBlobs.get(0));
        int max = inBlobs.size();
        for (int i = 1; i < max; ++i) {
            pdfm.addBlob((Blob)inBlobs.get(i));
        }
        return this.doMerge(pdfm);
    }

    protected Blob doMerge(PDFMerge inMergeTool) throws NuxeoException {
        if (this.toAppendVarName != null && !this.toAppendVarName.isEmpty()) {
            inMergeTool.addBlob((Blob)this.ctx.get((Object)this.toAppendVarName));
        }
        if (this.toAppendListVarName != null && !this.toAppendListVarName.isEmpty()) {
            if (this.ctx.get((Object)this.toAppendListVarName) instanceof BlobList) {
                inMergeTool.addBlobs((BlobList)this.ctx.get((Object)this.toAppendListVarName));
            } else {
                throw new NuxeoException(this.ctx.get((Object)this.toAppendListVarName).getClass() + " is not a Collection");
            }
        }
        try {
            return inMergeTool.merge(this.fileName, this.pdfTitle, this.pdfSubject, this.pdfAuthor);
        }
        catch (IOException | COSVisitorException e) {
            throw new NuxeoException(e);
        }
    }
}

