/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.impl.OperationChainCompiler;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.runtime.api.Framework;

public class ChainTypeImpl
implements OperationType {
    protected final OperationChain chain;
    protected AutomationService service;
    protected InvokableMethod[] methods = new InvokableMethod[]{new InvokableMethod(this, runMethod)};
    protected String contributingComponent;
    protected OperationChainContribution contribution;
    protected static final Method runMethod = ChainTypeImpl.loadRunMethod();

    public ChainTypeImpl(AutomationService service, OperationChain chain, OperationChainContribution contribution) {
        this.service = service;
        this.contribution = contribution;
        this.chain = chain;
    }

    public OperationChain getChain() {
        return this.chain;
    }

    public Map<String, Object> getChainParameters() {
        return this.chain.getChainParameters();
    }

    @Override
    public Object newInstance(OperationContext ctx, Map<String, Object> args) throws OperationException {
        Object input = ctx.getInput();
        Class<Void> inputType = input == null ? Void.TYPE : input.getClass();
        return this.service.compileChain(inputType, this.chain);
    }

    @Override
    public AutomationService getService() {
        return this.service;
    }

    @Override
    public String getId() {
        return this.chain.getId();
    }

    @Override
    public String[] getAliases() {
        return this.chain.getAliases();
    }

    @Override
    public Class<?> getType() {
        return OperationChainCompiler.CompiledChainImpl.class;
    }

    @Override
    public OperationDocumentation getDocumentation() throws OperationException {
        OperationDocumentation doc = new OperationDocumentation(this.chain.getId());
        doc.label = this.chain.getId();
        doc.requires = this.contribution.getRequires();
        doc.category = this.contribution.getCategory();
        doc.setAliases(this.contribution.getAliases());
        OperationChainContribution.Operation[] operations = this.contribution.getOps();
        doc.operations = operations;
        doc.since = this.contribution.getSince();
        if (doc.requires.length() == 0) {
            doc.requires = null;
        }
        if (doc.label.length() == 0) {
            doc.label = doc.id;
        }
        doc.description = this.contribution.getDescription();
        doc.params = this.contribution.getParams();
        if (operations.length != 0) {
            ArrayList<String> result = this.getSignature(operations);
            doc.signature = result.toArray(new String[result.size()]);
        } else {
            doc.signature = new String[]{"void", "void"};
        }
        return doc;
    }

    protected ArrayList<String> getSignature(OperationChainContribution.Operation[] operations) throws OperationException {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<CallSite> collectedSigs = new HashSet<CallSite>();
        OperationType operationType = this.service.getOperation(operations[0].getId());
        for (InvokableMethod method : operationType.getMethods()) {
            String chainInput = this.getParamDocumentationType(method.getInputType(), method.isIterable());
            String chainOutput = this.getParamDocumentationType(this.getChainOutput(method.getInputType(), operations));
            String sigKey = chainInput + ":" + method.getInputType();
            if (collectedSigs.contains(sigKey)) continue;
            result.add(chainInput);
            result.add(chainOutput);
            collectedSigs.add((CallSite)((Object)sigKey));
        }
        return result;
    }

    protected Class<?> getChainOutput(Class<?> chainInput, OperationChainContribution.Operation[] operations) throws OperationException {
        for (OperationChainContribution.Operation operation : operations) {
            OperationType operationType = this.service.getOperation(operation.getId());
            chainInput = operationType instanceof ChainTypeImpl ? this.getChainOutput(chainInput, operationType.getDocumentation().getOperations()) : this.getOperationOutput(chainInput, operationType);
        }
        return chainInput;
    }

    public Class<?> getOperationOutput(Class<?> input, OperationType operationType) {
        InvokableMethod[] methodsMatchingInput = operationType.getMethodsMatchingInput(input);
        if (methodsMatchingInput.length == 0) {
            return input;
        }
        InvokableMethod topMethod = this.getTopMethod(methodsMatchingInput);
        Class<?> nextInput = topMethod.getOutputType();
        if (nextInput == Void.TYPE) {
            return input;
        }
        return nextInput;
    }

    protected InvokableMethod getTopMethod(InvokableMethod[] methods) {
        InvokableMethod topMethod = methods[0];
        for (InvokableMethod method : methods) {
            if (method.getPriority() <= topMethod.getPriority()) continue;
            topMethod = method;
        }
        return topMethod;
    }

    @Override
    public String getContributingComponent() {
        return this.contributingComponent;
    }

    @Override
    public InvokableMethod[] getMethodsMatchingInput(Class<?> in) {
        return this.methods;
    }

    protected static Method loadRunMethod() {
        try {
            return OperationChainCompiler.CompiledChainImpl.class.getMethod("invoke", OperationContext.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new UnsupportedOperationException("Cannot use reflection for run method", e);
        }
    }

    protected String getParamDocumentationType(Class<?> type) {
        return this.getParamDocumentationType(type, false);
    }

    protected String getParamDocumentationType(Class<?> type, boolean isIterable) {
        String t = DocumentModel.class.isAssignableFrom(type) || DocumentRef.class.isAssignableFrom(type) ? (isIterable ? "documents" : "document") : (DocumentModelList.class.isAssignableFrom(type) || DocumentRefList.class.isAssignableFrom(type) ? "documents" : (BlobList.class.isAssignableFrom(type) ? "bloblist" : (Blob.class.isAssignableFrom(type) ? (isIterable ? "bloblist" : "blob") : (URL.class.isAssignableFrom(type) ? "resource" : (Calendar.class.isAssignableFrom(type) ? "date" : type.getSimpleName().toLowerCase())))));
        return t;
    }

    public String toString() {
        return "ChainTypeImpl [id=" + this.chain.getId() + "]";
    }

    public OperationChainContribution getContribution() {
        return this.contribution;
    }

    @Override
    public List<InvokableMethod> getMethods() {
        return Arrays.asList(this.methods);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chain == null ? 0 : this.chain.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChainTypeImpl)) {
            return false;
        }
        ChainTypeImpl other = (ChainTypeImpl)obj;
        return !(this.chain == null ? other.chain != null : !this.chain.equals(other.chain));
    }

    public static ChainTypeImpl typeof(OperationChain chain, boolean replace) {
        return new ChainTypeImpl((AutomationService)Framework.getService(AutomationService.class), chain, OperationChainContribution.contribOf(chain, replace));
    }
}

