/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Watermark;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.internals.LogPartitionGroup;

public class LatencyTrackerComputation
extends AbstractComputation {
    private static final Log log = LogFactory.getLog(LatencyTrackerComputation.class);
    protected static final String OUTPUT_STREAM = "o1";
    protected final LogManager manager;
    protected final List<String> logNames;
    protected final int intervalMs;
    protected final int count;
    protected final boolean verbose;
    protected final Codec<Record> codec;
    protected int remaining;
    protected final List<LogPartitionGroup> logGroups = new ArrayList<LogPartitionGroup>();
    protected int refreshGroupCounter;

    public LatencyTrackerComputation(LogManager manager, List<String> logNames, String computationName, int intervalSecond, int count, boolean verbose, Codec<Record> codec, int outputStream) {
        super(computationName, 1, outputStream);
        this.manager = manager;
        this.logNames = logNames;
        this.intervalMs = 1000 * intervalSecond;
        this.count = count;
        this.remaining = count;
        this.verbose = verbose;
        this.codec = codec;
    }

    @Override
    public void init(ComputationContext context) {
        log.info((Object)String.format("Tracking %d streams: %s, count: %d, interval: %dms", this.logNames.size(), Arrays.toString(this.logNames.toArray()), this.count, this.intervalMs));
        context.setTimer("tracker", System.currentTimeMillis() + (long)this.intervalMs);
    }

    @Override
    public void processTimer(ComputationContext context, String key, long timestamp) {
        if (this.remaining == 0) {
            if (this.verbose) {
                log.info((Object)("Exiting after " + this.count + " captures"));
            }
            context.askForTermination();
            return;
        }
        if (this.verbose) {
            log.info((Object)String.format("Tracking latency %d/%d", this.count - this.remaining, this.count));
        }
        ArrayList<LogPartitionGroup> toRemove = new ArrayList<LogPartitionGroup>();
        for (LogPartitionGroup logGroup : this.getLogGroup()) {
            try {
                List<Latency> latencies = this.manager.getLatencyPerPartition(logGroup.name, logGroup.group, this.codec, rec -> Watermark.ofValue(rec.getWatermark()).getTimestamp(), Record::getKey);
                if (latencies.isEmpty()) continue;
                this.processLatencies(context, logGroup, latencies);
            }
            catch (Exception e) {
                if (e.getCause() instanceof ClassNotFoundException || e.getCause() instanceof ClassCastException || e instanceof IllegalStateException || e instanceof IllegalArgumentException) {
                    log.warn((Object)("log does not contains computation Record, removing partition: " + logGroup));
                    toRemove.add(logGroup);
                    continue;
                }
                throw e;
            }
        }
        context.askForCheckpoint();
        context.setTimer("tracker", System.currentTimeMillis() + (long)this.intervalMs);
        --this.remaining;
        if (!toRemove.isEmpty()) {
            this.logGroups.removeAll(toRemove);
            if (this.logGroups.isEmpty()) {
                log.error((Object)"Exiting because all logs have been skipped");
                context.askForTermination();
            }
        }
    }

    protected List<LogPartitionGroup> getLogGroup() {
        if (this.logGroups.isEmpty() || this.refreshGroup()) {
            this.logGroups.clear();
            this.logNames.forEach(name -> {
                for (String group : this.manager.listConsumerGroups((String)name)) {
                    this.logGroups.add(new LogPartitionGroup(group, (String)name, 0));
                }
            });
            if (this.verbose) {
                log.info((Object)("Update list of consumers: " + Arrays.toString(this.logGroups.toArray())));
            }
        }
        return this.logGroups;
    }

    protected boolean refreshGroup() {
        ++this.refreshGroupCounter;
        return this.refreshGroupCounter % 5 == 0;
    }

    protected void processLatencies(ComputationContext context, LogPartitionGroup logGroup, List<Latency> latencies) {
        for (int partition = 0; partition < latencies.size(); ++partition) {
            Latency latency = latencies.get(partition);
            if (latency.lower() <= 0L) continue;
            long recordWatermark = Watermark.ofTimestamp(latency.upper()).getValue();
            String recordKey = LatencyTrackerComputation.encodeKey(logGroup, partition);
            byte[] recordValue = this.encodeLatency(latency);
            Record record = new Record(recordKey, recordValue, recordWatermark);
            if (this.verbose) {
                log.info((Object)("out: " + record));
            }
            context.produceRecord(OUTPUT_STREAM, record);
            context.setSourceLowWatermark(recordWatermark);
        }
    }

    protected byte[] encodeLatency(Latency latency) {
        return latency.asJson().getBytes(StandardCharsets.UTF_8);
    }

    public static String encodeKey(LogPartitionGroup logGroup, int partition) {
        return String.format("%s:%s:%s", logGroup.group, logGroup.name, partition);
    }

    public static LogPartitionGroup decodeKey(String key) {
        String[] parts = key.split(":");
        return new LogPartitionGroup(parts[0], parts[1], Integer.parseInt(parts[2]));
    }

    @Override
    public void destroy() {
        log.info((Object)"Good bye");
    }

    @Override
    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        log.error((Object)("Receiving a record is not expected: " + record));
    }
}

