/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.message;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.CustomEncoding;

public class MapAsJsonAsStringEncoding
extends CustomEncoding<Map<String, Serializable>> {
    protected static final int NULL_SCHEMA_INDEX = 0;
    protected static final int STRING_SCHEMA_INDEX = 1;
    protected static final ObjectMapper MAPPER = new ObjectMapper();

    public MapAsJsonAsStringEncoding() {
        List<Schema> union = Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING));
        union.get(1).addProp("CustomEncoding", "MapAsJsonAsStringEncoding");
        this.schema = Schema.createUnion(union);
    }

    protected void write(Object o, Encoder encoder) throws IOException {
        if (o == null || ((Map)o).isEmpty()) {
            encoder.writeIndex(0);
            encoder.writeNull();
        } else {
            encoder.writeIndex(1);
            String mapAsJson = MAPPER.writeValueAsString(o);
            encoder.writeString(mapAsJson);
        }
    }

    protected Map<String, Serializable> read(Object o, Decoder decoder) throws IOException {
        int index = decoder.readIndex();
        if (index == 0) {
            decoder.readNull();
            return Collections.emptyMap();
        }
        if (index == 1) {
            String mapAsJson = decoder.readString();
            return (Map)new ObjectMapper().readValue(mapAsJson, Map.class);
        }
        throw new IOException("Unable to read Map as Json as String, index=" + index + " is unknown");
    }
}

