/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scroll;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.nuxeo.ecm.core.api.scroll.Scroll;
import org.nuxeo.ecm.core.api.scroll.ScrollRequest;
import org.nuxeo.ecm.core.scroll.StaticScrollRequest;

public class StaticScroll
implements Scroll {
    protected StaticScrollRequest request;
    protected List<List<String>> partitions;
    protected int currentPosition;
    protected int nextPosition;

    public void init(ScrollRequest request, Map<String, String> options) {
        if (!(request instanceof StaticScrollRequest)) {
            throw new IllegalArgumentException("Requires a StaticScrollRequest");
        }
        this.request = (StaticScrollRequest)request;
        this.partitions = Lists.partition(this.request.getIdentifiers(), (int)request.getSize());
        this.currentPosition = 0;
    }

    public boolean hasNext() {
        return this.currentPosition < this.partitions.size();
    }

    public List<String> next() {
        if (this.currentPosition >= this.partitions.size()) {
            throw new NoSuchElementException();
        }
        return this.partitions.get(this.currentPosition++);
    }

    public void close() {
        this.partitions = null;
    }

    public String toString() {
        return "StaticScroll request: " + this.request + " currentPos: " + this.currentPosition + " nextPos: " + this.nextPosition + " ids: " + this.partitions;
    }
}

