/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.model.Descriptor;

@XObject(value="queue")
public class WorkQueueDescriptor
implements Descriptor {
    public static final String ALL_QUEUES = "*";
    public static final int DEFAULT_MAX_THREADS = 4;
    public static final int DEFAULT_CLEAR_COMPLETED_AFTER_SECONDS = 600;
    public static final int DEFAULT_CAPACITY = -1;
    @XNode(value="@id")
    public String id;
    @XNode(value="@queueing")
    public Boolean queuing;
    @XNode(value="@processing")
    public Boolean processing;
    @XNode(value="name")
    public String name;
    @XNode(value="maxThreads")
    public Integer maxThreads;
    @XNodeList(value="category", type=HashSet.class, componentType=String.class)
    public Set<String> categories = Collections.emptySet();
    @XNode(value="capacity")
    public Integer capacity;

    public String getId() {
        return this.id;
    }

    public boolean isQueuingEnabled() {
        return !Boolean.FALSE.equals(this.queuing);
    }

    public boolean isProcessingEnabled() {
        return !Boolean.FALSE.equals(this.processing);
    }

    public int getMaxThreads() {
        return this.maxThreads == null ? 4 : this.maxThreads;
    }

    public int getCapacity() {
        return this.capacity == null ? -1 : this.capacity;
    }

    public Descriptor merge(Descriptor o) {
        WorkQueueDescriptor other = (WorkQueueDescriptor)o;
        WorkQueueDescriptor merged = new WorkQueueDescriptor();
        merged.id = this.id;
        merged.name = other.name != null ? other.name : this.name;
        merged.queuing = other.queuing != null ? other.queuing : this.queuing;
        merged.capacity = other.capacity != null ? other.capacity : this.capacity;
        merged.processing = other.processing != null ? other.processing : this.processing;
        merged.maxThreads = other.maxThreads != null ? other.maxThreads : this.maxThreads;
        merged.categories = new HashSet<String>(this.categories);
        merged.categories.addAll(other.categories);
        return merged;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(id=");
        sb.append(this.id);
        sb.append(" categories=");
        sb.append(this.categories);
        sb.append(" queuing=");
        sb.append(this.isQueuingEnabled());
        sb.append(" processing=");
        sb.append(this.isProcessingEnabled());
        sb.append(" maxThreads=");
        sb.append(this.getMaxThreads());
        sb.append(" capacity=");
        sb.append(this.getCapacity());
        sb.append(")");
        return sb.toString();
    }
}

