/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.time.Duration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryRegistry;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.localconfiguration.DirectoryConfiguration;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DirectoryServiceImpl
extends DefaultComponent
implements DirectoryService {
    public static final String CLUSTER_START_DURATION_PROP = "org.nuxeo.directory.cluster.start.duration";
    public static final Duration CLUSTER_START_DURATION_DEFAULT = Duration.ofMinutes(1L);
    protected static final String DELIMITER_BETWEEN_DIRECTORY_NAME_AND_SUFFIX = "_";
    private static final Logger log = LogManager.getLogger(DirectoryServiceImpl.class);
    protected DirectoryRegistry registry = new DirectoryRegistry();

    public void activate(ComponentContext context) {
    }

    public void deactivate(ComponentContext context) {
        this.registry.shutdown();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        DirectoryFactoryDescriptor factoryDescriptor = (DirectoryFactoryDescriptor)contribution;
        String factoryName = factoryDescriptor.getFactoryName();
        log.warn("No need to register factoryDescriptor anymore: {}", (Object)factoryName);
    }

    public void registerDirectoryDescriptor(BaseDirectoryDescriptor descriptor) {
        this.registry.addContribution(descriptor);
    }

    public void unregisterDirectoryDescriptor(BaseDirectoryDescriptor descriptor) {
        this.registry.removeContribution(descriptor);
    }

    public void loadFromCSV(String directoryName, Blob dataBlob, String dataLoadingPolicy) {
        if (StringUtils.isBlank((CharSequence)dataLoadingPolicy) || "never_load".equals(dataLoadingPolicy)) {
            throw new DirectoryException("Illegal dataLoadingPolicy: " + dataLoadingPolicy, 400);
        }
        Directory directory = this.getDirectoryOrFail(directoryName);
        directory.loadFromCSV(dataBlob, dataLoadingPolicy);
    }

    public int getApplicationStartedOrder() {
        return 97;
    }

    public void start(ComponentContext context) {
        ClusterService clusterService = (ClusterService)Framework.getService(ClusterService.class);
        String prop = Framework.getProperty((String)CLUSTER_START_DURATION_PROP);
        Duration duration = DurationUtils.parsePositive((String)prop, (Duration)CLUSTER_START_DURATION_DEFAULT);
        Duration pollDelay = Duration.ofSeconds(1L);
        clusterService.runAtomically("start-directories", duration, pollDelay, this::start);
    }

    protected void start() {
        List<Directory> directories = this.getDirectories();
        directories.forEach(Directory::initialize);
        directories.forEach(Directory::initializeReferences);
        directories.forEach(Directory::initializeInverseReferences);
    }

    protected DirectoryConfiguration getDirectoryConfiguration(DocumentModel documentContext) {
        LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
        if (localConfigurationService == null) {
            log.info("Local configuration not deployed, will use default configuration");
            return null;
        }
        return (DirectoryConfiguration)localConfigurationService.getConfiguration(DirectoryConfiguration.class, "DirectoryLocalConfiguration", documentContext);
    }

    protected String getWaitingLocalDirectoryName(String directoryName, DirectoryConfiguration configuration) {
        if (directoryName == null) {
            return null;
        }
        if (configuration != null && configuration.getDirectorySuffix() != null) {
            String suffix = configuration.getDirectorySuffix().trim();
            if (!"".equals(suffix)) {
                return directoryName + DELIMITER_BETWEEN_DIRECTORY_NAME_AND_SUFFIX + suffix;
            }
            log.warn("The local configuration detected is an empty value, we consider it as no configuration set.");
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DirectoryConfiguration)configuration).getDocumentRef();
            log.debug("Directory Local Configuration is on : {}", supplierArray);
        }
        return directoryName;
    }

    public BaseDirectoryDescriptor getDirectoryDescriptor(String id) {
        return this.registry.getDirectoryDescriptor(id);
    }

    public Directory getDirectory(String id) {
        if (id == null) {
            return null;
        }
        return this.registry.getDirectory(id);
    }

    public Directory getDirectory(String id, DocumentModel documentContext) {
        if (id == null) {
            return null;
        }
        String localDirectoryName = this.getWaitingLocalDirectoryName(id, this.getDirectoryConfiguration(documentContext));
        Directory dir = this.getDirectory(localDirectoryName);
        if (dir == null && !id.equals(localDirectoryName)) {
            log.debug("The local directory named '{}' was not found. Look for the default one named: {}", (Object)localDirectoryName, (Object)id);
            dir = this.getDirectory(id);
        }
        return dir;
    }

    protected Directory getDirectoryOrFail(String name) {
        return this.getDirectoryOrFail(name, null);
    }

    protected Directory getDirectoryOrFail(String id, DocumentModel documentContext) {
        Directory dir = this.getDirectory(id, documentContext);
        if (dir == null) {
            throw new DirectoryException("No directory registered with name: " + id);
        }
        return dir;
    }

    public List<Directory> getDirectories() {
        return this.registry.getDirectories();
    }

    public List<String> getDirectoryNames() {
        return this.registry.getDirectoryIds();
    }

    public String getDirectorySchema(String directoryName) {
        return this.getDirectoryOrFail(directoryName).getSchema();
    }

    public String getDirectoryIdField(String directoryName) {
        return this.getDirectoryOrFail(directoryName).getIdField();
    }

    public String getDirectoryPasswordField(String directoryName) {
        return this.getDirectoryOrFail(directoryName).getPasswordField();
    }

    public String getParentDirectoryName(String directoryName) {
        return this.getDirectoryOrFail(directoryName).getParentDirectory();
    }

    public Session open(String directoryName) {
        return this.getDirectoryOrFail(directoryName).getSession();
    }

    public Session open(String directoryName, DocumentModel documentContext) {
        return this.getDirectoryOrFail(directoryName, documentContext).getSession();
    }
}

