/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;

public class PasswordHelper {
    public static final String SSHA = "SSHA";
    public static final String SMD5 = "SMD5";
    private static final String HSSHA = "{SSHA}";
    private static final String HSMD5 = "{SMD5}";
    private static final String SHA1 = "SHA-1";
    private static final String MD5 = "MD5";
    private static final int SALT_LEN = 8;
    private static final Random random = new SecureRandom();

    private PasswordHelper() {
    }

    public static boolean isHashed(String password) {
        return password.startsWith(HSSHA) || password.startsWith(HSMD5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hashPassword(String password, String algorithm) {
        String prefix;
        String digestalg;
        if (algorithm == null || "".equals(algorithm)) {
            return password;
        }
        if (SSHA.equals(algorithm)) {
            digestalg = SHA1;
            prefix = HSSHA;
        } else if (SMD5.equals(algorithm)) {
            digestalg = MD5;
            prefix = HSMD5;
        } else {
            throw new RuntimeException("Unknown algorithm: " + algorithm);
        }
        byte[] salt = new byte[8];
        Random random = PasswordHelper.random;
        synchronized (random) {
            PasswordHelper.random.nextBytes(salt);
        }
        byte[] hash = PasswordHelper.digestWithSalt(password, salt, digestalg);
        byte[] bytes = new byte[hash.length + salt.length];
        System.arraycopy(hash, 0, bytes, 0, hash.length);
        System.arraycopy(salt, 0, bytes, hash.length, salt.length);
        return prefix + Base64.encodeBase64String((byte[])bytes);
    }

    public static boolean verifyPassword(String password, String hashedPassword) {
        byte[] bytes;
        int len;
        String digestalg;
        if (hashedPassword == null) {
            return false;
        }
        if (hashedPassword.startsWith(HSSHA)) {
            digestalg = SHA1;
            len = 20;
        } else if (hashedPassword.startsWith(HSMD5)) {
            digestalg = MD5;
            len = 16;
        } else {
            return hashedPassword.equals(password);
        }
        String digest = hashedPassword.substring(6);
        try {
            bytes = Base64.decodeBase64((String)digest);
        }
        catch (IllegalArgumentException e) {
            bytes = null;
        }
        if (bytes == null) {
            return false;
        }
        if (bytes.length < len + 2) {
            return false;
        }
        byte[] hash = new byte[len];
        byte[] salt = new byte[bytes.length - len];
        System.arraycopy(bytes, 0, hash, 0, hash.length);
        System.arraycopy(bytes, hash.length, salt, 0, salt.length);
        return MessageDigest.isEqual(hash, PasswordHelper.digestWithSalt(password, salt, digestalg));
    }

    public static byte[] digestWithSalt(String password, byte[] salt, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            if (password == null) {
                password = "";
            }
            md.update(password.getBytes("UTF-8"));
            md.update(salt);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(algorithm, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

