/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.memory;

import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.memory.MapExpressionEvaluator;
import org.nuxeo.runtime.api.Framework;

public class MemoryDirectoryExpressionEvaluator
extends MapExpressionEvaluator {
    protected final String directoryName;
    protected final Schema schema;

    public MemoryDirectoryExpressionEvaluator(Directory directory) {
        this.directoryName = directory.getName();
        this.schema = ((SchemaManager)Framework.getService(SchemaManager.class)).getSchema(directory.getSchema());
    }

    @Override
    protected QueryParseException unknownProperty(String name) {
        return new QueryParseException("No column: " + name + " for directory: " + this.directoryName);
    }

    @Override
    public Object walkReference(Reference ref) {
        if (ref.cast != null) {
            throw new QueryParseException("Cannot use cast: " + ref);
        }
        String name = ref.name;
        Field field = this.schema.getField(name);
        if (field == null) {
            throw this.unknownProperty(name);
        }
        Object value = this.map.get(name);
        if (field.getType() instanceof BooleanType) {
            value = value == null ? null : ((Boolean)value != false ? ONE : ZERO);
        }
        return value;
    }
}

