/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.storage.sql.RowId;

public final class Row
extends RowId
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT = 5;
    public static final Serializable OPAQUE = OpaqueValue.OPAQUE_VALUE;
    protected String[] keys;
    public Serializable[] values;
    protected int size;
    public static final int MAX_STRING = 100;
    public static final int MAX_ARRAY = 10;

    private Row(Row row) {
        super(row);
        this.keys = row.keys == null ? null : (String[])row.keys.clone();
        this.values = row.values == null ? null : (Serializable[])row.values.clone();
        this.size = row.size;
    }

    public Row clone() {
        return new Row(this);
    }

    public Row(String tableName, Serializable id) {
        super(tableName, id);
        this.keys = new String[5];
        this.values = new Serializable[5];
    }

    public Row(String tableName, Map<String, Serializable> map) {
        super(tableName, null);
        this.keys = new String[map.size()];
        this.values = new Serializable[map.size()];
        for (Map.Entry<String, Serializable> entry : map.entrySet()) {
            this.putNew(entry.getKey(), entry.getValue());
        }
    }

    public Row(String tableName, Serializable id, Serializable[] array) {
        super(tableName, id);
        this.values = (Serializable[])array.clone();
        this.keys = null;
        this.size = -1;
    }

    public boolean isCollection() {
        return this.size == -1;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.values.length) {
            String[] k = this.keys;
            Serializable[] d = this.values;
            int newCapacity = this.values.length * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.keys = new String[newCapacity];
            this.values = new Serializable[newCapacity];
            System.arraycopy(d, 0, this.values, 0, this.size);
            System.arraycopy(k, 0, this.keys, 0, this.size);
        }
    }

    public void put(String key, Serializable value) {
        if (key.equals("id")) {
            this.id = value;
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.keys[i])) continue;
            this.values[i] = value;
            return;
        }
        this.ensureCapacity(this.size + 1);
        this.keys[this.size] = key.intern();
        this.values[this.size++] = value;
    }

    public void put(String key, Serializable value, Serializable[] oldvalues) {
        if (key.equals("id")) {
            this.id = value;
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            Delta delta;
            Number deltaBase;
            Serializable oldValue;
            if (!key.equals(this.keys[i])) continue;
            if (value instanceof Delta && !Objects.equals(oldValue = oldvalues[i], deltaBase = (delta = (Delta)value).getBase())) {
                value = delta.getFullValue();
            }
            this.values[i] = value;
            return;
        }
        this.ensureCapacity(this.size + 1);
        this.keys[this.size] = key.intern();
        this.values[this.size++] = value;
    }

    public void putNew(String key, Serializable value) {
        if (key.equals("id")) {
            this.id = value;
            return;
        }
        this.ensureCapacity(this.size + 1);
        this.keys[this.size] = key.intern();
        this.values[this.size++] = value;
    }

    public Serializable get(String key) {
        if (key.equals("id")) {
            return this.id;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public List<String> getKeys() {
        ArrayList<String> list = new ArrayList<String>(this.size);
        for (int i = 0; i < this.size; ++i) {
            list.add(this.keys[i]);
        }
        return list;
    }

    public List<Serializable> getValues() {
        ArrayList<Serializable> list = new ArrayList<Serializable>(this.size);
        for (int i = 0; i < this.size; ++i) {
            list.add(this.values[i]);
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('(');
        sb.append(this.tableName);
        sb.append(", ");
        sb.append(this.id);
        if (this.size != -1) {
            sb.append(", {");
            for (int i = 0; i < this.size; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.keys[i]);
                sb.append('=');
                Row.printValue(this.values[i], sb);
            }
            sb.append('}');
        } else {
            sb.append(", [");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                Row.printValue(this.values[i], sb);
            }
            sb.append(']');
        }
        sb.append(')');
        return sb.toString();
    }

    public static void printValue(Serializable value, StringBuilder sb) {
        if (value == null) {
            sb.append("NULL");
        } else if (value instanceof String) {
            Object v = (String)((Object)value);
            if (((String)v).length() > 100) {
                v = ((String)v).substring(0, 100) + "...(" + ((String)v).length() + " chars)...";
            }
            sb.append('\"');
            sb.append((String)v);
            sb.append('\"');
        } else if (value instanceof Calendar) {
            char sign;
            Calendar cal = (Calendar)value;
            int offset = cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000;
            if (offset < 0) {
                offset = -offset;
                sign = '-';
            } else {
                sign = '+';
            }
            sb.append(String.format("Calendar(%04d-%02d-%02dT%02d:%02d:%02d.%03d%c%02d:%02d)", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), Character.valueOf(sign), offset / 60, offset % 60));
        } else if (value.getClass().isArray()) {
            Serializable[] v = (Serializable[])value;
            sb.append('[');
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                    if (i > 10) {
                        sb.append("...(");
                        sb.append(v.length);
                        sb.append(" items)...");
                        break;
                    }
                }
                Row.printValue(v[i], sb);
            }
            sb.append(']');
        } else {
            sb.append(value.toString());
        }
    }

    private static enum OpaqueValue {
        OPAQUE_VALUE;

    }
}

