/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapRetryHandler
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(LdapRetryHandler.class);
    protected DirContext dirContext;
    protected int attemptsNumber;

    protected LdapRetryHandler(DirContext object, int attempts) {
        this.dirContext = object;
        this.attemptsNumber = attempts;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int attempts = this.attemptsNumber;
        Throwable e = null;
        while (attempts-- > 0) {
            try {
                return method.invoke((Object)this.dirContext, args);
            }
            catch (InvocationTargetException sue) {
                e = sue.getTargetException();
                if (!(e instanceof ServiceUnavailableException)) {
                    throw sue.getTargetException();
                }
                log.debug((Object)"Retrying ...", e);
            }
        }
        throw e;
    }

    public static DirContext wrap(DirContext dirContext, int retries) {
        LdapRetryHandler handler = new LdapRetryHandler(dirContext, retries);
        return (DirContext)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DirContext.class}, (InvocationHandler)handler);
    }
}

