/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals.operations;

import java.util.ArrayList;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;

@Operation(id="Context.SetMetadataFromBlob", category="Execution Context", label="Read Metadata From Binary to Context", description="Read Metadata From binary to Context for a given input blob and given metadata to inject into the Operation context (if not specified, all metadata will be injected) ", since="7.1", addToStudio=true, aliases={"Context.ReadMetadataFromBinary"})
public class ReadMetadataFromBinaryToContext {
    public static final String ID = "Context.SetMetadataFromBlob";
    public static final String CTX_BINARY_METADATA = "binaryMetadata";
    @Context
    protected BinaryMetadataService binaryMetadataService;
    @Context
    protected OperationContext operationContext;
    @Param(name="ignorePrefix", required=false, description="Ignore metadata prefixes or not")
    boolean ignorePrefix = true;
    @Param(name="processor", required=false, description="The processor to execute for overriding the input blob.")
    protected String processor = "exifTool";
    @Param(name="metadata", required=false, description="Metadata list to filter on the blob.")
    protected StringList metadata;

    @OperationMethod
    public void run(Blob blob) {
        if (this.metadata == null || this.metadata.isEmpty()) {
            this.operationContext.put(CTX_BINARY_METADATA, this.binaryMetadataService.readMetadata(blob, this.ignorePrefix));
        } else {
            ArrayList<String> metadataList = new ArrayList<String>();
            for (String meta : this.metadata) {
                metadataList.add(meta);
            }
            this.operationContext.put(CTX_BINARY_METADATA, this.binaryMetadataService.readMetadata(blob, metadataList, this.ignorePrefix));
        }
    }
}

