/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html.antisamy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.owasp.html.antisamy.AntiSamyPattern;
import org.owasp.html.antisamy.Attribute;
import org.owasp.html.antisamy.Constants;
import org.owasp.html.antisamy.InternalPolicy;
import org.owasp.html.antisamy.Property;
import org.owasp.html.antisamy.Tag;
import org.owasp.html.antisamy.TagMatcher;
import org.owasp.html.antisamy.URIUtils;
import org.owasp.html.antisamy.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Policy {
    public static final Pattern ANYTHING_REGEXP = Pattern.compile(".*");
    protected static final String DEFAULT_POLICY_URI = "resources/antisamy.xml";
    private static final String DEFAULT_ONINVALID = "removeAttribute";
    public static final int DEFAULT_MAX_INPUT_SIZE = 100000;
    public static final int DEFAULT_MAX_STYLESHEET_IMPORTS = 1;
    public static final String OMIT_XML_DECLARATION = "omitXmlDeclaration";
    public static final String OMIT_DOCTYPE_DECLARATION = "omitDoctypeDeclaration";
    public static final String USE_XHTML = "useXHTML";
    public static final String FORMAT_OUTPUT = "formatOutput";
    public static final String EMBED_STYLESHEETS = "embedStyleSheets";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String ANCHORS_NOFOLLOW = "nofollowAnchors";
    public static final String VALIDATE_PARAM_AS_EMBED = "validateParamAsEmbed";
    public static final String PRESERVE_SPACE = "preserveSpace";
    public static final String PRESERVE_COMMENTS = "preserveComments";
    public static final String ENTITY_ENCODE_INTL_CHARS = "entityEncodeIntlChars";
    public static final String ALLOW_DYNAMIC_ATTRIBUTES = "allowDynamicAttributes";
    public static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    public static final String EXTERNAL_PARAM_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    public static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    public static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String ACTION_VALIDATE = "validate";
    public static final String ACTION_FILTER = "filter";
    public static final String ACTION_TRUNCATE = "truncate";
    private final Map<String, AntiSamyPattern> commonRegularExpressions;
    protected final Map<String, Tag> tagRules;
    private final Map<String, Property> cssRules;
    protected final Map<String, String> directives;
    private final Map<String, Attribute> globalAttributes;
    private final Map<String, Attribute> dynamicAttributes;
    private final List<String> allowedEmptyTags;
    private final TagMatcher allowedEmptyTagsMatcher;
    private final TagMatcher requiresClosingTagsMatcher;

    public Tag getTagByLowercaseName(String tagName) {
        return this.tagRules.get(tagName);
    }

    public Collection<Tag> getTagRules() {
        return this.tagRules.values();
    }

    public Property getPropertyByName(String propertyName) {
        return this.cssRules.get(propertyName.toLowerCase());
    }

    public static Policy getInstance() throws IOException {
        return Policy.getInstance(DEFAULT_POLICY_URI);
    }

    public static Policy getInstance(String filename) throws IOException {
        File file = new File(filename);
        return Policy.getInstance(file);
    }

    public static Policy getInstance(InputStream inputStream) throws IOException {
        return new InternalPolicy(null, Policy.getSimpleParseContext(Policy.getTopLevelElement(inputStream)));
    }

    public static Policy getInstance(File file) throws IOException {
        URI uri = file.toURI();
        return Policy.getInstance(uri.toURL());
    }

    public static Policy getInstance(URL url) throws IOException {
        return new InternalPolicy(url, Policy.getParseContext(Policy.getTopLevelElement(url), url));
    }

    protected Policy(ParseContext parseContext) throws IOException {
        this.allowedEmptyTags = Collections.unmodifiableList(parseContext.allowedEmptyTags);
        this.allowedEmptyTagsMatcher = new TagMatcher(parseContext.allowedEmptyTags);
        this.requiresClosingTagsMatcher = new TagMatcher(parseContext.requireClosingTags);
        this.commonRegularExpressions = Collections.unmodifiableMap(parseContext.commonRegularExpressions);
        this.tagRules = Collections.unmodifiableMap(parseContext.tagRules);
        this.cssRules = Collections.unmodifiableMap(parseContext.cssRules);
        this.directives = Collections.unmodifiableMap(parseContext.directives);
        this.globalAttributes = Collections.unmodifiableMap(parseContext.globalAttributes);
        this.dynamicAttributes = Collections.unmodifiableMap(parseContext.dynamicAttributes);
    }

    protected Policy(Policy old, Map<String, String> directives, Map<String, Tag> tagRules) {
        this.allowedEmptyTags = old.allowedEmptyTags;
        this.allowedEmptyTagsMatcher = old.allowedEmptyTagsMatcher;
        this.requiresClosingTagsMatcher = old.requiresClosingTagsMatcher;
        this.commonRegularExpressions = old.commonRegularExpressions;
        this.tagRules = tagRules;
        this.cssRules = old.cssRules;
        this.directives = directives;
        this.globalAttributes = old.globalAttributes;
        this.dynamicAttributes = old.dynamicAttributes;
    }

    protected static ParseContext getSimpleParseContext(Element topLevelElement) throws IOException {
        ParseContext parseContext = new ParseContext();
        if (Policy.getByTagName(topLevelElement, "include").iterator().hasNext()) {
            throw new IllegalArgumentException("A policy file loaded with an InputStream cannot contain include references");
        }
        Policy.parsePolicy(topLevelElement, parseContext);
        return parseContext;
    }

    protected static ParseContext getParseContext(Element topLevelElement, URL baseUrl) throws IOException {
        ParseContext parseContext = new ParseContext();
        for (Element include : Policy.getByTagName(topLevelElement, "include")) {
            String href = XMLUtil.getAttributeValue(include, "href");
            Element includedPolicy = Policy.getPolicy(href, baseUrl);
            Policy.parsePolicy(includedPolicy, parseContext);
        }
        Policy.parsePolicy(topLevelElement, parseContext);
        return parseContext;
    }

    protected static Element getTopLevelElement(URL baseUrl) throws IOException {
        try {
            InputSource source = Policy.resolveEntity(baseUrl.toExternalForm(), baseUrl);
            if (source == null) {
                source = new InputSource(baseUrl.toExternalForm());
                source.setByteStream(baseUrl.openStream());
            } else {
                source.setSystemId(baseUrl.toExternalForm());
            }
            return Policy.getTopLevelElement(source);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private static Element getTopLevelElement(InputStream is) throws IOException {
        return Policy.getTopLevelElement(new InputSource(is));
    }

    protected static Element getTopLevelElement(InputSource source) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
            dbf.setFeature(EXTERNAL_PARAM_ENTITIES, false);
            dbf.setFeature(DISALLOW_DOCTYPE_DECL, true);
            dbf.setFeature(LOAD_EXTERNAL_DTD, false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(source);
            return dom.getDocumentElement();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    private static void parsePolicy(Element topLevelElement, ParseContext parseContext) throws IOException {
        if (topLevelElement == null) {
            return;
        }
        parseContext.resetParamsWhereLastConfigWins();
        Policy.parseCommonRegExps(Policy.getFirstChild(topLevelElement, "common-regexps"), parseContext.commonRegularExpressions);
        Policy.parseDirectives(Policy.getFirstChild(topLevelElement, "directives"), parseContext.directives);
        Policy.parseCommonAttributes(Policy.getFirstChild(topLevelElement, "common-attributes"), parseContext.commonAttributes, parseContext.commonRegularExpressions);
        Policy.parseGlobalAttributes(Policy.getFirstChild(topLevelElement, "global-tag-attributes"), parseContext.globalAttributes, parseContext.commonAttributes);
        Policy.parseDynamicAttributes(Policy.getFirstChild(topLevelElement, "dynamic-tag-attributes"), parseContext.dynamicAttributes, parseContext.commonAttributes);
        Policy.parseTagRules(Policy.getFirstChild(topLevelElement, "tag-rules"), parseContext.commonAttributes, parseContext.commonRegularExpressions, parseContext.tagRules);
        Policy.parseCSSRules(Policy.getFirstChild(topLevelElement, "css-rules"), parseContext.cssRules, parseContext.commonRegularExpressions);
        Policy.parseAllowedEmptyTags(Policy.getFirstChild(topLevelElement, "allowed-empty-tags"), parseContext.allowedEmptyTags);
        Policy.parseRequiresClosingTags(Policy.getFirstChild(topLevelElement, "require-closing-tags"), parseContext.requireClosingTags);
    }

    private static Element getPolicy(String href, URL baseUrl) throws IOException {
        try {
            InputSource source = null;
            if (href != null && baseUrl != null) {
                String absURL2;
                URL url;
                try {
                    url = new URL(baseUrl, href);
                    source = new InputSource(url.openStream());
                    source.setSystemId(href);
                }
                catch (MalformedURLException except) {
                    try {
                        absURL2 = URIUtils.resolveAsString(href, baseUrl.toString());
                        url = new URL(absURL2);
                        source = new InputSource(url.openStream());
                        source.setSystemId(href);
                    }
                    catch (MalformedURLException absURL2) {}
                }
                catch (FileNotFoundException fnfe) {
                    try {
                        absURL2 = URIUtils.resolveAsString(href, baseUrl.toString());
                        url = new URL(absURL2);
                        source = new InputSource(url.openStream());
                        source.setSystemId(href);
                    }
                    catch (MalformedURLException absURL3) {
                        // empty catch block
                    }
                }
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
            dbf.setFeature(EXTERNAL_PARAM_ENTITIES, false);
            dbf.setFeature(DISALLOW_DOCTYPE_DECL, true);
            dbf.setFeature(LOAD_EXTERNAL_DTD, false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (source != null) {
                Document dom = db.parse(source);
                return dom.getDocumentElement();
            }
            return null;
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    public Policy cloneWithDirective(String name, String value) {
        HashMap<String, String> directives = new HashMap<String, String>(this.directives);
        directives.put(name, value);
        return new InternalPolicy(this, Collections.unmodifiableMap(directives), this.tagRules);
    }

    private static void parseDirectives(Element root, Map<String, String> directives) {
        for (Element ele : Policy.getByTagName(root, "directive")) {
            String name = XMLUtil.getAttributeValue(ele, "name");
            String value = XMLUtil.getAttributeValue(ele, "value");
            directives.put(name, value);
        }
    }

    private static void parseAllowedEmptyTags(Element allowedEmptyTagsListNode, List<String> allowedEmptyTags) throws IOException {
        if (allowedEmptyTagsListNode != null) {
            for (Element literalNode : Policy.getGrandChildrenByTagName(allowedEmptyTagsListNode, "literal-list", "literal")) {
                String value = XMLUtil.getAttributeValue(literalNode, "value");
                if (value == null || value.length() <= 0) continue;
                allowedEmptyTags.add(value);
            }
        } else {
            allowedEmptyTags.addAll(Constants.defaultAllowedEmptyTags);
        }
    }

    private static void parseRequiresClosingTags(Element requiresClosingTagsListNode, List<String> requiresClosingTags) throws IOException {
        if (requiresClosingTagsListNode != null) {
            for (Element literalNode : Policy.getGrandChildrenByTagName(requiresClosingTagsListNode, "literal-list", "literal")) {
                String value = XMLUtil.getAttributeValue(literalNode, "value");
                if (value == null || value.length() <= 0) continue;
                requiresClosingTags.add(value);
            }
        } else {
            requiresClosingTags.addAll(Constants.defaultRequiresClosingTags);
        }
    }

    private static void parseGlobalAttributes(Element root, Map<String, Attribute> globalAttributes1, Map<String, Attribute> commonAttributes) throws IOException {
        for (Element ele : Policy.getByTagName(root, "attribute")) {
            String name = XMLUtil.getAttributeValue(ele, "name");
            Attribute toAdd = commonAttributes.get(name.toLowerCase());
            if (toAdd != null) {
                globalAttributes1.put(name.toLowerCase(), toAdd);
                continue;
            }
            throw new IOException("Global attribute '" + name + "' was not defined in <common-attributes>");
        }
    }

    private static void parseDynamicAttributes(Element root, Map<String, Attribute> dynamicAttributes, Map<String, Attribute> commonAttributes) throws IOException {
        for (Element ele : Policy.getByTagName(root, "attribute")) {
            String name = XMLUtil.getAttributeValue(ele, "name");
            Attribute toAdd = commonAttributes.get(name.toLowerCase());
            if (toAdd != null) {
                String attrName = name.toLowerCase().substring(0, name.length() - 1);
                dynamicAttributes.put(attrName, toAdd);
                continue;
            }
            throw new IOException("Dynamic attribute '" + name + "' was not defined in <common-attributes>");
        }
    }

    private static void parseCommonRegExps(Element root, Map<String, AntiSamyPattern> commonRegularExpressions1) {
        for (Element ele : Policy.getByTagName(root, "regexp")) {
            String name = XMLUtil.getAttributeValue(ele, "name");
            Pattern pattern = Pattern.compile(XMLUtil.getAttributeValue(ele, "value"));
            commonRegularExpressions1.put(name, new AntiSamyPattern(pattern));
        }
    }

    private static void parseCommonAttributes(Element root, Map<String, Attribute> commonAttributes1, Map<String, AntiSamyPattern> commonRegularExpressions1) {
        for (Element ele : Policy.getByTagName(root, "attribute")) {
            String onInvalid = XMLUtil.getAttributeValue(ele, "onInvalid");
            String name = XMLUtil.getAttributeValue(ele, "name");
            List<Pattern> allowedRegexps = Policy.getAllowedRegexps(commonRegularExpressions1, ele);
            List<String> allowedValues = Policy.getAllowedLiterals(ele);
            String onInvalidStr = onInvalid != null && onInvalid.length() > 0 ? onInvalid : DEFAULT_ONINVALID;
            String description = XMLUtil.getAttributeValue(ele, "description");
            Attribute attribute = new Attribute(XMLUtil.getAttributeValue(ele, "name"), allowedRegexps, allowedValues, onInvalidStr, description);
            commonAttributes1.put(name.toLowerCase(), attribute);
        }
    }

    private static List<String> getAllowedLiterals(Element ele) {
        ArrayList<String> allowedValues = new ArrayList<String>();
        for (Element literalNode : Policy.getGrandChildrenByTagName(ele, "literal-list", "literal")) {
            String value = XMLUtil.getAttributeValue(literalNode, "value");
            if (value != null && value.length() > 0) {
                allowedValues.add(value);
                continue;
            }
            if (literalNode.getNodeValue() == null) continue;
            allowedValues.add(literalNode.getNodeValue());
        }
        return allowedValues;
    }

    private static List<Pattern> getAllowedRegexps(Map<String, AntiSamyPattern> commonRegularExpressions1, Element ele) {
        ArrayList<Pattern> allowedRegExp = new ArrayList<Pattern>();
        for (Element regExpNode : Policy.getGrandChildrenByTagName(ele, "regexp-list", "regexp")) {
            String regExpName = XMLUtil.getAttributeValue(regExpNode, "name");
            String value = XMLUtil.getAttributeValue(regExpNode, "value");
            if (regExpName != null && regExpName.length() > 0) {
                allowedRegExp.add(commonRegularExpressions1.get(regExpName).getPattern());
                continue;
            }
            allowedRegExp.add(Pattern.compile(value));
        }
        return allowedRegExp;
    }

    private static List<Pattern> getAllowedRegexps2(Map<String, AntiSamyPattern> commonRegularExpressions1, Element attributeNode, String tagName) throws IOException {
        ArrayList<Pattern> allowedRegexps = new ArrayList<Pattern>();
        for (Element regExpNode : Policy.getGrandChildrenByTagName(attributeNode, "regexp-list", "regexp")) {
            String regExpName = XMLUtil.getAttributeValue(regExpNode, "name");
            String value = XMLUtil.getAttributeValue(regExpNode, "value");
            if (regExpName != null && regExpName.length() > 0) {
                AntiSamyPattern pattern = commonRegularExpressions1.get(regExpName);
                if (pattern != null) {
                    allowedRegexps.add(pattern.getPattern());
                    continue;
                }
                throw new IOException("Regular expression '" + regExpName + "' was referenced as a common regexp in definition of '" + tagName + "', but does not exist in <common-regexp>");
            }
            if (value == null || value.length() <= 0) continue;
            allowedRegexps.add(Pattern.compile(value));
        }
        return allowedRegexps;
    }

    private static List<Pattern> getAllowedRegexp3(Map<String, AntiSamyPattern> commonRegularExpressions1, Element ele, String name) throws IOException {
        ArrayList<Pattern> allowedRegExp = new ArrayList<Pattern>();
        for (Element regExpNode : Policy.getGrandChildrenByTagName(ele, "regexp-list", "regexp")) {
            String regExpName = XMLUtil.getAttributeValue(regExpNode, "name");
            String value = XMLUtil.getAttributeValue(regExpNode, "value");
            AntiSamyPattern pattern = commonRegularExpressions1.get(regExpName);
            if (pattern != null) {
                allowedRegExp.add(pattern.getPattern());
                continue;
            }
            if (value != null) {
                allowedRegExp.add(Pattern.compile(value));
                continue;
            }
            throw new IOException("Regular expression '" + regExpName + "' was referenced as a common regexp in definition of '" + name + "', but does not exist in <common-regexp>");
        }
        return allowedRegExp;
    }

    private static void parseTagRules(Element root, Map<String, Attribute> commonAttributes1, Map<String, AntiSamyPattern> commonRegularExpressions1, Map<String, Tag> tagRules1) throws IOException {
        if (root == null) {
            return;
        }
        for (Element tagNode : Policy.getByTagName(root, "tag")) {
            String name = XMLUtil.getAttributeValue(tagNode, "name");
            String action = XMLUtil.getAttributeValue(tagNode, "action");
            NodeList attributeList = tagNode.getElementsByTagName("attribute");
            Map<String, Attribute> tagAttributes = Policy.getTagAttributes(commonAttributes1, commonRegularExpressions1, attributeList, name);
            Tag tag = new Tag(name, tagAttributes, action);
            tagRules1.put(name.toLowerCase(), tag);
        }
    }

    private static Map<String, Attribute> getTagAttributes(Map<String, Attribute> commonAttributes1, Map<String, AntiSamyPattern> commonRegularExpressions1, NodeList attributeList, String tagName) throws IOException {
        HashMap<String, Attribute> tagAttributes = new HashMap<String, Attribute>();
        for (int j = 0; j < attributeList.getLength(); ++j) {
            Element attributeNode = (Element)attributeList.item(j);
            String attrName = XMLUtil.getAttributeValue(attributeNode, "name").toLowerCase();
            if (!attributeNode.hasChildNodes()) {
                Attribute attribute = commonAttributes1.get(attrName);
                if (attribute != null) {
                    String onInvalid = XMLUtil.getAttributeValue(attributeNode, "onInvalid");
                    String description = XMLUtil.getAttributeValue(attributeNode, "description");
                    Attribute changed = attribute.mutate(onInvalid, description);
                    commonAttributes1.put(attrName, changed);
                    tagAttributes.put(attrName, changed);
                    continue;
                }
                throw new IOException("Attribute '" + XMLUtil.getAttributeValue(attributeNode, "name") + "' was referenced as a common attribute in definition of '" + tagName + "', but does not exist in <common-attributes>");
            }
            List<Pattern> allowedRegexps2 = Policy.getAllowedRegexps2(commonRegularExpressions1, attributeNode, tagName);
            List<String> allowedValues2 = Policy.getAllowedLiterals(attributeNode);
            String onInvalid = XMLUtil.getAttributeValue(attributeNode, "onInvalid");
            String description = XMLUtil.getAttributeValue(attributeNode, "description");
            Attribute attribute = new Attribute(XMLUtil.getAttributeValue(attributeNode, "name"), allowedRegexps2, allowedValues2, onInvalid, description);
            tagAttributes.put(attrName, attribute);
        }
        return tagAttributes;
    }

    private static void parseCSSRules(Element root, Map<String, Property> cssRules1, Map<String, AntiSamyPattern> commonRegularExpressions1) throws IOException {
        for (Element ele : Policy.getByTagName(root, "property")) {
            String name = XMLUtil.getAttributeValue(ele, "name");
            String description = XMLUtil.getAttributeValue(ele, "description");
            List<Pattern> allowedRegexp3 = Policy.getAllowedRegexp3(commonRegularExpressions1, ele, name);
            ArrayList<String> allowedValue = new ArrayList<String>();
            for (Element element : Policy.getGrandChildrenByTagName(ele, "literal-list", "literal")) {
                allowedValue.add(XMLUtil.getAttributeValue(element, "value"));
            }
            ArrayList<String> shortHandRefs = new ArrayList<String>();
            for (Element shorthandNode : Policy.getGrandChildrenByTagName(ele, "shorthand-list", "shorthand")) {
                shortHandRefs.add(XMLUtil.getAttributeValue(shorthandNode, "name"));
            }
            String string = XMLUtil.getAttributeValue(ele, "onInvalid");
            String onInvalidStr = string != null && string.length() > 0 ? string : DEFAULT_ONINVALID;
            Property property = new Property(name, allowedRegexp3, allowedValue, shortHandRefs, description, onInvalidStr);
            cssRules1.put(name.toLowerCase(), property);
        }
    }

    public Attribute getGlobalAttributeByName(String name) {
        return this.globalAttributes.get(name.toLowerCase());
    }

    public Collection<Attribute> getGlobalAttributes() {
        return this.globalAttributes.values();
    }

    public Attribute getDynamicAttributeByName(String name) {
        Attribute dynamicAttribute = null;
        for (String d : this.dynamicAttributes.keySet()) {
            if (!name.startsWith(d)) continue;
            dynamicAttribute = this.dynamicAttributes.get(d);
            break;
        }
        return dynamicAttribute;
    }

    public TagMatcher getAllowedEmptyTags() {
        return this.allowedEmptyTagsMatcher;
    }

    public List<String> getAllowedEmptyTagsList() {
        return this.allowedEmptyTags;
    }

    public TagMatcher getRequiresClosingTags() {
        return this.requiresClosingTagsMatcher;
    }

    public String getDirective(String name) {
        return this.directives.get(name);
    }

    public static InputSource resolveEntity(String systemId, URL baseUrl) throws IOException, SAXException {
        if (systemId != null && baseUrl != null) {
            try {
                URL url = new URL(baseUrl, systemId);
                InputSource source = new InputSource(url.openStream());
                source.setSystemId(systemId);
                return source;
            }
            catch (MalformedURLException except) {
                try {
                    String absURL = URIUtils.resolveAsString(systemId, baseUrl.toString());
                    URL url = new URL(absURL);
                    InputSource source = new InputSource(url.openStream());
                    source.setSystemId(systemId);
                    return source;
                }
                catch (MalformedURLException absURL) {
                }
            }
            catch (FileNotFoundException fnfe) {
                try {
                    String absURL = URIUtils.resolveAsString(systemId, baseUrl.toString());
                    URL url = new URL(absURL);
                    InputSource source = new InputSource(url.openStream());
                    source.setSystemId(systemId);
                    return source;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
        return null;
    }

    private static Element getFirstChild(Element element, String tagName) {
        if (element == null) {
            return null;
        }
        NodeList elementsByTagName = element.getElementsByTagName(tagName);
        if (elementsByTagName != null && elementsByTagName.getLength() > 0) {
            return (Element)elementsByTagName.item(0);
        }
        return null;
    }

    private static Iterable<Element> getGrandChildrenByTagName(Element parent, String immediateChildName, String subChild) {
        NodeList elementsByTagName = parent.getElementsByTagName(immediateChildName);
        if (elementsByTagName.getLength() == 0) {
            return Collections.emptyList();
        }
        Element regExpListNode = (Element)elementsByTagName.item(0);
        return Policy.getByTagName(regExpListNode, subChild);
    }

    private static Iterable<Element> getByTagName(Element parent, String tagName) {
        if (parent == null) {
            return Collections.emptyList();
        }
        final NodeList nodes = parent.getElementsByTagName(tagName);
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    int pos = 0;
                    int len;
                    {
                        this.len = nodes.getLength();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pos < this.len;
                    }

                    @Override
                    public Element next() {
                        return (Element)nodes.item(this.pos++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cant remove");
                    }
                };
            }
        };
    }

    public AntiSamyPattern getCommonRegularExpressions(String name) {
        return this.commonRegularExpressions.get(name);
    }

    protected static class ParseContext {
        Map<String, AntiSamyPattern> commonRegularExpressions = new HashMap<String, AntiSamyPattern>();
        Map<String, Attribute> commonAttributes = new HashMap<String, Attribute>();
        Map<String, Tag> tagRules = new HashMap<String, Tag>();
        Map<String, Property> cssRules = new HashMap<String, Property>();
        Map<String, String> directives = new HashMap<String, String>();
        Map<String, Attribute> globalAttributes = new HashMap<String, Attribute>();
        Map<String, Attribute> dynamicAttributes = new HashMap<String, Attribute>();
        List<String> allowedEmptyTags = new ArrayList<String>();
        List<String> requireClosingTags = new ArrayList<String>();

        protected ParseContext() {
        }

        public void resetParamsWhereLastConfigWins() {
            this.allowedEmptyTags.clear();
            this.requireClosingTags.clear();
        }
    }
}

