/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentExistsException;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ListTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.QueryOptimizer;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.StateHelper;
import org.nuxeo.ecm.core.storage.dbs.DBSDocument;
import org.nuxeo.ecm.core.storage.dbs.DBSDocumentState;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSQueryOptimizer;
import org.nuxeo.ecm.core.storage.dbs.DBSRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSTransactionState;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DBSSession
implements Session<QueryFilter> {
    private static final Log log = LogFactory.getLog(DBSSession.class);
    protected static final Set<String> KEYS_RETENTION_HOLD_AND_PROXIES = new HashSet<String>(Arrays.asList("ecm:retainUntil", "ecm:hasLegalHold", "ecm:isRetentionActive", "ecm:isProxy", "ecm:proxyTargetId", "ecm:proxyIds"));
    protected final DBSRepository repository;
    protected final DBSTransactionState transaction;
    protected final boolean fulltextStoredInBlob;
    protected final boolean fulltextSearchDisabled;
    protected final boolean changeTokenEnabled;
    protected boolean closed;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    private final Timer saveTimer;
    private final Timer queryTimer;
    private static final String LOG_MIN_DURATION_KEY = "org.nuxeo.dbs.query.log_min_duration_ms";
    private long LOG_MIN_DURATION_NS = -1000000L;
    protected boolean isLatestVersionDisabled = false;
    protected static final Pattern dotDigitsPattern = Pattern.compile("(.*)\\.[0-9]+$");
    private static final Comparator<DBSDocumentState> VERSION_CREATED_COMPARATOR = (s1, s2) -> {
        Calendar c1 = (Calendar)s1.get("ecm:versionCreated");
        Calendar c2 = (Calendar)s2.get("ecm:versionCreated");
        if (c1 == null && c2 == null) {
            return s1.hashCode() - s2.hashCode();
        }
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        return c1.compareTo(c2);
    };
    private static final Comparator<DBSDocumentState> POS_COMPARATOR = (s1, s2) -> {
        Long p1 = (Long)s1.get("ecm:pos");
        Long p2 = (Long)s2.get("ecm:pos");
        if (p1 == null && p2 == null) {
            return s1.hashCode() - s2.hashCode();
        }
        if (p1 == null) {
            return 1;
        }
        if (p2 == null) {
            return -1;
        }
        return p1.compareTo(p2);
    };
    protected static final Type STRING_ARRAY_TYPE = new ListTypeImpl("", "", (Type)StringType.INSTANCE);
    public static final Set<String> TRUE_OR_NULL_BOOLEAN_KEYS = Set.of("ecm:isVersion", "ecm:isCheckedIn", "ecm:isLatestVersion", "ecm:isLatestMajorVersion", "ecm:isProxy", "ecm:isTrashed", "ecm:isRecord", "ecm:hasLegalHold");
    public static final Set<String> ID_VALUES_KEYS = Set.of("ecm:id", "ecm:parentId", "ecm:ancestorIds", "ecm:versionSeriesId", "ecm:baseVersionId", "ecm:proxyTargetId", "ecm:proxyIds", "ecm:proxyVersionSeriesId", "ecm:fulltextJobId");

    public DBSSession(DBSRepository repository) {
        this.repository = repository;
        this.transaction = new DBSTransactionState(repository, this);
        FulltextConfiguration fulltextConfiguration = repository.getFulltextConfiguration();
        this.fulltextStoredInBlob = fulltextConfiguration != null && fulltextConfiguration.fulltextStoredInBlob;
        this.fulltextSearchDisabled = fulltextConfiguration == null || fulltextConfiguration.fulltextSearchDisabled;
        this.changeTokenEnabled = repository.isChangeTokenEnabled();
        this.saveTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "save"}).tagged(new String[]{"repository", repository.getName()}));
        this.queryTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "query"}).tagged(new String[]{"repository", repository.getName()}));
        this.LOG_MIN_DURATION_NS = Long.parseLong(Framework.getProperty((String)LOG_MIN_DURATION_KEY, (String)"-1")) * 1000000L;
        this.isLatestVersionDisabled = Framework.isBooleanPropertyTrue((String)"org.nuxeo.core.isLatestVersion.disabled");
    }

    public String getRepositoryName() {
        return this.repository.getName();
    }

    public void close() {
        this.transaction.close();
        this.closed = true;
    }

    public boolean isLive() {
        return !this.closed;
    }

    public void save() {
        Timer.Context timerContext = this.saveTimer.time();
        try {
            this.transaction.save();
            if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                this.transaction.commit();
            }
        }
        finally {
            timerContext.stop();
        }
    }

    public void begin() {
        this.transaction.begin();
    }

    public void commit() {
        this.transaction.commit();
    }

    public void rollback() {
        this.transaction.rollback();
    }

    protected BlobManager getBlobManager() {
        return this.repository.getBlobManager();
    }

    protected DocumentBlobManager getDocumentBlobManager() {
        return (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
    }

    protected String getRootId() {
        return this.transaction.getRootId();
    }

    protected String normalize(String path) {
        return Normalizer.normalize(path, Normalizer.Form.NFC);
    }

    public Document resolvePath(String path) {
        if (path == null) {
            throw new DocumentNotFoundException("Null path");
        }
        int len = path.length();
        if (len == 0) {
            throw new DocumentNotFoundException("Empty path");
        }
        if (path.charAt(0) != '/') {
            throw new DocumentNotFoundException("Relative path: " + path);
        }
        if (len > 1 && path.charAt(len - 1) == '/') {
            path = path.substring(0, len - 1);
            --len;
        }
        path = this.normalize(path);
        if (len == 1) {
            return this.getRootDocument();
        }
        DBSDocumentState docState = null;
        String parentId = this.getRootId();
        String[] names = path.split("/", -1);
        for (int i = 1; i < names.length; ++i) {
            String name = names[i];
            if (name.length() == 0) {
                throw new DocumentNotFoundException("Path with empty component: " + path);
            }
            docState = this.transaction.getChildState(parentId, name);
            if (docState == null) {
                throw new DocumentNotFoundException(path);
            }
            parentId = docState.getId();
        }
        return this.getDocument(docState);
    }

    protected String getDocumentIdByPath(String path) {
        if (path == null) {
            throw new DocumentNotFoundException("Null path");
        }
        int len = path.length();
        if (len == 0) {
            throw new DocumentNotFoundException("Empty path");
        }
        if (path.charAt(0) != '/') {
            throw new DocumentNotFoundException("Relative path: " + path);
        }
        if (len > 1 && path.charAt(len - 1) == '/') {
            path = path.substring(0, len - 1);
            --len;
        }
        path = this.normalize(path);
        if (len == 1) {
            return this.getRootId();
        }
        DBSDocumentState docState = null;
        String parentId = this.getRootId();
        String[] names = path.split("/", -1);
        for (int i = 1; i < names.length; ++i) {
            String name = names[i];
            if (name.length() == 0) {
                throw new DocumentNotFoundException("Path with empty component: " + path);
            }
            docState = this.transaction.getChildState(parentId, name);
            if (docState == null) {
                return null;
            }
            parentId = docState.getId();
        }
        return docState.getId();
    }

    protected Document getChild(String parentId, String name) {
        DBSDocumentState docState = this.transaction.getChildState(parentId, name = this.normalize(name));
        DBSDocument doc = this.getDocument(docState);
        if (doc == null) {
            throw new DocumentNotFoundException(name);
        }
        return doc;
    }

    protected List<Document> getChildren(String parentId) {
        List<DBSDocumentState> docStates = this.transaction.getChildrenStates(parentId);
        if (this.isOrderable(parentId)) {
            docStates.sort(POS_COMPARATOR);
        }
        ArrayList<Document> children = new ArrayList<Document>(docStates.size());
        for (DBSDocumentState docState : docStates) {
            try {
                children.add((Document)this.getDocument(docState));
            }
            catch (DocumentNotFoundException e) {}
        }
        return children;
    }

    protected List<String> getChildrenIds(String parentId) {
        boolean excludeSpecialChildren = false;
        boolean excludeRegularChildren = false;
        return this.getChildrenIds(parentId, excludeSpecialChildren, excludeRegularChildren);
    }

    protected List<String> getChildrenIds(String parentId, boolean excludeSpecialChildren, boolean excludeRegularChildren) {
        if (this.isOrderable(parentId)) {
            List<DBSDocumentState> docStates = this.transaction.getChildrenStates(parentId, excludeSpecialChildren, excludeRegularChildren);
            docStates.sort(POS_COMPARATOR);
            ArrayList<String> children = new ArrayList<String>(docStates.size());
            for (DBSDocumentState docState : docStates) {
                children.add(docState.getId());
            }
            return children;
        }
        return this.transaction.getChildrenIds(parentId, excludeSpecialChildren, excludeRegularChildren);
    }

    protected boolean hasChildren(String parentId) {
        return this.transaction.hasChildren(parentId);
    }

    public Document getDocumentByUUID(String id) {
        DBSDocument doc = this.getDocument(id);
        if (doc != null) {
            return doc;
        }
        throw new DocumentNotFoundException(id);
    }

    public Document getRootDocument() {
        return this.getDocument(this.getRootId());
    }

    public Document getNullDocument() {
        return new DBSDocument(null, null, this, true);
    }

    protected DBSDocument getDocument(String id) {
        DBSDocumentState docState = this.transaction.getStateForUpdate(id);
        return this.getDocument(docState);
    }

    protected List<Document> getDocuments(List<String> ids) {
        List<DBSDocumentState> docStates = this.transaction.getStatesForUpdate(ids);
        ArrayList<Document> docs = new ArrayList<Document>(ids.size());
        for (DBSDocumentState docState : docStates) {
            try {
                docs.add((Document)this.getDocument(docState));
            }
            catch (DocumentNotFoundException e) {}
        }
        return docs;
    }

    protected DBSDocument getDocument(DBSDocumentState docState) {
        return this.getDocument(docState, true);
    }

    protected DBSDocument getDocument(DBSDocumentState docState, boolean readonly) {
        String targetId;
        DBSDocumentState targetState;
        if (docState == null) {
            return null;
        }
        boolean isVersion = Boolean.TRUE.equals(docState.get("ecm:isVersion"));
        String typeName = docState.getPrimaryType();
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        DocumentType type = schemaManager.getDocumentType(typeName);
        if (type == null) {
            throw new DocumentNotFoundException("Unknown document type: " + typeName);
        }
        boolean isProxy = Boolean.TRUE.equals(docState.get("ecm:isProxy"));
        if (isProxy && (targetState = this.transaction.getStateForUpdate(targetId = (String)((Object)docState.get("ecm:proxyTargetId")))) == null) {
            throw new DocumentNotFoundException("Proxy has null target");
        }
        if (isVersion) {
            return new DBSDocument(docState, type, this, readonly);
        }
        return new DBSDocument(docState, type, this, false);
    }

    protected boolean hasChild(String parentId, String name) {
        name = this.normalize(name);
        return this.transaction.hasChild(parentId, name);
    }

    public Document createChild(String id, String parentId, String name, Long pos, String typeName) {
        name = this.normalize(name);
        DBSDocumentState docState = this.createChildState(id, parentId, name, pos, typeName);
        return this.getDocument(docState);
    }

    protected DBSDocumentState createChildState(String id, String parentId, String name, Long pos, String typeName) {
        if (pos == null && parentId != null) {
            pos = this.getNextPos(parentId);
        }
        return this.transaction.createChild(id, parentId, name, pos, typeName);
    }

    protected boolean isOrderable(String id) {
        State state = this.transaction.getStateForRead(id);
        String typeName = (String)((Object)state.get((Object)"ecm:primaryType"));
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        return schemaManager.getDocumentType(typeName).getFacets().contains("Orderable");
    }

    protected Long getNextPos(String parentId) {
        if (!this.isOrderable(parentId)) {
            return null;
        }
        long max = -1L;
        for (DBSDocumentState docState : this.transaction.getChildrenStates(parentId)) {
            Long pos = (Long)docState.get("ecm:pos");
            if (pos == null || pos <= max) continue;
            max = pos;
        }
        return max + 1L;
    }

    protected void orderBefore(String parentId, String sourceId, String destId) {
        Long setPos;
        if (!this.isOrderable(parentId)) {
            return;
        }
        if (sourceId.equals(destId)) {
            return;
        }
        List<DBSDocumentState> docStates = this.transaction.getChildrenStates(parentId);
        docStates.sort(POS_COMPARATOR);
        int i = 0;
        DBSDocumentState source = null;
        Long destPos = null;
        for (DBSDocumentState docState : docStates) {
            Long setPos2;
            String id = docState.getId();
            if (id.equals(destId)) {
                destPos = i;
                ++i;
                if (source != null) {
                    source.put("ecm:pos", destPos);
                }
            }
            if (id.equals(sourceId)) {
                --i;
                source = docState;
                setPos2 = destPos;
            } else {
                setPos2 = i;
            }
            if (setPos2 != null && !setPos2.equals(docState.get("ecm:pos"))) {
                docState.put("ecm:pos", setPos2);
            }
            ++i;
        }
        if (destId == null && !(setPos = Long.valueOf(i)).equals(source.get("ecm:pos"))) {
            source.put("ecm:pos", setPos);
        }
    }

    protected void checkOut(String id) {
        DBSDocumentState docState = this.transaction.getStateForUpdate(id);
        if (!Boolean.TRUE.equals(docState.get("ecm:isCheckedIn"))) {
            throw new NuxeoException("Already checked out");
        }
        docState.put("ecm:isCheckedIn", null);
    }

    protected Document checkIn(String id, String label, String checkinComment) {
        this.transaction.save();
        DBSDocumentState docState = this.transaction.getStateForUpdate(id);
        if (Boolean.TRUE.equals(docState.get("ecm:isCheckedIn"))) {
            throw new NuxeoException("Already checked in");
        }
        if (label == null) {
            Long major = (Long)docState.get("ecm:majorVersion");
            Long minor = (Long)docState.get("ecm:minorVersion");
            label = major == null || minor == null ? "" : major + "." + minor;
        }
        boolean excludeSpecialChildren = false;
        boolean excludeRegularChildren = true;
        String versionId = this.copyRecurse(id, null, new LinkedList<String>(), null, excludeSpecialChildren, excludeRegularChildren);
        DBSDocumentState verState = this.transaction.getStateForUpdate(versionId);
        String verId = verState.getId();
        verState.put("ecm:parentId", null);
        verState.put("ecm:ancestorIds", null);
        verState.put("ecm:isVersion", Boolean.TRUE);
        verState.put("ecm:versionSeriesId", (Serializable)((Object)id));
        verState.put("ecm:versionCreated", new GregorianCalendar());
        verState.put("ecm:versionLabel", (Serializable)label);
        verState.put("ecm:versionDescription", (Serializable)((Object)checkinComment));
        verState.put("ecm:isLatestVersion", Boolean.TRUE);
        verState.put("ecm:isCheckedIn", null);
        verState.put("ecm:baseVersionId", null);
        boolean isMajor = Long.valueOf(0L).equals(verState.get("ecm:minorVersion"));
        verState.put("ecm:isLatestMajorVersion", isMajor ? Boolean.TRUE : null);
        docState.put("ecm:isCheckedIn", Boolean.TRUE);
        docState.put("ecm:baseVersionId", (Serializable)((Object)verId));
        if (!this.isLatestVersionDisabled) {
            this.recomputeVersionSeries(id);
        }
        this.transaction.save();
        return this.getDocument(verId);
    }

    protected void recomputeVersionSeries(String versionSeriesId) {
        List<DBSDocumentState> docStates = this.transaction.getKeyValuedStates("ecm:versionSeriesId", versionSeriesId, "ecm:isVersion", Boolean.TRUE);
        docStates.sort(VERSION_CREATED_COMPARATOR);
        Collections.reverse(docStates);
        boolean isLatest = true;
        boolean isLatestMajor = true;
        for (DBSDocumentState docState : docStates) {
            docState.put("ecm:isLatestVersion", isLatest ? Boolean.TRUE : null);
            isLatest = false;
            boolean isMajor = Long.valueOf(0L).equals(docState.get("ecm:minorVersion"));
            docState.put("ecm:isLatestMajorVersion", isMajor && isLatestMajor ? Boolean.TRUE : null);
            if (!isMajor) continue;
            isLatestMajor = false;
        }
    }

    protected void restoreVersion(Document doc, Document version) {
        String docId = doc.getUUID();
        String versionId = version.getUUID();
        DBSDocumentState docState = this.transaction.getStateForUpdate(docId);
        if (Boolean.TRUE.equals(docState.get("ecm:isRecord"))) {
            this.getDocumentBlobManager().notifyBeforeRemove(doc);
        }
        State versionState = this.transaction.getStateForRead(versionId);
        for (String key : docState.state.keyArray()) {
            if (this.keepWhenRestore(key)) continue;
            docState.put(key, null);
        }
        for (Map.Entry en : versionState.entrySet()) {
            String key = (String)en.getKey();
            if (this.keepWhenRestore(key)) continue;
            docState.put(key, StateHelper.deepCopy(en.getValue()));
        }
        docState.put("ecm:isVersion", null);
        docState.put("ecm:isCheckedIn", Boolean.TRUE);
        docState.put("ecm:baseVersionId", (Serializable)((Object)versionId));
        docState.put("ecm:isRecord", null);
        docState.put("ecm:retainUntil", null);
        docState.put("ecm:hasLegalHold", null);
        if (Boolean.TRUE.equals(versionState.get((Object)"ecm:isRecord"))) {
            this.getDocumentBlobManager().notifyAfterCopy(doc);
        }
    }

    protected boolean keepWhenRestore(String key) {
        switch (key) {
            case "ecm:id": 
            case "ecm:parentId": 
            case "ecm:ancestorIds": 
            case "ecm:name": 
            case "ecm:pos": 
            case "ecm:primaryType": 
            case "ecm:acp": 
            case "ecm:racl": 
            case "ecm:versionCreated": 
            case "ecm:versionDescription": 
            case "ecm:versionLabel": 
            case "ecm:versionSeriesId": 
            case "ecm:isLatestVersion": 
            case "ecm:isLatestMajorVersion": 
            case "ecm:isVersion": 
            case "ecm:isCheckedIn": 
            case "ecm:baseVersionId": 
            case "ecm:isRecord": 
            case "ecm:retainUntil": 
            case "ecm:hasLegalHold": {
                return true;
            }
        }
        return false;
    }

    public Document copy(Document source, Document parent, String name) {
        this.transaction.save();
        if (name == null) {
            name = source.getName();
        }
        name = this.findFreeName(parent, name);
        String sourceId = source.getUUID();
        String parentId = parent.getUUID();
        State sourceState = this.transaction.getStateForRead(sourceId);
        State parentState = this.transaction.getStateForRead(parentId);
        String oldParentId = (String)((Object)sourceState.get((Object)"ecm:parentId"));
        Object[] parentAncestorIds = (Object[])parentState.get((Object)"ecm:ancestorIds");
        LinkedList<String> ancestorIds = new LinkedList<String>();
        if (parentAncestorIds != null) {
            for (Object id : parentAncestorIds) {
                ancestorIds.add((String)id);
            }
        }
        ancestorIds.add(parentId);
        if (oldParentId != null && !oldParentId.equals(parentId) && ancestorIds.contains(sourceId)) {
            throw new DocumentExistsException("Cannot copy a node under itself: " + parentId + " is under " + sourceId);
        }
        Long pos = this.getNextPos(parentId);
        boolean excludeSpecialChildren = true;
        boolean excludeRegularChildren = false;
        String copyId = this.copyRecurse(sourceId, parentId, ancestorIds, name, excludeSpecialChildren, excludeRegularChildren);
        DBSDocumentState copyState = this.transaction.getStateForUpdate(copyId);
        if (source.isVersion()) {
            copyState.put("ecm:isVersion", null);
        }
        copyState.put("ecm:pos", pos);
        this.transaction.updateTreeReadAcls(copyId);
        return this.getDocument(copyState);
    }

    protected String copyRecurse(String sourceId, String parentId, LinkedList<String> ancestorIds, String name, boolean excludeSpecialChildren, boolean excludeRegularChildren) {
        String copyId = this.copy(sourceId, parentId, ancestorIds, name);
        ancestorIds.addLast(copyId);
        for (String childId : this.getChildrenIds(sourceId, excludeSpecialChildren, excludeRegularChildren)) {
            this.copyRecurse(childId, copyId, ancestorIds, null, excludeSpecialChildren, false);
        }
        ancestorIds.removeLast();
        return copyId;
    }

    protected String copy(String sourceId, String parentId, List<String> ancestorIds, String name) {
        DBSDocumentState copy = this.transaction.copy(sourceId);
        copy.put("ecm:parentId", (Serializable)((Object)parentId));
        copy.put("ecm:ancestorIds", (Serializable)ancestorIds.toArray(new Object[ancestorIds.size()]));
        if (name != null) {
            copy.put("ecm:name", (Serializable)((Object)name));
        }
        copy.put("ecm:baseVersionId", null);
        copy.put("ecm:isCheckedIn", null);
        if (parentId != null) {
            copy.put("ecm:majorVersion", null);
            copy.put("ecm:minorVersion", null);
        }
        if (Boolean.TRUE.equals(copy.get("ecm:isRecord"))) {
            copy.put("ecm:isRecord", null);
            copy.put("ecm:retainUntil", null);
            copy.put("ecm:hasLegalHold", null);
            DBSDocument doc = this.getDocument(copy);
            this.getDocumentBlobManager().notifyAfterCopy((Document)doc);
        }
        return copy.getId();
    }

    protected String findFreeName(Document parent, String name) {
        if (this.hasChild(parent.getUUID(), (String)name)) {
            Matcher m = dotDigitsPattern.matcher((CharSequence)name);
            if (m.matches()) {
                name = m.group(1);
            }
            name = (String)name + "." + System.currentTimeMillis();
        }
        return name;
    }

    protected void checkNotUnder(String parentId, String id, String op) {
        State state;
        String pid = parentId;
        do {
            if (pid.equals(id)) {
                throw new DocumentExistsException("Cannot " + op + " a node under itself: " + parentId + " is under " + id);
            }
            state = this.transaction.getStateForRead(pid);
            if (state != null) continue;
            throw new NuxeoException("No parent: " + pid);
        } while ((pid = (String)((Object)state.get((Object)"ecm:parentId"))) != null);
    }

    public Document move(Document source, Document parent, String name) {
        String oldName = source.getName();
        if (name == null) {
            name = oldName;
        }
        String sourceId = source.getUUID();
        String parentId = parent.getUUID();
        DBSDocumentState sourceState = this.transaction.getStateForUpdate(sourceId);
        String oldParentId = (String)((Object)sourceState.get("ecm:parentId"));
        if (Objects.equals(oldParentId, parentId)) {
            if (!oldName.equals(name)) {
                if (this.hasChild(parentId, name)) {
                    throw new DocumentExistsException("Destination name already exists: " + name);
                }
                sourceState.put("ecm:name", (Serializable)((Object)name));
            }
            return source;
        }
        this.transaction.save();
        if (this.hasChild(parentId, name)) {
            throw new DocumentExistsException("Destination name already exists: " + name);
        }
        State parentState = this.transaction.getStateForRead(parentId);
        Object[] parentAncestorIds = (Object[])parentState.get((Object)"ecm:ancestorIds");
        ArrayList<String> ancestorIdsList = new ArrayList<String>();
        if (parentAncestorIds != null) {
            for (Object id : parentAncestorIds) {
                ancestorIdsList.add((String)id);
            }
        }
        ancestorIdsList.add(parentId);
        Object[] ancestorIds = ancestorIdsList.toArray(new Object[ancestorIdsList.size()]);
        if (ancestorIdsList.contains(sourceId)) {
            throw new DocumentExistsException("Cannot move a node under itself: " + parentId + " is under " + sourceId);
        }
        sourceState.put("ecm:name", (Serializable)((Object)name));
        sourceState.put("ecm:parentId", (Serializable)((Object)parentId));
        Object[] oldAncestorIds = (Object[])sourceState.get("ecm:ancestorIds");
        int ndel = oldAncestorIds == null ? 0 : oldAncestorIds.length;
        this.transaction.updateAncestors(sourceId, ndel, ancestorIds);
        this.transaction.updateTreeReadAcls(sourceId);
        return source;
    }

    protected void remove(String rootId, NuxeoPrincipal principal) {
        boolean allowDeleteUndeletable;
        this.transaction.save();
        State rootState = this.transaction.getStateForRead(rootId);
        String versionSeriesId = Boolean.TRUE.equals(rootState.get((Object)"ecm:isVersion")) ? (String)((Object)rootState.get((Object)"ecm:versionSeriesId")) : null;
        HashSet<String> removedIds = new HashSet<String>();
        HashSet undeletableIds = new HashSet();
        HashSet targetIds = new HashSet();
        HashMap targetProxies = new HashMap();
        Calendar now = Calendar.getInstance();
        Consumer<State> collector = state -> {
            Object[] proxyIds;
            String id = (String)((Object)state.get((Object)"ecm:id"));
            removedIds.add(id);
            if (Boolean.TRUE.equals(state.get((Object)"ecm:hasLegalHold"))) {
                undeletableIds.add(id);
            } else {
                Calendar retainUntil = (Calendar)state.get((Object)"ecm:retainUntil");
                if (retainUntil != null && now.before(retainUntil)) {
                    undeletableIds.add(id);
                }
            }
            if (Boolean.TRUE.equals(state.get((Object)"ecm:isRetentionActive"))) {
                undeletableIds.add(id);
            }
            if (Boolean.TRUE.equals(state.get((Object)"ecm:isProxy"))) {
                String targetId = (String)((Object)state.get((Object)"ecm:proxyTargetId"));
                targetIds.add(targetId);
            }
            if ((proxyIds = (Object[])state.get((Object)"ecm:proxyIds")) != null) {
                targetProxies.put(id, proxyIds);
            }
        };
        collector.accept(rootState);
        try (Stream<State> states = this.transaction.getDescendants(rootId, KEYS_RETENTION_HOLD_AND_PROXIES, 0);){
            states.forEach(collector);
        }
        if (!undeletableIds.isEmpty() && !(allowDeleteUndeletable = Framework.isBooleanPropertyTrue((String)"org.nuxeo.core.allowDeleteUndeletableDocuments"))) {
            if (undeletableIds.contains(rootId)) {
                throw new DocumentExistsException("Cannot remove " + rootId + ", it is under retention / hold");
            }
            throw new DocumentExistsException("Cannot remove " + rootId + ", subdocument " + (String)undeletableIds.iterator().next() + " is under retention / hold");
        }
        for (Map.Entry en : targetProxies.entrySet()) {
            String targetId = (String)en.getKey();
            for (Object proxyId : (Object[])en.getValue()) {
                if (removedIds.contains(proxyId)) continue;
                throw new DocumentExistsException("Cannot remove " + rootId + ", subdocument " + targetId + " is the target of proxy " + proxyId);
            }
        }
        this.transaction.removeStates(Collections.singleton(rootId));
        if (removedIds.size() > 1) {
            String nxql = String.format("SELECT * FROM Document, Relation WHERE ecm:ancestorId = '%s'", rootId);
            BulkCommand command = new BulkCommand.Builder("deletion", nxql, principal.getName()).repository(this.getRepositoryName()).build();
            ((BulkService)Framework.getService(BulkService.class)).submit(command);
        }
        for (String targetId : targetIds) {
            DBSDocumentState target;
            if (removedIds.contains(targetId) || (target = this.transaction.getStateForUpdate(targetId)) == null) continue;
            this.removeBackProxyIds(target, removedIds);
        }
        if (versionSeriesId != null) {
            this.recomputeVersionSeries(versionSeriesId);
        }
    }

    public Document createProxy(Document doc, Document folder) {
        String versionSeriesId;
        String targetId;
        if (doc == null) {
            throw new NullPointerException();
        }
        String id = doc.getUUID();
        if (doc.isVersion()) {
            targetId = id;
            versionSeriesId = doc.getVersionSeriesId();
        } else if (doc.isProxy()) {
            State state = this.transaction.getStateForRead(id);
            targetId = (String)((Object)state.get((Object)"ecm:proxyTargetId"));
            versionSeriesId = (String)((Object)state.get((Object)"ecm:proxyVersionSeriesId"));
        } else {
            versionSeriesId = targetId = id;
        }
        String parentId = folder.getUUID();
        String name = this.findFreeName(folder, doc.getName());
        Long pos = parentId == null ? null : this.getNextPos(parentId);
        DBSDocumentState docState = this.addProxyState(null, parentId, name, pos, targetId, versionSeriesId);
        return this.getDocument(docState);
    }

    protected DBSDocumentState addProxyState(String id, String parentId, String name, Long pos, String targetId, String versionSeriesId) {
        DBSDocumentState target = this.transaction.getStateForUpdate(targetId);
        String typeName = (String)((Object)target.get("ecm:primaryType"));
        DBSDocumentState proxy = this.transaction.createChild(id, parentId, name, pos, typeName);
        String proxyId = proxy.getId();
        proxy.put("ecm:isProxy", Boolean.TRUE);
        proxy.put("ecm:proxyTargetId", (Serializable)((Object)targetId));
        proxy.put("ecm:proxyVersionSeriesId", (Serializable)((Object)versionSeriesId));
        this.transaction.updateProxy(target, proxyId);
        this.addBackProxyId(target, proxyId);
        return this.transaction.getStateForUpdate(proxyId);
    }

    protected void addBackProxyId(DBSDocumentState docState, String id) {
        Object[] newProxyIds;
        Object[] proxyIds = (Object[])docState.get("ecm:proxyIds");
        if (proxyIds == null) {
            newProxyIds = new Object[]{id};
        } else {
            newProxyIds = new Object[proxyIds.length + 1];
            System.arraycopy(proxyIds, 0, newProxyIds, 0, proxyIds.length);
            newProxyIds[proxyIds.length] = id;
        }
        docState.put("ecm:proxyIds", (Serializable)newProxyIds);
    }

    protected void removeBackProxyId(DBSDocumentState docState, String id) {
        this.removeBackProxyIds(docState, Collections.singleton(id));
    }

    protected void removeBackProxyIds(DBSDocumentState docState, Set<String> ids) {
        Object[] proxyIds = (Object[])docState.get("ecm:proxyIds");
        if (proxyIds == null) {
            return;
        }
        ArrayList<Object> keepIds = new ArrayList<Object>(proxyIds.length);
        for (Object pid : proxyIds) {
            if (ids.contains(pid)) continue;
            keepIds.add(pid);
        }
        Object[] newProxyIds = keepIds.isEmpty() ? null : keepIds.toArray(new Object[keepIds.size()]);
        docState.put("ecm:proxyIds", (Serializable)newProxyIds);
    }

    public List<Document> getProxies(Document doc, Document folder) {
        List<DBSDocumentState> docStates;
        String docId = doc.getUUID();
        if (doc.isVersion()) {
            docStates = this.transaction.getKeyValuedStates("ecm:proxyTargetId", docId);
        } else {
            String versionSeriesId;
            if (doc.isProxy()) {
                State state = this.transaction.getStateForRead(docId);
                versionSeriesId = (String)((Object)state.get((Object)"ecm:proxyVersionSeriesId"));
            } else {
                versionSeriesId = docId;
            }
            docStates = this.transaction.getKeyValuedStates("ecm:proxyVersionSeriesId", versionSeriesId);
        }
        String parentId = folder == null ? null : folder.getUUID();
        ArrayList<Document> documents = new ArrayList<Document>(docStates.size());
        for (DBSDocumentState docState : docStates) {
            if (parentId != null && !parentId.equals(docState.getParentId())) continue;
            documents.add((Document)this.getDocument(docState));
        }
        return documents;
    }

    public List<Document> getProxies(Document doc) {
        State state = this.transaction.getStateForRead(doc.getUUID());
        Object[] proxyIds = (Object[])state.get((Object)"ecm:proxyIds");
        if (proxyIds != null) {
            List<String> ids = Arrays.stream(proxyIds).map(String::valueOf).collect(Collectors.toList());
            return this.getDocuments(ids);
        }
        return Collections.emptyList();
    }

    public void setProxyTarget(Document proxy, Document target) {
        String proxyId = proxy.getUUID();
        String targetId = target.getUUID();
        DBSDocumentState proxyState = this.transaction.getStateForUpdate(proxyId);
        String oldTargetId = (String)((Object)proxyState.get("ecm:proxyTargetId"));
        DBSDocumentState oldTargetState = this.transaction.getStateForUpdate(oldTargetId);
        this.removeBackProxyId(oldTargetState, proxyId);
        DBSDocumentState targetState = this.transaction.getStateForUpdate(targetId);
        this.addBackProxyId(targetState, proxyId);
        proxyState.put("ecm:proxyTargetId", (Serializable)((Object)targetId));
    }

    public Document importDocument(String id, Document parent, String name, String typeName, Map<String, Serializable> properties) {
        DBSDocumentState docState;
        String parentId = parent == null ? null : parent.getUUID();
        boolean isProxy = typeName.equals("ecm:proxy");
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        Long pos = null;
        if (isProxy) {
            String targetId = (String)((Object)properties.get("ecm:proxyTargetId"));
            if (targetId == null) {
                throw new NuxeoException("Cannot import proxy " + id + " with null target");
            }
            State targetState = this.transaction.getStateForRead(targetId);
            if (targetState == null) {
                throw new DocumentNotFoundException("Cannot import proxy " + id + " with missing target " + targetId);
            }
            String versionSeriesId = (String)((Object)properties.get("ecm:proxyVersionableId"));
            docState = this.addProxyState(id, parentId, name, pos, targetId, versionSeriesId);
        } else {
            Serializable isRetentionActiveProp;
            Serializable importLockCreatedProp;
            props.put("ecm:lifeCyclePolicy", properties.get("ecm:lifeCyclePolicy"));
            props.put("ecm:lifeCycleState", properties.get("ecm:lifeCycleState"));
            Serializable importLockOwnerProp = properties.get("ecm:lockOwner");
            if (importLockOwnerProp != null) {
                props.put("ecm:lockOwner", importLockOwnerProp);
            }
            if ((importLockCreatedProp = properties.get("ecm:lockCreated")) != null) {
                props.put("ecm:lockCreated", importLockCreatedProp);
            }
            Boolean isRecord = DBSSession.trueOrNull(properties.get("ecm:isRecord"));
            props.put("ecm:isRecord", isRecord);
            if (Boolean.TRUE.equals(isRecord)) {
                Calendar retainUntil = (Calendar)properties.get("ecm:retainUntil");
                if (retainUntil != null) {
                    props.put("ecm:retainUntil", retainUntil);
                }
                Boolean hasLegalHold = DBSSession.trueOrNull(properties.get("ecm:hasLegalHold"));
                props.put("ecm:hasLegalHold", hasLegalHold);
            }
            if (Boolean.TRUE.equals(isRetentionActiveProp = properties.get("ecm:isRetentionActive"))) {
                props.put("ecm:isRetentionActive", Boolean.TRUE);
            }
            props.put("ecm:majorVersion", properties.get("ecm:majorVersion"));
            props.put("ecm:minorVersion", properties.get("ecm:minorVersion"));
            Boolean isVersion = DBSSession.trueOrNull(properties.get("ecm:isVersion"));
            props.put("ecm:isVersion", isVersion);
            if (Boolean.TRUE.equals(isVersion)) {
                props.put("ecm:versionSeriesId", properties.get("ecm:versionableId"));
                props.put("ecm:versionCreated", properties.get("ecm:versionCreated"));
                props.put("ecm:versionLabel", properties.get("ecm:versionLabel"));
                props.put("ecm:versionDescription", properties.get("ecm:versionDescription"));
                props.put("ecm:isLatestVersion", DBSSession.trueOrNull(properties.get("ecm:isLatestVersion")));
                props.put("ecm:isLatestMajorVersion", DBSSession.trueOrNull(properties.get("ecm:isLatestMajorVersion")));
            } else {
                props.put("ecm:baseVersionId", properties.get("ecm:baseVersionId"));
                props.put("ecm:isCheckedIn", DBSSession.trueOrNull(properties.get("ecm:isCheckedIn")));
            }
            docState = this.createChildState(id, parentId, name, pos, typeName);
        }
        for (Map.Entry entry : props.entrySet()) {
            docState.put((String)entry.getKey(), (Serializable)entry.getValue());
        }
        return this.getDocument(docState, false);
    }

    protected static Boolean trueOrNull(Object value) {
        return Boolean.TRUE.equals(value) ? Boolean.TRUE : null;
    }

    public Document getVersion(String versionSeriesId, VersionModel versionModel) {
        DBSDocumentState docState = this.getVersionByLabel(versionSeriesId, versionModel.getLabel());
        if (docState == null) {
            return null;
        }
        versionModel.setDescription((String)((Object)docState.get("ecm:versionDescription")));
        versionModel.setCreated((Calendar)docState.get("ecm:versionCreated"));
        return this.getDocument(docState);
    }

    protected DBSDocumentState getVersionByLabel(String versionSeriesId, String label) {
        List<DBSDocumentState> docStates = this.transaction.getKeyValuedStates("ecm:versionSeriesId", versionSeriesId, "ecm:isVersion", Boolean.TRUE);
        for (DBSDocumentState docState : docStates) {
            if (!label.equals(docState.get("ecm:versionLabel"))) continue;
            return docState;
        }
        return null;
    }

    protected List<String> getVersionsIds(String versionSeriesId) {
        List<DBSDocumentState> docStates = this.transaction.getKeyValuedStates("ecm:versionSeriesId", versionSeriesId, "ecm:isVersion", Boolean.TRUE);
        docStates.sort(VERSION_CREATED_COMPARATOR);
        ArrayList<String> ids = new ArrayList<String>(docStates.size());
        for (DBSDocumentState docState : docStates) {
            ids.add(docState.getId());
        }
        return ids;
    }

    protected Document getLastVersion(String versionSeriesId) {
        List<DBSDocumentState> docStates = this.transaction.getKeyValuedStates("ecm:versionSeriesId", versionSeriesId, "ecm:isVersion", Boolean.TRUE);
        Calendar latest = null;
        DBSDocumentState latestState = null;
        for (DBSDocumentState docState : docStates) {
            Calendar created = (Calendar)docState.get("ecm:versionCreated");
            if (latest != null && created.compareTo(latest) <= 0) continue;
            latest = created;
            latestState = docState;
        }
        return latestState == null ? null : this.getDocument(latestState);
    }

    public void updateReadACLs(Collection<String> docIds) {
        this.transaction.updateReadACLs(docIds);
    }

    public boolean isNegativeAclAllowed() {
        return false;
    }

    public ACP getMergedACP(Document doc) {
        Document base;
        Document document = base = doc.isVersion() ? doc.getSourceDocument() : doc;
        if (base == null) {
            return null;
        }
        ACP acp = this.getACP(base);
        if (doc.getParent() == null) {
            return acp;
        }
        ACL acl = null;
        if (acp == null || acp.getAccess("Everyone", "Everything") != Access.DENY) {
            acl = this.getInheritedACLs(doc);
        }
        if (acp == null) {
            if (acl == null) {
                return null;
            }
            acp = new ACPImpl();
        }
        if (acl != null) {
            acp.addACL(acl);
        }
        return acp;
    }

    protected ACL getInheritedACLs(Document doc) {
        ACL merged = null;
        for (doc = doc.getParent(); doc != null; doc = doc.getParent()) {
            ACP acp = this.getACP(doc);
            if (acp == null) continue;
            ACL acl = acp.getMergedACLs("inherited");
            if (merged == null) {
                merged = acl;
            } else {
                merged.addAll((Collection)acl);
            }
            if (acp.getAccess("Everyone", "Everything") == Access.DENY) break;
        }
        return merged;
    }

    protected ACP getACP(Document doc) {
        State state = this.transaction.getStateForRead(doc.getUUID());
        return DBSSession.memToAcp(state.get((Object)"ecm:acp"));
    }

    public void setACP(Document doc, ACP acp, boolean overwrite) {
        this.checkNegativeAcl(acp);
        if (!overwrite) {
            if (acp == null) {
                return;
            }
            acp = DBSSession.updateACP(this.getACP(doc), acp);
        }
        String id = doc.getUUID();
        DBSDocumentState docState = this.transaction.getStateForUpdate(id);
        docState.put("ecm:acp", DBSSession.acpToMem(acp));
        this.transaction.updateTreeReadAcls(id);
    }

    protected void checkNegativeAcl(ACP acp) {
        if (acp == null) {
            return;
        }
        for (ACL acl : acp.getACLs()) {
            if (acl.getName().equals("inherited")) continue;
            for (ACE ace : acl.getACEs()) {
                String permission;
                if (ace.isGranted() || (permission = ace.getPermission()).equals("Everything") && ace.getUsername().equals("Everyone") || permission.equals("Write")) continue;
                throw new IllegalArgumentException("Negative ACL not allowed: " + ace);
            }
        }
    }

    protected static ACP updateACP(ACP curAcp, ACP addAcp) {
        String name;
        if (curAcp == null) {
            return addAcp;
        }
        ACP newAcp = curAcp.clone();
        HashMap<String, ACL> acls = new HashMap<String, ACL>();
        for (ACL acl : newAcp.getACLs()) {
            name = acl.getName();
            if ("inherited".equals(name)) {
                throw new IllegalStateException(curAcp.toString());
            }
            acls.put(name, acl);
        }
        for (ACL acl : addAcp.getACLs()) {
            name = acl.getName();
            if ("inherited".equals(name)) continue;
            ACL curAcl = (ACL)acls.get(name);
            if (curAcl != null) {
                curAcl.addAll((Collection)acl);
                continue;
            }
            newAcp.addACL(acl);
        }
        return newAcp;
    }

    public static Serializable acpToMem(ACP acp) {
        if (acp == null) {
            return null;
        }
        ACL[] acls = acp.getACLs();
        if (acls.length == 0) {
            return null;
        }
        ArrayList<State> aclList = new ArrayList<State>(acls.length);
        for (ACL acl : acls) {
            String name = acl.getName();
            if (name.equals("inherited")) continue;
            ACE[] aces = acl.getACEs();
            ArrayList<State> aceList = new ArrayList<State>(aces.length);
            for (ACE ace : aces) {
                Long status;
                Calendar end;
                Calendar begin;
                State aceMap = new State(6);
                aceMap.put("user", (Serializable)((Object)ace.getUsername()));
                aceMap.put("perm", (Serializable)((Object)ace.getPermission()));
                aceMap.put("grant", (Serializable)Boolean.valueOf(ace.isGranted()));
                String creator = ace.getCreator();
                if (creator != null) {
                    aceMap.put("creator", (Serializable)((Object)creator));
                }
                if ((begin = ace.getBegin()) != null) {
                    aceMap.put("begin", (Serializable)begin);
                }
                if ((end = ace.getEnd()) != null) {
                    aceMap.put("end", (Serializable)end);
                }
                if ((status = ace.getLongStatus()) != null) {
                    aceMap.put("status", (Serializable)status);
                }
                aceList.add(aceMap);
            }
            if (aceList.isEmpty()) continue;
            State aclMap = new State(2);
            aclMap.put("name", (Serializable)((Object)name));
            aclMap.put("acl", (Serializable)aceList);
            aclList.add(aclMap);
        }
        return aclList;
    }

    protected static ACP memToAcp(Serializable acpSer) {
        if (acpSer == null) {
            return null;
        }
        List aclList = (List)((Object)acpSer);
        ACPImpl acp = new ACPImpl();
        for (Serializable aclSer : aclList) {
            State aclMap = (State)aclSer;
            String name = (String)((Object)aclMap.get((Object)"name"));
            List aceList = (List)((Object)aclMap.get((Object)"acl"));
            if (aceList == null) continue;
            ACLImpl acl = new ACLImpl(name);
            for (Serializable aceSer : aceList) {
                State aceMap = (State)aceSer;
                String username = (String)((Object)aceMap.get((Object)"user"));
                String permission = (String)((Object)aceMap.get((Object)"perm"));
                boolean granted = (Boolean)aceMap.get((Object)"grant");
                String creator = (String)((Object)aceMap.get((Object)"creator"));
                Calendar begin = (Calendar)aceMap.get((Object)"begin");
                Calendar end = (Calendar)aceMap.get((Object)"end");
                ACE ace = ACE.builder((String)username, (String)permission).isGranted(granted).creator(creator).begin(begin).end(end).build();
                acl.add(ace);
            }
            acp.addACL((ACL)acl);
        }
        return acp;
    }

    public boolean isFulltextStoredInBlob() {
        return this.fulltextStoredInBlob;
    }

    public Map<String, String> getBinaryFulltext(String id) {
        State state = this.transaction.getStateForRead(id);
        String fulltext = (String)((Object)state.get((Object)"ecm:fulltextBinary"));
        if (this.fulltextStoredInBlob && fulltext != null) {
            DocumentBlobManager blobManager = (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
            try {
                BlobInfo blobInfo = new BlobInfo();
                blobInfo.key = fulltext;
                Blob blob = blobManager.readBlob(blobInfo, this.getRepositoryName());
                fulltext = blob.getString();
            }
            catch (IOException e) {
                throw new PropertyException("Cannot read fulltext blob for doc: " + id, (Throwable)e);
            }
        }
        return Collections.singletonMap("binarytext", fulltext);
    }

    public void removeDocument(String id) {
        this.transaction.save();
        DBSDocumentState docState = this.transaction.getStateForUpdate(id);
        Calendar retainUntil = (Calendar)docState.get("ecm:retainUntil");
        if (retainUntil != null && Calendar.getInstance().before(retainUntil)) {
            throw new DocumentExistsException("Cannot remove " + id + ", it is under retention / hold");
        }
        if (Boolean.TRUE.equals(docState.get("ecm:hasLegalHold"))) {
            throw new DocumentExistsException("Cannot remove " + id + ", it is under retention / hold");
        }
        if (Boolean.TRUE.equals(docState.get("ecm:isRetentionActive"))) {
            throw new DocumentExistsException("Cannot remove " + id + ", it is under active retention");
        }
        try {
            DBSDocument doc = this.getDocument(docState);
            this.getDocumentBlobManager().notifyBeforeRemove((Document)doc);
        }
        catch (DocumentNotFoundException documentNotFoundException) {
            // empty catch block
        }
        this.transaction.removeStates(Collections.singleton(id));
    }

    public PartialList<Document> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) {
        PartialList<String> pl = this.doQuery(query, queryType, queryFilter, (int)countUpTo);
        List<Document> docs = this.getDocuments((List<String>)pl);
        return new PartialList(docs, pl.totalSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PartialList<String> doQuery(String query, String queryType, QueryFilter queryFilter, int countUpTo) {
        Iterator iterator;
        Timer.Context timerContext = this.queryTimer.time();
        try {
            MutableObject idKeyHolder = new MutableObject();
            PartialList<Map<String, Serializable>> pl = this.doQueryAndFetch(query, queryType, queryFilter, false, countUpTo, (Mutable<String>)idKeyHolder);
            String idKey = (String)idKeyHolder.getValue();
            ArrayList<String> ids = new ArrayList<String>(pl.size());
            for (Map map : pl) {
                String id = (String)map.get(idKey);
                ids.add(id);
            }
            iterator = new PartialList(ids, pl.totalSize());
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (this.LOG_MIN_DURATION_NS >= 0L && duration > this.LOG_MIN_DURATION_NS) {
                String msg = String.format("duration_ms:\t%.2f\t%s %s\tquery\t%s", (double)duration / 1000000.0, queryFilter, this.countUpToAsString(countUpTo), query);
                if (log.isTraceEnabled()) {
                    log.info((Object)msg, new Throwable("Slow query stack trace"));
                } else {
                    log.info((Object)msg);
                }
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (this.LOG_MIN_DURATION_NS >= 0L && duration > this.LOG_MIN_DURATION_NS) {
            String msg = String.format("duration_ms:\t%.2f\t%s %s\tquery\t%s", (double)duration / 1000000.0, queryFilter, this.countUpToAsString(countUpTo), query);
            if (log.isTraceEnabled()) {
                log.info((Object)msg, new Throwable("Slow query stack trace"));
            } else {
                log.info((Object)msg);
            }
        }
        return iterator;
    }

    protected PartialList<Map<String, Serializable>> doQueryAndFetch(String query, String queryType, QueryFilter queryFilter, boolean distinctDocuments, int countUpTo, Mutable<String> idKeyHolder) {
        OrderByClause repoOrderByClause;
        int repoOffset;
        int repoLimit;
        OrderByClause orderByClause;
        boolean postFilter;
        boolean selectStar;
        if ("NXTAG".equals(queryType)) {
            return new PartialList(Collections.emptyList(), 0L);
        }
        if (!"NXQL".equals(queryType)) {
            throw new NuxeoException("No QueryMaker accepts query type: " + queryType);
        }
        SQLQuery sqlQuery = SQLQueryParser.parse((String)query);
        for (SQLQuery.Transformer transformer : queryFilter.getQueryTransformers()) {
            sqlQuery = transformer.transform(queryFilter.getPrincipal(), sqlQuery);
        }
        SelectClause selectClause = sqlQuery.select;
        if (selectClause.isEmpty()) {
            selectClause.add((Operand)new Reference("ecm:uuid"));
        }
        boolean bl = selectStar = selectClause.count() == 1 && selectClause.containsOperand((Object)new Reference("ecm:uuid"));
        if (selectStar) {
            distinctDocuments = true;
        } else if (selectClause.isDistinct()) {
            throw new QueryParseException("SELECT DISTINCT not supported on DBS");
        }
        if (idKeyHolder != null) {
            Operand operand = (Operand)selectClause.operands().iterator().next();
            String idKey = operand instanceof Reference ? ((Reference)operand).name : "ecm:uuid";
            idKeyHolder.setValue((Object)idKey);
        }
        String ecmTag = selectClause.elements.keySet().stream().filter(k -> k.startsWith("ecm:tag")).findFirst().orElse(null);
        String keyTag = null;
        if (ecmTag != null) {
            keyTag = "nxtag:tags/*1/label";
            selectClause.elements.replace((Object)ecmTag, (Object)new Reference(keyTag));
        }
        selectClause.elements.putIfAbsent((Object)"ecm:uuid", (Object)new Reference("ecm:uuid"));
        selectClause.elements.putIfAbsent((Object)"ecm:parentId", (Object)new Reference("ecm:parentId"));
        selectClause.elements.putIfAbsent((Object)"ecm:name", (Object)new Reference("ecm:name"));
        QueryOptimizer optimizer = new DBSQueryOptimizer().withFacetFilter(queryFilter.getFacetFilter());
        sqlQuery = optimizer.optimize(sqlQuery);
        DBSExpressionEvaluator evaluator = new DBSExpressionEvaluator(this, sqlQuery, queryFilter.getPrincipals(), this.fulltextSearchDisabled);
        int limit = (int)queryFilter.getLimit();
        int offset = (int)queryFilter.getOffset();
        if (offset < 0) {
            offset = 0;
        }
        if (limit < 0) {
            limit = 0;
        }
        if (postFilter = this.isOrderByPath(orderByClause = sqlQuery.orderBy)) {
            repoLimit = 0;
            repoOffset = 0;
            repoOrderByClause = null;
        } else {
            repoLimit = limit;
            repoOffset = offset;
            repoOrderByClause = orderByClause;
        }
        PartialList projections = this.transaction.queryAndFetch(evaluator, repoOrderByClause, distinctDocuments, repoLimit, repoOffset, countUpTo);
        for (Map proj : projections) {
            if (!proj.containsKey(keyTag)) continue;
            proj.put(ecmTag, (Serializable)proj.remove(keyTag));
        }
        if (postFilter) {
            if (orderByClause != null) {
                this.doOrderBy((List<Map<String, Serializable>>)projections, orderByClause);
            }
            if (limit != 0) {
                int size = projections.size();
                int fromIndex = offset > size ? size : offset;
                int toIndex = fromIndex + limit > size ? size : fromIndex + limit;
                projections = projections.subList(fromIndex, toIndex);
            }
        }
        return projections;
    }

    protected boolean isOrderByPath(OrderByClause orderByClause) {
        if (orderByClause == null) {
            return false;
        }
        for (OrderByExpr ob : orderByClause.elements) {
            if (!ob.reference.name.equals("ecm:path")) continue;
            return true;
        }
        return false;
    }

    protected String getPath(Map<String, Serializable> projection) {
        State state;
        String name = (String)((Object)projection.get("ecm:name"));
        String parentId = (String)((Object)projection.get("ecm:parentId"));
        if (parentId == null || (state = this.transaction.getStateForRead(parentId)) == null) {
            if ("".equals(name)) {
                return "/";
            }
            return name;
        }
        LinkedList<String> list = new LinkedList<String>();
        list.addFirst(name);
        do {
            name = (String)((Object)state.get((Object)"ecm:name"));
            parentId = (String)((Object)state.get((Object)"ecm:parentId"));
            list.addFirst(name);
        } while (parentId != null && (state = this.transaction.getStateForRead(parentId)) != null);
        return StringUtils.join(list, (char)'/');
    }

    protected void doOrderBy(List<Map<String, Serializable>> projections, OrderByClause orderByClause) {
        if (this.isOrderByPath(orderByClause)) {
            for (Map<String, Serializable> projection : projections) {
                projection.put("ecm:__path", (Serializable)((Object)this.getPath(projection)));
            }
        }
        projections.sort(new OrderByComparator(orderByClause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, boolean distinctDocuments, Object[] params) {
        DBSQueryResult dBSQueryResult;
        Timer.Context timerContext = this.queryTimer.time();
        try {
            PartialList<Map<String, Serializable>> pl = this.doQueryAndFetch(query, queryType, queryFilter, distinctDocuments, -1, null);
            dBSQueryResult = new DBSQueryResult(pl);
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (this.LOG_MIN_DURATION_NS >= 0L && duration > this.LOG_MIN_DURATION_NS) {
                String msg = String.format("duration_ms:\t%.2f\t%s\tqueryAndFetch\t%s", (double)duration / 1000000.0, queryFilter, query);
                if (log.isTraceEnabled()) {
                    log.info((Object)msg, new Throwable("Slow query stack trace"));
                } else {
                    log.info((Object)msg);
                }
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (this.LOG_MIN_DURATION_NS >= 0L && duration > this.LOG_MIN_DURATION_NS) {
            String msg = String.format("duration_ms:\t%.2f\t%s\tqueryAndFetch\t%s", (double)duration / 1000000.0, queryFilter, query);
            if (log.isTraceEnabled()) {
                log.info((Object)msg, new Throwable("Slow query stack trace"));
            } else {
                log.info((Object)msg);
            }
        }
        return dBSQueryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartialList<Map<String, Serializable>> queryProjection(String query, String queryType, QueryFilter queryFilter, boolean distinctDocuments, long countUpTo, Object[] params) {
        PartialList<Map<String, Serializable>> partialList;
        Timer.Context timerContext = this.queryTimer.time();
        try {
            partialList = this.doQueryAndFetch(query, queryType, queryFilter, distinctDocuments, (int)countUpTo, null);
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (this.LOG_MIN_DURATION_NS >= 0L && duration > this.LOG_MIN_DURATION_NS) {
                String msg = String.format("duration_ms:\t%.2f\t%s\tqueryProjection\t%s", (double)duration / 1000000.0, queryFilter, query);
                if (log.isTraceEnabled()) {
                    log.info((Object)msg, new Throwable("Slow query stack trace"));
                } else {
                    log.info((Object)msg);
                }
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (this.LOG_MIN_DURATION_NS >= 0L && duration > this.LOG_MIN_DURATION_NS) {
            String msg = String.format("duration_ms:\t%.2f\t%s\tqueryProjection\t%s", (double)duration / 1000000.0, queryFilter, query);
            if (log.isTraceEnabled()) {
                log.info((Object)msg, new Throwable("Slow query stack trace"));
            } else {
                log.info((Object)msg);
            }
        }
        return partialList;
    }

    public ScrollResult<String> scroll(String query, int batchSize, int keepAliveSeconds) {
        SQLQuery sqlQuery = SQLQueryParser.parse((String)query);
        SelectClause selectClause = sqlQuery.select;
        selectClause.add((Operand)new Reference("ecm:uuid"));
        sqlQuery = new DBSQueryOptimizer().optimize(sqlQuery);
        DBSExpressionEvaluator evaluator = new DBSExpressionEvaluator(this, sqlQuery, null, this.fulltextSearchDisabled);
        return this.transaction.scroll(evaluator, batchSize, keepAliveSeconds);
    }

    public ScrollResult<String> scroll(String query, QueryFilter queryFilter, int batchSize, int keepAliveSeconds) {
        SQLQuery sqlQuery = SQLQueryParser.parse((String)query);
        SelectClause selectClause = sqlQuery.select;
        selectClause.add((Operand)new Reference("ecm:uuid"));
        sqlQuery = new DBSQueryOptimizer().optimize(sqlQuery);
        for (SQLQuery.Transformer transformer : queryFilter.getQueryTransformers()) {
            sqlQuery = transformer.transform(queryFilter.getPrincipal(), sqlQuery);
        }
        DBSExpressionEvaluator evaluator = new DBSExpressionEvaluator(this, sqlQuery, queryFilter.getPrincipals(), this.fulltextSearchDisabled);
        return this.transaction.scroll(evaluator, batchSize, keepAliveSeconds);
    }

    public ScrollResult<String> scroll(String scrollId) {
        return this.transaction.scroll(scrollId);
    }

    private String countUpToAsString(long countUpTo) {
        if (countUpTo > 0L) {
            return String.format("count total results up to %d", countUpTo);
        }
        return countUpTo == -1L ? "count total results UNLIMITED" : "";
    }

    public static String convToInternal(String name) {
        switch (name) {
            case "ecm:uuid": {
                return "ecm:id";
            }
            case "ecm:name": {
                return "ecm:name";
            }
            case "ecm:pos": {
                return "ecm:pos";
            }
            case "ecm:parentId": {
                return "ecm:parentId";
            }
            case "ecm:mixinType": {
                return "ecm:mixinTypes";
            }
            case "ecm:primaryType": {
                return "ecm:primaryType";
            }
            case "ecm:isProxy": {
                return "ecm:isProxy";
            }
            case "ecm:isVersion": 
            case "ecm:isCheckedInVersion": {
                return "ecm:isVersion";
            }
            case "ecm:currentLifeCycleState": {
                return "ecm:lifeCycleState";
            }
            case "ecm:lockOwner": {
                return "ecm:lockOwner";
            }
            case "ecm:lockCreated": {
                return "ecm:lockCreated";
            }
            case "ecm:proxyTargetId": {
                return "ecm:proxyTargetId";
            }
            case "ecm:proxyVersionableId": {
                return "ecm:proxyVersionSeriesId";
            }
            case "ecm:isCheckedIn": {
                return "ecm:isCheckedIn";
            }
            case "ecm:isLatestVersion": {
                return "ecm:isLatestVersion";
            }
            case "ecm:isLatestMajorVersion": {
                return "ecm:isLatestMajorVersion";
            }
            case "ecm:versionLabel": {
                return "ecm:versionLabel";
            }
            case "ecm:versionCreated": {
                return "ecm:versionCreated";
            }
            case "ecm:versionDescription": {
                return "ecm:versionDescription";
            }
            case "ecm:versionVersionableId": {
                return "ecm:versionSeriesId";
            }
            case "ecm:isRecord": {
                return "ecm:isRecord";
            }
            case "ecm:retainUntil": {
                return "ecm:retainUntil";
            }
            case "ecm:hasLegalHold": {
                return "ecm:hasLegalHold";
            }
            case "ecm:ancestorId": 
            case "ecm:__ancestorIds": {
                return "ecm:ancestorIds";
            }
            case "ecm:__path": {
                return "ecm:__path";
            }
            case "ecm:__read_acl": {
                return "ecm:racl";
            }
            case "ecm:fulltextJobId": {
                return "ecm:fulltextJobId";
            }
            case "ecm:fulltextScore": {
                return "ecm:fulltextScore";
            }
            case "ecm:__fulltextSimple": {
                return "ecm:fulltextSimple";
            }
            case "ecm:__fulltextBinary": {
                return "ecm:fulltextBinary";
            }
            case "ecm:acl": {
                return "ecm:acp";
            }
            case "uid:major_version": 
            case "major_version": {
                return "ecm:majorVersion";
            }
            case "uid:minor_version": 
            case "minor_version": {
                return "ecm:minorVersion";
            }
            case "ecm:isTrashed": {
                return "ecm:isTrashed";
            }
            case "ecm:fulltext": {
                throw new UnsupportedOperationException(name);
            }
        }
        throw new QueryParseException("No such property: " + name);
    }

    public static String convToInternalAce(String name) {
        switch (name) {
            case "name": {
                return "name";
            }
            case "principal": {
                return "user";
            }
            case "permission": {
                return "perm";
            }
            case "grant": {
                return "grant";
            }
            case "creator": {
                return "creator";
            }
            case "begin": {
                return "begin";
            }
            case "end": {
                return "end";
            }
            case "status": {
                return "status";
            }
        }
        return null;
    }

    public static String convToNXQL(String name) {
        switch (name) {
            case "ecm:id": {
                return "ecm:uuid";
            }
            case "ecm:name": {
                return "ecm:name";
            }
            case "ecm:pos": {
                return "ecm:pos";
            }
            case "ecm:parentId": {
                return "ecm:parentId";
            }
            case "ecm:mixinTypes": {
                return "ecm:mixinType";
            }
            case "ecm:primaryType": {
                return "ecm:primaryType";
            }
            case "ecm:isProxy": {
                return "ecm:isProxy";
            }
            case "ecm:isVersion": {
                return "ecm:isVersion";
            }
            case "ecm:lifeCycleState": {
                return "ecm:currentLifeCycleState";
            }
            case "ecm:lockOwner": {
                return "ecm:lockOwner";
            }
            case "ecm:lockCreated": {
                return "ecm:lockCreated";
            }
            case "ecm:proxyTargetId": {
                return "ecm:proxyTargetId";
            }
            case "ecm:proxyVersionSeriesId": {
                return "ecm:proxyVersionableId";
            }
            case "ecm:isCheckedIn": {
                return "ecm:isCheckedIn";
            }
            case "ecm:isLatestVersion": {
                return "ecm:isLatestVersion";
            }
            case "ecm:isLatestMajorVersion": {
                return "ecm:isLatestMajorVersion";
            }
            case "ecm:versionLabel": {
                return "ecm:versionLabel";
            }
            case "ecm:versionCreated": {
                return "ecm:versionCreated";
            }
            case "ecm:versionDescription": {
                return "ecm:versionDescription";
            }
            case "ecm:versionSeriesId": {
                return "ecm:versionVersionableId";
            }
            case "ecm:isRecord": {
                return "ecm:isRecord";
            }
            case "ecm:retainUntil": {
                return "ecm:retainUntil";
            }
            case "ecm:hasLegalHold": {
                return "ecm:hasLegalHold";
            }
            case "ecm:majorVersion": {
                return "major_version";
            }
            case "ecm:minorVersion": {
                return "minor_version";
            }
            case "ecm:fulltextScore": {
                return "ecm:fulltextScore";
            }
            case "ecm:isTrashed": {
                return "ecm:isTrashed";
            }
            case "ecm:lifeCyclePolicy": 
            case "ecm:acp": 
            case "ecm:ancestorIds": 
            case "ecm:baseVersionId": 
            case "ecm:racl": 
            case "ecm:fulltextSimple": 
            case "ecm:fulltextBinary": 
            case "ecm:fulltextJobId": 
            case "ecm:__path": {
                return null;
            }
        }
        throw new QueryParseException("No such property: " + name);
    }

    public static Type getType(String name) {
        switch (name) {
            case "ecm:isVersion": 
            case "ecm:isCheckedIn": 
            case "ecm:isLatestVersion": 
            case "ecm:isLatestMajorVersion": 
            case "ecm:isProxy": 
            case "grant": 
            case "ecm:isTrashed": 
            case "ecm:isRecord": 
            case "ecm:hasLegalHold": {
                return BooleanType.INSTANCE;
            }
            case "ecm:versionCreated": 
            case "ecm:lockCreated": 
            case "begin": 
            case "end": 
            case "ecm:retainUntil": {
                return DateType.INSTANCE;
            }
            case "ecm:mixinTypes": 
            case "ecm:ancestorIds": 
            case "ecm:proxyIds": 
            case "ecm:racl": {
                return STRING_ARRAY_TYPE;
            }
        }
        return null;
    }

    public LockManager getLockManager() {
        return this.repository.getLockManager();
    }

    public void markUserChange(String id) {
        if (this.changeTokenEnabled) {
            this.transaction.markUserChange(id);
        }
    }

    protected static class DBSQueryResult
    implements IterableQueryResult,
    Iterator<Map<String, Serializable>> {
        boolean closed;
        protected List<Map<String, Serializable>> maps;
        protected long totalSize;
        protected long pos;

        protected DBSQueryResult(PartialList<Map<String, Serializable>> pl) {
            this.maps = pl;
            this.totalSize = pl.totalSize();
        }

        public Iterator<Map<String, Serializable>> iterator() {
            return this;
        }

        public void close() {
            this.closed = true;
            this.pos = -1L;
        }

        public boolean isLife() {
            return !this.closed;
        }

        public boolean mustBeClosed() {
            return false;
        }

        public long size() {
            return this.totalSize;
        }

        public long pos() {
            return this.pos;
        }

        public void skipTo(long pos) {
            if (pos < 0L) {
                pos = 0L;
            } else if (pos > this.totalSize) {
                pos = this.totalSize;
            }
            this.pos = pos;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.totalSize;
        }

        @Override
        public Map<String, Serializable> next() {
            if (this.closed || this.pos == this.totalSize) {
                throw new NoSuchElementException();
            }
            Map<String, Serializable> map = this.maps.get((int)this.pos);
            ++this.pos;
            return map;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class OrderByComparator
    implements Comparator<Map<String, Serializable>> {
        protected final OrderByClause orderByClause;

        public OrderByComparator(OrderByClause orderByClause) {
            OrderByList obl = new OrderByList();
            for (OrderByExpr ob : orderByClause.elements) {
                if (ob.reference.name.equals("ecm:path")) {
                    ob = new OrderByExpr(new Reference("ecm:__path"), ob.isDescending);
                }
                obl.add((Object)ob);
            }
            this.orderByClause = new OrderByClause(obl);
        }

        @Override
        public int compare(Map<String, Serializable> map1, Map<String, Serializable> map2) {
            for (OrderByExpr ob : this.orderByClause.elements) {
                int cmp;
                Reference ref = ob.reference;
                boolean desc = ob.isDescending;
                Serializable v1 = map1.get(ref.name);
                Serializable v2 = map2.get(ref.name);
                if (v1 == null) {
                    cmp = v2 == null ? 0 : -1;
                } else if (v2 == null) {
                    cmp = 1;
                } else {
                    if (!(v1 instanceof Comparable)) {
                        throw new QueryParseException("Not a comparable: " + v1);
                    }
                    cmp = ((Comparable)((Object)v1)).compareTo(v2);
                }
                if (desc) {
                    cmp = -cmp;
                }
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

