/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.api;

import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.blob.ManagedBlob;

public class ConversionException
extends NuxeoException {
    private static final long serialVersionUID = 1L;

    public ConversionException() {
    }

    public ConversionException(String message) {
        super(message);
    }

    public ConversionException(String message, Throwable cause) {
        super(message, cause);
    }

    public ConversionException(Throwable cause) {
        super(cause);
    }

    public ConversionException(String message, BlobHolder blobHolder) {
        super(message);
        this.addInfos(blobHolder);
    }

    public ConversionException(String message, BlobHolder blobHolder, Throwable cause) {
        super(message, cause);
        this.addInfos(blobHolder);
    }

    public ConversionException(BlobHolder blobHolder, Throwable cause) {
        super(cause);
        this.addInfos(blobHolder);
    }

    public ConversionException(String message, Blob blob, Throwable cause) {
        super(message, cause);
        this.addInfo(blob);
    }

    public ConversionException(String message, Blob blob) {
        super(message);
        this.addInfo(blob);
    }

    protected void addInfos(BlobHolder blobHolder) {
        List blobs;
        if (blobHolder instanceof DocumentBlobHolder) {
            DocumentBlobHolder documentBlobHolder = (DocumentBlobHolder)blobHolder;
            this.addInfo(String.format("Document: %s", documentBlobHolder.getDocument()));
        }
        if ((blobs = blobHolder.getBlobs()) != null) {
            blobs.forEach(this::addInfo);
        }
    }

    protected void addInfo(Blob blob) {
        if (blob instanceof ManagedBlob) {
            ManagedBlob managedBlob = (ManagedBlob)blob;
            this.addInfo(String.format("Blob Key/Provider: %s/%s", managedBlob.getKey(), managedBlob.getProviderId()));
        }
    }
}

