/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.AbstractBlobProvider;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobUpdateContext;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.KeyStrategyDigest;
import org.nuxeo.ecm.core.blob.KeyStrategyDocId;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.runtime.api.Framework;

public abstract class BlobStoreBlobProvider
extends AbstractBlobProvider {
    public BlobStore store;

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        this.store = this.getBlobStore(blobProviderId, properties);
    }

    protected abstract BlobStore getBlobStore(String var1, Map<String, String> var2) throws IOException;

    protected KeyStrategy getKeyStrategy() {
        boolean hasDigest = this.properties.get("digest") != null;
        KeyStrategy keyStrategy = this.isRecordMode() && !hasDigest ? KeyStrategyDocId.instance() : new KeyStrategyDigest(this.getDigestAlgorithm());
        return keyStrategy;
    }

    protected abstract String getDigestAlgorithm();

    @Override
    public BinaryManager getBinaryManager() {
        return null;
    }

    @Override
    public boolean supportsSync() {
        return this.supportsUserUpdate();
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.store.getBinaryGarbageCollector();
    }

    protected String stripBlobKeyPrefix(String key) {
        int colon = key.indexOf(58);
        if (colon >= 0 && key.substring(0, colon).equals(this.blobProviderId)) {
            key = key.substring(colon + 1);
        }
        return key;
    }

    @Override
    public String writeBlob(BlobContext blobContext) throws IOException {
        return this.store.writeBlob(blobContext);
    }

    @Override
    public String writeBlob(Blob blob) throws IOException {
        if (this.isRecordMode()) {
            throw new UnsupportedOperationException("Cannot write blob directly without context in record mode");
        }
        return this.writeBlob(new BlobContext(blob));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getStream(ManagedBlob blob) throws IOException {
        String key = this.stripBlobKeyPrefix(blob.getKey());
        BlobStore.OptionalOrUnknown<InputStream> streamOpt = this.store.getStream(key);
        if (streamOpt.isKnown()) {
            if (!streamOpt.isPresent()) {
                throw new IOException("Missing blob: " + blob.getKey());
            }
            return streamOpt.get();
        }
        boolean returned = false;
        Path tmp = Framework.createTempFilePath((String)"bin_", (String)".tmp", (FileAttribute[])new FileAttribute[0]);
        try {
            boolean found = this.store.readBlob(key, tmp);
            if (!found) {
                throw new IOException("Missing blob: " + blob.getKey());
            }
            AutoDeleteFileInputStream stream = new AutoDeleteFileInputStream(tmp);
            returned = true;
            AutoDeleteFileInputStream autoDeleteFileInputStream = stream;
            return autoDeleteFileInputStream;
        }
        finally {
            if (!returned) {
                Files.deleteIfExists(tmp);
            }
        }
    }

    @Override
    public File getFile(ManagedBlob blob) {
        String key = this.stripBlobKeyPrefix(blob.getKey());
        BlobStore.OptionalOrUnknown<Path> fileOpt = this.store.getFile(key);
        return fileOpt.isPresent() ? fileOpt.get().toFile() : null;
    }

    @Override
    public Blob readBlob(BlobInfo blobInfo) throws IOException {
        return new SimpleManagedBlob(this.blobProviderId, blobInfo);
    }

    @Override
    public void updateBlob(BlobUpdateContext blobUpdateContext) throws IOException {
        this.store.writeBlobProperties(blobUpdateContext);
    }

    @Override
    public void deleteBlob(BlobContext blobContext) {
        this.store.deleteBlob(blobContext);
    }

    public static class AutoDeleteFileInputStream
    extends FileInputStream {
        private static final Logger log = LogManager.getLogger(AutoDeleteFileInputStream.class);
        protected Path file;

        public AutoDeleteFileInputStream(Path file) throws IOException {
            super(file.toFile());
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (this.file != null) {
                    try {
                        Files.deleteIfExists(this.file);
                    }
                    catch (IOException e) {
                        log.warn((Object)e, (Throwable)e);
                    }
                    this.file = null;
                }
            }
        }
    }
}

