/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.runtime.api.Framework;

public class SimpleManagedBlob
extends AbstractBlob
implements ManagedBlob {
    private static final long serialVersionUID = 1L;
    public final String blobProviderId;
    public final String key;
    public Long length;

    public SimpleManagedBlob(String blobProviderId, BlobInfo blobInfo) {
        this.blobProviderId = blobProviderId;
        this.key = blobInfo.key;
        this.setMimeType(blobInfo.mimeType);
        this.setEncoding(blobInfo.encoding);
        this.setFilename(blobInfo.filename);
        this.setDigest(blobInfo.digest);
        this.length = blobInfo.length;
    }

    public SimpleManagedBlob(BlobInfo blobInfo) {
        this(SimpleManagedBlob.blobProviderIdFromKey(blobInfo.key), blobInfo);
    }

    @Override
    public String getProviderId() {
        return this.blobProviderId;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    protected static String blobProviderIdFromKey(String key) {
        int colon = key.indexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException("Invalid managed blob key: " + key);
        }
        return key.substring(0, colon);
    }

    @Override
    public InputStream getStream() throws IOException {
        return ((BlobManager)Framework.getService(BlobManager.class)).getStream(this);
    }

    @Override
    public File getFile() {
        return ((BlobManager)Framework.getService(BlobManager.class)).getFile(this);
    }

    @Override
    public long getLength() {
        return this.length == null ? -1L : this.length;
    }
}

