/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.AbstractBlobStore;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobUpdateContext;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TransactionalBlobStore
extends AbstractBlobStore
implements Synchronization {
    private static final Logger log = LogManager.getLogger(TransactionalBlobStore.class);
    public final BlobStore store;
    public final BlobStore transientStore;
    protected final ThreadLocal<Map<String, TransientInfo>> transientInfo = new ThreadLocal();
    protected final Map<String, Transaction> keysInActiveTransactions = new ConcurrentHashMap<String, Transaction>();
    protected static final String DELETE_MARKER = "";

    protected static boolean isDeleteMarker(String transientKey) {
        return DELETE_MARKER.equals(transientKey);
    }

    public TransactionalBlobStore(BlobStore store, BlobStore transientStore) {
        super("tx", store.getKeyStrategy());
        this.store = store;
        this.transientStore = transientStore;
        if (store.hasVersioning() && transientStore != store) {
            throw new NuxeoException("If the store has versioning then it must be also the transient store");
        }
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.store.getBinaryGarbageCollector();
    }

    @Override
    public boolean hasVersioning() {
        return this.store.hasVersioning();
    }

    @Override
    public BlobStore unwrap() {
        return this.store.unwrap();
    }

    @Override
    public String writeBlob(BlobWriteContext blobWriteContext) throws IOException {
        if (TransactionHelper.isTransactionActive()) {
            String key;
            String transientKey;
            this.logTrace("group tx write");
            if (this.hasVersioning()) {
                key = transientKey = this.transientStore.writeBlob(blobWriteContext);
            } else {
                transientKey = this.transientStore.writeBlob(blobWriteContext.copyWithKey(this.randomString()));
                key = blobWriteContext.getKey();
            }
            try {
                this.checkConcurrentUpdate(key);
            }
            catch (ConcurrentUpdateException e) {
                this.transientStore.deleteBlob(transientKey);
                throw e;
            }
            this.putTransientKey(key, transientKey);
            this.logTrace("rnote over Nuxeo: " + key);
            this.logTrace("end");
            return key;
        }
        return this.store.writeBlob(blobWriteContext);
    }

    @Override
    public boolean copyBlob(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlobStore.OptionalOrUnknown<Path> getFile(String key) {
        if (TransactionHelper.isTransactionActive()) {
            String transientKey = this.getTransientKey(key);
            if (TransactionalBlobStore.isDeleteMarker(transientKey)) {
                return BlobStore.OptionalOrUnknown.missing();
            }
            if (transientKey != null) {
                return this.transientStore.getFile(transientKey);
            }
        }
        return this.store.getFile(key);
    }

    @Override
    public BlobStore.OptionalOrUnknown<InputStream> getStream(String key) throws IOException {
        if (TransactionHelper.isTransactionActive()) {
            String transientKey = this.getTransientKey(key);
            if (TransactionalBlobStore.isDeleteMarker(transientKey)) {
                return BlobStore.OptionalOrUnknown.missing();
            }
            if (transientKey != null) {
                BlobStore.OptionalOrUnknown<InputStream> streamOpt = this.transientStore.getStream(transientKey);
                if (!streamOpt.isPresent()) {
                    log.error("Missing blob from transient blob store: " + transientKey);
                }
                return streamOpt;
            }
        }
        return this.store.getStream(key);
    }

    @Override
    public boolean readBlob(String key, Path file) throws IOException {
        if (TransactionHelper.isTransactionActive()) {
            boolean found;
            this.logTrace("group tx read");
            this.logTrace("rnote over Nuxeo: " + key);
            String transientKey = this.getTransientKey(key);
            if (TransactionalBlobStore.isDeleteMarker(transientKey)) {
                this.logTrace("<--", "deleted");
                found = false;
            } else if (transientKey != null) {
                found = this.transientStore.readBlob(transientKey, file);
                if (!found) {
                    log.error("Missing blob from transient blob store: " + transientKey);
                }
            } else {
                found = this.store.readBlob(key, file);
            }
            this.logTrace("end");
            return found;
        }
        return this.store.readBlob(key, file);
    }

    @Override
    public void writeBlobProperties(BlobUpdateContext blobUpdateContext) throws IOException {
        if (TransactionHelper.isTransactionActive()) {
            String key = blobUpdateContext.key;
            this.checkConcurrentUpdate(key);
            this.putTransientUpdate(key, blobUpdateContext);
        } else {
            this.store.writeBlobProperties(blobUpdateContext);
        }
    }

    @Override
    public void deleteBlob(String key) {
        if (TransactionHelper.isTransactionActive()) {
            this.checkConcurrentUpdate(key);
            this.putTransientKey(key, DELETE_MARKER);
        } else {
            this.store.deleteBlob(key);
        }
    }

    protected void checkConcurrentUpdate(String key) {
        Transaction tx = this.getTransaction();
        Transaction otherTx = this.keysInActiveTransactions.putIfAbsent(key, tx);
        if (otherTx != null) {
            if (otherTx != tx) {
                throw new ConcurrentUpdateException(key);
            }
            String otherTransientKey = this.getTransientKey(key);
            if (otherTransientKey != null && !TransactionalBlobStore.isDeleteMarker(otherTransientKey)) {
                this.transientStore.deleteBlob(otherTransientKey);
            }
        }
    }

    protected Transaction getTransaction() {
        try {
            return NuxeoContainer.getTransactionManager().getTransaction();
        }
        catch (NullPointerException | SystemException e) {
            throw new NuxeoException(e);
        }
    }

    protected String getTransientKey(String key) {
        Map<String, TransientInfo> map = this.transientInfo.get();
        if (map == null) {
            return null;
        }
        TransientInfo info = map.get(key);
        return info == null ? null : info.transientKey;
    }

    protected void putTransientKey(String key, String transientKey) {
        TransientInfo info = this.getTransientInfo(key);
        info.transientKey = transientKey;
    }

    protected void putTransientUpdate(String key, BlobUpdateContext blobUpdateContext) {
        TransientInfo info = this.getTransientInfo(key);
        if (info.blobUpdateContext == null) {
            info.blobUpdateContext = blobUpdateContext;
        } else {
            info.blobUpdateContext.with(blobUpdateContext);
        }
    }

    protected TransientInfo getTransientInfo(String key) {
        Map<String, TransientInfo> map = this.transientInfo.get();
        if (map == null) {
            map = new HashMap<String, TransientInfo>();
            this.transientInfo.set(map);
            TransactionHelper.registerSynchronization((Synchronization)this);
        }
        return map.computeIfAbsent(key, k -> new TransientInfo());
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        block19: {
            Map<String, TransientInfo> map = this.transientInfo.get();
            this.transientInfo.remove();
            try {
                if (status == 3) {
                    this.logTrace("== TX commit ==");
                    for (Map.Entry<String, TransientInfo> en : map.entrySet()) {
                        BlobUpdateContext blobUpdateContext;
                        String key = en.getKey();
                        TransientInfo info = en.getValue();
                        String transientKey = info.transientKey;
                        boolean applyUpdates = false;
                        if (transientKey != null) {
                            if (TransactionalBlobStore.isDeleteMarker(transientKey)) {
                                this.store.deleteBlob(key);
                            } else if (this.hasVersioning()) {
                                applyUpdates = true;
                            } else {
                                try {
                                    boolean found = this.store.copyBlob(key, this.transientStore, transientKey, true);
                                    if (found) {
                                        applyUpdates = true;
                                    } else {
                                        log.error("Missing blob from transient blob store: " + transientKey + ", failed to commit creation of file: " + key);
                                    }
                                }
                                catch (IOException e) {
                                    log.error("Failed to commit creation of blob: " + key, (Throwable)e);
                                }
                            }
                        }
                        if (!applyUpdates || (blobUpdateContext = info.blobUpdateContext) == null) continue;
                        try {
                            this.store.writeBlobProperties(blobUpdateContext);
                        }
                        catch (IOException e) {
                            log.error("Failed to commit update of blob: " + key, (Throwable)e);
                        }
                    }
                    break block19;
                }
                if (status == 4) {
                    this.logTrace("== TX rollback ==");
                    for (TransientInfo info : map.values()) {
                        String transientKey = info.transientKey;
                        if (transientKey == null || TransactionalBlobStore.isDeleteMarker(transientKey)) continue;
                        this.transientStore.deleteBlob(transientKey);
                    }
                } else {
                    log.error("Unexpected afterCompletion status: " + status);
                }
            }
            finally {
                this.logTrace("== TX end ==");
                this.keysInActiveTransactions.keySet().removeAll(map.keySet());
            }
        }
    }

    public static class TransientInfo {
        public String transientKey;
        public BlobUpdateContext blobUpdateContext;
    }
}

