/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.we;

import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.connect.data.DownloadablePackage;

public class StudioSnapshotHelper {
    public static final String SNAPSHOT_SUFFIX = "0.0.0-SNAPSHOT";

    private StudioSnapshotHelper() {
    }

    public static boolean isSnapshot(DownloadablePackage pkg) {
        return pkg.getVersion() != null && pkg.getVersion().toString().endsWith(SNAPSHOT_SUFFIX);
    }

    public static List<DownloadablePackage> removeSnapshot(List<DownloadablePackage> pkgs) {
        return pkgs.stream().filter(pkg -> !StudioSnapshotHelper.isSnapshot(pkg)).collect(Collectors.toList());
    }

    public static DownloadablePackage getSnapshot(List<DownloadablePackage> pkgs) {
        return pkgs.stream().filter(StudioSnapshotHelper::isSnapshot).findFirst().orElse(null);
    }
}

