/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.runtime;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.task.standalone.InstallTask;
import org.nuxeo.connect.update.task.standalone.UninstallTask;
import org.nuxeo.connect.update.task.update.Rollback;
import org.nuxeo.connect.update.task.update.RollbackOptions;
import org.nuxeo.connect.update.task.update.Update;
import org.nuxeo.connect.update.task.update.UpdateManager;
import org.nuxeo.connect.update.task.update.UpdateOptions;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadContext;
import org.nuxeo.runtime.reload.ReloadResult;
import org.nuxeo.runtime.reload.ReloadService;
import org.osgi.framework.BundleException;

public class ReloadHelper {
    private static final Logger log = LogManager.getLogger(ReloadHelper.class);

    public static synchronized void hotReloadPackage(String packageId) {
        log.info("Reload Studio package with id={}", (Object)packageId);
        LocalPackage pkg = null;
        InstallTask installTask = null;
        try {
            ReloadService reloadService = (ReloadService)Framework.getService(ReloadService.class);
            ReloadContext reloadContext = new ReloadContext();
            PackageManager pm = (PackageManager)Framework.getService(PackageManager.class);
            PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
            pkg = pus.getPackage(packageId);
            if (pkg != null) {
                if (pkg.getPackageState().isInstalled()) {
                    if (pkg.getUninstallFile().exists()) {
                        UninstallTask uninstallTask = (UninstallTask)pkg.getUninstallTask();
                        uninstallTask.getCommands().stream().filter(Rollback.class::isInstance).map(Rollback.class::cast).map(Rollback::getRollbackOptions).map(arg_0 -> ((UpdateManager)uninstallTask.getUpdateManager()).getRollbackTarget(arg_0)).map(arg_0 -> ((ReloadService)reloadService).getOSGIBundleName(arg_0)).forEachOrdered(xva$0 -> reloadContext.undeploy(new String[]{xva$0}));
                    } else {
                        log.warn("Unable to uninstall previous bundle because {} doesn't exist", (Object)pkg.getUninstallFile());
                    }
                }
                pus.removePackage(pkg.getId());
            }
            ArrayList<String> messages = new ArrayList<String>();
            DownloadingPackage downloadingPkg = pm.download(packageId);
            while (!downloadingPkg.isCompleted()) {
                log.trace("Downloading studio snapshot package: {}", (Object)packageId);
                if (StringUtils.isNotEmpty((CharSequence)downloadingPkg.getErrorMessage())) {
                    messages.add(downloadingPkg.getErrorMessage());
                }
                Thread.sleep(100L);
            }
            log.info("Installing {}", (Object)packageId);
            pkg = pus.getPackage(packageId);
            if (pkg == null || PackageState.DOWNLOADED != pkg.getPackageState()) {
                NuxeoException nuxeoException = new NuxeoException(String.format("Error while downloading studio snapshot: %s, package Id: %s", pkg, packageId));
                messages.forEach(arg_0 -> ((NuxeoException)nuxeoException).addInfo(arg_0));
                throw nuxeoException;
            }
            installTask = (InstallTask)pkg.getInstallTask();
            pus.setPackageState(pkg, PackageState.INSTALLING);
            installTask.getCommands().stream().filter(Update.class::isInstance).map(Update.class::cast).map(Update::getFile).forEachOrdered(xva$0 -> reloadContext.deploy(new File[]{xva$0}));
            ReloadResult result = reloadService.reloadBundles(reloadContext);
            pus.setPackageState(pkg, PackageState.STARTED);
            String id = pkg.getId();
            Version version = pkg.getVersion();
            result.deployedFilesAsStream().map(f -> UpdateOptions.newInstance((String)id, (File)f, (File)f.getParentFile())).map(arg_0 -> ((UpdateManager)installTask.getUpdateManager()).getKey(arg_0)).map(key -> new RollbackOptions(id, key, version.toString())).map(Rollback::new).forEachOrdered(installTask.getCommandLog()::add);
        }
        catch (ConnectServerError | PackageException | BundleException e) {
            throw new NuxeoException("Error while updating studio snapshot", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException("Error while downloading studio snapshot", (Throwable)e);
        }
        finally {
            if (pkg != null && installTask != null) {
                File file = pkg.getData().getEntry("uninstall.xml");
                try {
                    installTask.writeLog(file);
                }
                catch (PackageException e) {
                    log.error("Exception when writing uninstall.xml", (Throwable)e);
                }
            }
        }
    }
}

