/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mem;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.ScrollResultImpl;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.StateHelper;
import org.nuxeo.ecm.core.storage.dbs.DBSConnection;
import org.nuxeo.ecm.core.storage.dbs.DBSConnectionBase;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.dbs.DBSTransactionState;
import org.nuxeo.ecm.core.storage.mem.MemRepository;

public class MemConnection
extends DBSConnectionBase {
    private static final Log log = LogFactory.getLog(MemRepository.class);
    protected static final String NOSCROLL_ID = "noscroll";
    protected Map<String, State> states;

    public MemConnection(MemRepository repository) {
        super((DBSRepositoryBase)repository);
        this.states = repository.states;
    }

    public void begin() {
    }

    public void commit() {
    }

    public void rollback() {
    }

    protected void initRepository() {
        this.initRoot();
    }

    public void close() {
    }

    public String generateNewId() {
        return ((MemRepository)this.repository).generateNewId();
    }

    public State readState(String id) {
        return this.readPartialState(id, null);
    }

    public State readPartialState(String id, Collection<String> keys) {
        if (id == null) {
            return null;
        }
        State state = this.states.get(id);
        if (state != null) {
            if (keys != null && !keys.isEmpty()) {
                State partialState = new State();
                for (String key : keys) {
                    Serializable value = state.get((Object)key);
                    if (value == null) continue;
                    partialState.put(key, value);
                }
                state = partialState;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Mem: READ  " + id + ": " + state));
            }
        }
        return state;
    }

    public List<State> readStates(List<String> ids) {
        ArrayList<State> list = new ArrayList<State>();
        for (String id : ids) {
            list.add(this.readState(id));
        }
        return list;
    }

    public void createState(State state) {
        String id = (String)((Object)state.get((Object)"ecm:id"));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mem: CREATE " + id + ": " + state));
        }
        if (this.states.containsKey(id)) {
            throw new NuxeoException("Already exists: " + id);
        }
        state = StateHelper.deepCopy((State)state, (boolean)true);
        StateHelper.resetDeltas((State)state);
        this.states.put(id, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(String id, State.StateDiff diff, DBSTransactionState.ChangeTokenUpdater changeTokenUpdater) {
        State state;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mem: UPDATE " + id + ": " + diff));
        }
        if ((state = this.states.get(id)) == null) {
            throw new ConcurrentUpdateException("Missing: " + id);
        }
        State state2 = state;
        synchronized (state2) {
            if (changeTokenUpdater != null) {
                for (Map.Entry en : changeTokenUpdater.getConditions().entrySet()) {
                    if (Objects.equals(state.get(en.getKey()), en.getValue())) continue;
                    throw new ConcurrentUpdateException((String)((Object)state.get((Object)"ecm:id")));
                }
                for (Map.Entry en : changeTokenUpdater.getUpdates().entrySet()) {
                    MemConnection.applyDiff(state, (String)en.getKey(), (Serializable)en.getValue());
                }
            }
            MemConnection.applyDiff(state, diff);
        }
    }

    public void deleteStates(Set<String> ids) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mem: REMOVE " + ids));
        }
        for (String id : ids) {
            if (this.states.remove(id) != null) continue;
            log.debug((Object)("Missing on remove: " + id));
        }
    }

    public State readChildState(String parentId, String name, Set<String> ignored) {
        for (State state : this.states.values()) {
            if (ignored.contains(state.get((Object)"ecm:id")) || !parentId.equals(state.get((Object)"ecm:parentId")) || !name.equals(state.get((Object)"ecm:name"))) continue;
            return state;
        }
        return null;
    }

    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        return this.readChildState(parentId, name, ignored) != null;
    }

    public List<State> queryKeyValue(String key, Object value, Set<String> ignored) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mem: QUERY " + key + " = " + value));
        }
        ArrayList<State> list = new ArrayList<State>();
        for (State state : this.states.values()) {
            String id = (String)((Object)state.get((Object)"ecm:id"));
            if (ignored.contains(id) || !value.equals(state.get((Object)key))) continue;
            list.add(state);
        }
        if (log.isTraceEnabled() && !list.isEmpty()) {
            log.trace((Object)("Mem:    -> " + list.size()));
        }
        return list;
    }

    public List<State> queryKeyValue(String key1, Object value1, String key2, Object value2, Set<String> ignored) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mem: QUERY " + key1 + " = " + value1 + " AND " + key2 + " = " + value2));
        }
        ArrayList<State> list = new ArrayList<State>();
        for (State state : this.states.values()) {
            String id = (String)((Object)state.get((Object)"ecm:id"));
            if (ignored.contains(id) || !value1.equals(state.get((Object)key1)) || !value2.equals(state.get((Object)key2))) continue;
            list.add(state);
        }
        if (log.isTraceEnabled() && !list.isEmpty()) {
            log.trace((Object)("Mem:    -> " + list.size()));
        }
        return list;
    }

    public Stream<State> getDescendants(String rootId, Set<String> keys) {
        return this.getDescendants(rootId, keys, 0);
    }

    public Stream<State> getDescendants(String rootId, Set<String> keys, int limit) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mem: QUERY ecm:ancestorIds = " + rootId));
        }
        Stream<State> stream = this.states.values().stream().filter(state -> MemConnection.hasAncestor(state, rootId));
        if (limit != 0) {
            stream = stream.limit(limit);
        }
        return stream;
    }

    protected static boolean hasAncestor(State state, String id) {
        Object[] array = (Object[])state.get((Object)"ecm:ancestorIds");
        return array == null ? false : Arrays.asList(array).contains(id);
    }

    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mem: QUERY " + key + " = " + value));
        }
        for (State state : this.states.values()) {
            String id = (String)((Object)state.get((Object)"ecm:id"));
            if (ignored.contains(id) || !value.equals(state.get((Object)key))) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)"Mem:    -> present");
            }
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Mem:    -> absent");
        }
        return false;
    }

    public PartialList<Map<String, Serializable>> queryAndFetch(DBSExpressionEvaluator evaluator, OrderByClause orderByClause, boolean distinctDocuments, int limit, int offset, int countUpTo) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mem: QUERY " + evaluator + " OFFSET " + offset + " LIMIT " + limit));
        }
        evaluator.parse();
        ArrayList<Map> projections = new ArrayList<Map>();
        for (State state : this.states.values()) {
            List matches = evaluator.matches(state);
            if (matches.isEmpty()) continue;
            if (distinctDocuments) {
                projections.add((Map)matches.get(0));
                continue;
            }
            projections.addAll(matches);
        }
        if (orderByClause != null) {
            Collections.sort(projections, new DBSSession.OrderByComparator(orderByClause));
        }
        int totalSize = projections.size();
        if (countUpTo != -1) {
            if (countUpTo == 0) {
                totalSize = -1;
            } else if (totalSize > countUpTo) {
                totalSize = -2;
            }
        }
        if (limit != 0) {
            int size = projections.size();
            projections.subList(0, offset > size ? size : offset).clear();
            size = projections.size();
            if (limit < size) {
                projections.subList(limit, size).clear();
            }
        }
        if (log.isTraceEnabled() && !projections.isEmpty()) {
            log.trace((Object)("Mem:    -> " + projections.size()));
        }
        return new PartialList(projections, (long)totalSize);
    }

    public ScrollResult<String> scroll(DBSExpressionEvaluator evaluator, int batchSize, int keepAliveSeconds) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mem: QUERY " + evaluator));
        }
        evaluator.parse();
        ArrayList<String> ids = new ArrayList<String>();
        for (State state : this.states.values()) {
            List matches = evaluator.matches(state);
            if (matches.isEmpty()) continue;
            String id = ((Serializable)((Map)matches.get(0)).get("ecm:uuid")).toString();
            ids.add(id);
        }
        return new ScrollResultImpl(NOSCROLL_ID, ids);
    }

    public ScrollResult<String> scroll(String scrollId) {
        if (NOSCROLL_ID.equals(scrollId)) {
            return ScrollResultImpl.emptyResult();
        }
        throw new NuxeoException("Unknown or timed out scrollId");
    }

    public static void applyDiff(State state, State.StateDiff stateDiff) {
        for (Map.Entry en : stateDiff.entrySet()) {
            MemConnection.applyDiff(state, (String)en.getKey(), (Serializable)en.getValue());
        }
    }

    protected static void applyDiff(State state, String key, Serializable value) {
        if (value instanceof State.StateDiff) {
            Serializable old = state.get((Object)key);
            if (old == null) {
                old = new State(true);
                state.put(key, old);
            }
            if (!(old instanceof State)) {
                throw new UnsupportedOperationException("Cannot apply StateDiff on non-State: " + old);
            }
            MemConnection.applyDiff((State)old, (State.StateDiff)value);
        } else if (value instanceof State.ListDiff) {
            state.put(key, MemConnection.applyDiff(state.get((Object)key), (State.ListDiff)value));
        } else if (value instanceof Delta) {
            Delta delta = (Delta)value;
            Number oldValue = (Number)state.get((Object)key);
            Number newValue = oldValue == null ? (Number)delta.getFullValue() : (Number)delta.add(oldValue);
            state.put(key, (Serializable)newValue);
        } else {
            state.put(key, StateHelper.deepCopy((Object)value, (boolean)true));
        }
    }

    public static Serializable applyDiff(Serializable value, State.ListDiff listDiff) {
        Class<?> arrayComponentType = null;
        if (listDiff.isArray && value != null) {
            if (!(value instanceof Object[])) {
                throw new UnsupportedOperationException("Cannot apply ListDiff on non-array: " + value);
            }
            arrayComponentType = ((Object[])value).getClass().getComponentType();
            value = new CopyOnWriteArrayList<Object>(Arrays.asList((Object[])value));
        }
        if (value == null) {
            value = new CopyOnWriteArrayList();
        }
        if (!(value instanceof List)) {
            throw new UnsupportedOperationException("Cannot apply ListDiff on non-List: " + value);
        }
        List list = value;
        if (listDiff.diff != null) {
            int i = 0;
            for (Object diffElem : listDiff.diff) {
                if (i >= list.size()) break;
                if (diffElem instanceof State.StateDiff) {
                    MemConnection.applyDiff((State)list.get(i), (State.StateDiff)diffElem);
                } else if (diffElem != State.NOP) {
                    list.set(i, StateHelper.deepCopy(diffElem, (boolean)true));
                }
                ++i;
            }
        }
        if (listDiff.rpush != null) {
            ArrayList<Serializable> add = new ArrayList<Serializable>(listDiff.rpush.size());
            for (Object v : listDiff.rpush) {
                add.add(StateHelper.deepCopy(v, (boolean)true));
            }
            list.addAll(add);
        }
        if (listDiff.isArray) {
            return list.isEmpty() ? null : list.toArray((Object[])Array.newInstance(arrayComponentType, list.size()));
        }
        return list.isEmpty() ? null : (Serializable)((Object)list);
    }

    public synchronized Lock getLock(String id) {
        State state = this.states.get(id);
        if (state == null) {
            throw new DocumentNotFoundException(id);
        }
        String owner = (String)((Object)state.get((Object)"ecm:lockOwner"));
        if (owner == null) {
            return null;
        }
        Calendar created = (Calendar)state.get((Object)"ecm:lockCreated");
        return new Lock(owner, created);
    }

    public synchronized Lock setLock(String id, Lock lock) {
        State state = this.states.get(id);
        if (state == null) {
            throw new DocumentNotFoundException(id);
        }
        String owner = (String)((Object)state.get((Object)"ecm:lockOwner"));
        if (owner != null) {
            Calendar created = (Calendar)state.get((Object)"ecm:lockCreated");
            return new Lock(owner, created);
        }
        state.put("ecm:lockOwner", (Serializable)((Object)lock.getOwner()));
        state.put("ecm:lockCreated", (Serializable)lock.getCreated());
        return null;
    }

    public synchronized Lock removeLock(String id, String owner) {
        State state = this.states.get(id);
        if (state == null) {
            throw new DocumentNotFoundException(id);
        }
        String oldOwner = (String)((Object)state.get((Object)"ecm:lockOwner"));
        if (oldOwner == null) {
            return null;
        }
        Calendar oldCreated = (Calendar)state.get((Object)"ecm:lockCreated");
        if (!LockManager.canLockBeRemoved((String)oldOwner, (String)owner)) {
            return new Lock(oldOwner, oldCreated, true);
        }
        state.put("ecm:lockOwner", null);
        state.put("ecm:lockCreated", null);
        return new Lock(oldOwner, oldCreated);
    }

    public List<State> queryKeyValueWithOperator(String key1, Object value1, String key2, DBSConnection.DBSQueryOperator operator, Object value2, Set<String> ignored) {
        throw new UnsupportedOperationException();
    }
}

