/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.core.helpers.TaskActorsHelper;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class RoutingTaskPageProvider
extends AbstractPageProvider<Task> {
    private static final long serialVersionUID = 1L;

    public List<Task> getCurrentPage() {
        Object[] parameters = this.getParameters();
        if (parameters == null || parameters.length != 2) {
            throw new IllegalStateException("Invalid parameters: " + Arrays.toString(parameters));
        }
        String actorId = (String)parameters[0];
        String workflowInstanceId = (String)parameters[1];
        CoreSession session = this.getCoreSession();
        StringBuilder query = new StringBuilder(String.format("SELECT * FROM Document WHERE ecm:mixinType = '%s' AND ecm:currentLifeCycleState = '%s'", "Task", "opened"));
        if (StringUtils.isNotBlank((CharSequence)actorId)) {
            ArrayList<String> actors = new ArrayList<String>();
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            NuxeoPrincipal principal = userManager.getPrincipal(actorId);
            if (principal != null) {
                for (String actor : TaskActorsHelper.getTaskActors((NuxeoPrincipal)principal)) {
                    actors.add(NXQL.escapeString((String)actor));
                }
            } else {
                actors.add(NXQL.escapeString((String)actorId));
            }
            String actorsParam = String.join((CharSequence)", ", actors);
            query.append(String.format(" AND (nt:actors/* IN (%s) OR nt:delegatedActors/* IN (%s))", actorsParam, actorsParam));
        }
        if (StringUtils.isNotBlank((CharSequence)workflowInstanceId)) {
            query.append(String.format(" AND nt:processId = %s", NXQL.escapeString((String)workflowInstanceId)));
        }
        query.append(String.format(" ORDER BY %s ASC", "nt:dueDate"));
        PartialList results = session.queryProjection(query.toString(), this.getPageSize(), this.getCurrentPageOffset(), true);
        this.setResultsCount(results.totalSize());
        return results.stream().map(map -> session.getDocument((DocumentRef)new IdRef((String)map.get("ecm:uuid")))).map(doc -> (Task)doc.getAdapter(Task.class)).collect(Collectors.toList());
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get("coreSession");
        if (coreSession == null) {
            throw new NuxeoException("cannot find core session");
        }
        return coreSession;
    }
}

