/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.multipdf.PageExtractor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.pdf.PDFUtils;
import org.nuxeo.runtime.api.Framework;

public class PDFPageExtractor {
    private Blob pdfBlob;
    private String password;

    public PDFPageExtractor(Blob inBlob) {
        this.pdfBlob = inBlob;
    }

    public PDFPageExtractor(DocumentModel inDoc, String inXPath) {
        if (StringUtils.isBlank((CharSequence)inXPath)) {
            inXPath = "file:content";
        }
        this.pdfBlob = (Blob)inDoc.getPropertyValue(inXPath);
    }

    public Blob extract(int inStartPage, int inEndPage) {
        return this.extract(inStartPage, inEndPage, null, null, null, null);
    }

    private String getFileName(Blob blob) {
        String originalName = blob.getFilename();
        if (StringUtils.isBlank((CharSequence)originalName)) {
            return "extracted";
        }
        int pos = originalName.toLowerCase().lastIndexOf(".pdf");
        if (pos > 0) {
            originalName = originalName.substring(0, pos);
        }
        return originalName;
    }

    public Blob extract(int inStartPage, int inEndPage, String inFileName, String inTitle, String inSubject, String inAuthor) throws NuxeoException {
        FileBlob result;
        try (PDDocument pdfDoc = PDFUtils.load(this.pdfBlob, this.password);){
            PageExtractor pe = new PageExtractor(pdfDoc, inStartPage, inEndPage);
            PDDocument extracted = pe.extract();
            PDFUtils.setInfos(extracted, inTitle, inSubject, inAuthor);
            result = PDFUtils.saveInTempFile(extracted);
            result.setMimeType("application/pdf");
            if (StringUtils.isBlank((CharSequence)inFileName)) {
                inFileName = this.getFileName(this.pdfBlob) + "-" + inStartPage + "-" + inEndPage + ".pdf";
            }
            result.setFilename((String)inFileName);
            extracted.close();
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to extract the pages", (Throwable)e);
        }
        return result;
    }

    public BlobList getPagesAsImages(String inFileName) throws NuxeoException {
        ImageIO.scanForPlugins();
        BlobList results = new BlobList();
        if (StringUtils.isBlank((CharSequence)inFileName)) {
            inFileName = this.getFileName(this.pdfBlob) + ".pdf";
        }
        try (PDDocument pdfDoc = PDFUtils.load(this.pdfBlob, this.password);){
            PDFRenderer pdfRenderer = new PDFRenderer(pdfDoc);
            int pageno = 0;
            for (PDPage page : pdfDoc.getDocumentCatalog().getPages()) {
                String resultFileName = (String)inFileName + "-" + ++pageno;
                BufferedImage bim = pdfRenderer.renderImageWithDPI(pageno - 1, 300.0f, ImageType.RGB);
                File resultFile = Framework.createTempFile((String)resultFileName, (String)".png");
                FileOutputStream resultFileStream = new FileOutputStream(resultFile);
                ImageIOUtil.writeImage((BufferedImage)bim, (String)"png", (OutputStream)resultFileStream, (int)300);
                FileBlob result = new FileBlob(resultFile);
                result.setFilename(resultFileName + ".png");
                result.setMimeType("picture/png");
                results.add((Object)result);
                Framework.trackFile((File)resultFile, (Object)result);
            }
            pdfDoc.close();
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to extract the pages", (Throwable)e);
        }
        return results;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

