/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.uidgen;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.ecm.core.uidgen.AbstractUIDSequencer;
import org.nuxeo.ecm.platform.uidgen.UIDSequenceBean;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class JPAUIDSequencerImpl
extends AbstractUIDSequencer {
    public static final int POOL_SIZE = 1;
    public static final int MAX_POOL_SIZE = 2;
    public static final long KEEP_ALIVE_TIME = 10L;
    public static final int QUEUE_SIZE = 1000;
    private static volatile PersistenceProvider persistenceProvider;
    protected ThreadPoolExecutor tpe;

    public void init() {
        if (this.tpe != null && !this.tpe.isShutdown()) {
            this.tpe.shutdownNow();
        }
        this.tpe = new ThreadPoolExecutor(1, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000));
    }

    public void dispose() {
        JPAUIDSequencerImpl.deactivatePersistenceProvider();
        this.tpe.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PersistenceProvider getOrCreatePersistenceProvider() {
        if (persistenceProvider != null) return persistenceProvider;
        Class<JPAUIDSequencerImpl> clazz = JPAUIDSequencerImpl.class;
        synchronized (JPAUIDSequencerImpl.class) {
            if (persistenceProvider != null) return persistenceProvider;
            JPAUIDSequencerImpl.activatePersistenceProvider();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return persistenceProvider;
        }
    }

    protected static void activatePersistenceProvider() {
        Thread thread = Thread.currentThread();
        ClassLoader last = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(PersistenceProvider.class.getClassLoader());
            PersistenceProviderFactory persistenceProviderFactory = (PersistenceProviderFactory)Framework.getService(PersistenceProviderFactory.class);
            persistenceProvider = persistenceProviderFactory.newProvider("NXUIDSequencer");
            persistenceProvider.openPersistenceUnit();
        }
        finally {
            thread.setContextClassLoader(last);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void deactivatePersistenceProvider() {
        if (persistenceProvider == null) return;
        Class<JPAUIDSequencerImpl> clazz = JPAUIDSequencerImpl.class;
        synchronized (JPAUIDSequencerImpl.class) {
            if (persistenceProvider == null) return;
            persistenceProvider.closePersistenceUnit();
            persistenceProvider = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void initSequence(String key, long id) {
        while (this.getNextLong(key) < id) {
        }
    }

    public long getNextLong(String key) {
        SeqRunner runner = new SeqRunner(key);
        Future<?> future = this.tpe.submit(runner);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new NuxeoException((Throwable)e);
        }
        return runner.getResult();
    }

    protected int doGetNext(final String key) {
        return (Integer)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Integer>(){

            public Integer runWith(EntityManager em) {
                return JPAUIDSequencerImpl.this.getNext(em, key);
            }
        });
    }

    protected int getNext(EntityManager em, String key) {
        UIDSequenceBean seq;
        try {
            seq = (UIDSequenceBean)em.createNamedQuery("UIDSequence.findByKey").setParameter("key", (Object)key).getSingleResult();
        }
        catch (NoResultException e) {
            seq = new UIDSequenceBean(key);
            em.persist((Object)seq);
        }
        return seq.nextIndex();
    }

    protected class SeqRunner
    implements Runnable {
        protected final String key;
        protected int result;
        protected boolean completed = false;

        public SeqRunner(String key) {
            this.key = key;
        }

        @Override
        public void run() {
            TransactionHelper.startTransaction();
            try {
                this.result = JPAUIDSequencerImpl.this.doGetNext(this.key);
                this.completed = true;
            }
            finally {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }

        public int getResult() {
            return this.result;
        }

        public boolean isCompleted() {
            return this.completed;
        }
    }
}

