/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OOoXmlContentHandler
extends DefaultHandler {
    protected static final Log log = LogFactory.getLog(OOoXmlContentHandler.class);
    protected final StringBuilder sb = new StringBuilder();
    protected final Stack<String> path = new Stack();
    protected boolean dumpText = false;
    protected boolean isSpreadSheet = false;

    public String getContent() {
        return this.sb.toString();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.path.push(qName);
        if (qName.equals("office:spreadsheet")) {
            this.isSpreadSheet = true;
        }
        if (qName.startsWith("text:")) {
            this.dumpText = true;
        }
        if (qName.equals("text:h")) {
            this.sb.append("\n");
            String outlineLevelAtt = atts.getValue("text:outline-level");
            if (!StringUtils.isEmpty((CharSequence)outlineLevelAtt)) {
                int outlineLevel = -1;
                try {
                    outlineLevel = Integer.parseInt(outlineLevelAtt);
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)"Attribute 'text:outline-level' on element 'text:h' has a non integer value.");
                }
                if (outlineLevel > 1) {
                    this.sb.append("\n");
                }
            }
        }
        if (!this.isSpreadSheet && qName.equals("text:p")) {
            this.sb.append("\n");
        }
        if (qName.equals("draw:page") && !"page1".equals(atts.getValue("draw:name"))) {
            this.sb.append("\n");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.dumpText) {
            String content = String.valueOf(ch, start, length);
            this.sb.append(content);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.path.pop();
        if (this.path.isEmpty() || !((String)this.path.lastElement()).startsWith("text:")) {
            this.dumpText = false;
        }
        if (this.isSpreadSheet) {
            if (qName.equals("table:table-row")) {
                this.sb.append("\n\n");
            }
            if (qName.equals("table:table-cell")) {
                this.sb.append(" ");
            }
            if (qName.equals("text:p")) {
                this.sb.append(" ");
            }
        }
    }
}

